
cross3[v1_, v2_]  := (Det[{IdentityMatrix[3], v1, v2}]);
cross[v1_, v2_, v3_]  := (Det[{IdentityMatrix[4], v1, v2, v3}]);

Clear[a,b,c,d,n1,n2,n3,n4];
{a,b,c,d} = {{0,1,0},{0,-1,0},{1,0,2^.5},{-1,0,2^.5}};
n1 = cross3[b-a,c-a];
n2 = cross3[c-b,d-b];
n3 = cross3[d-a,c-a];
n4 = cross3[b-a,d-a];
total = {-n1,n2,n3,n4};
cons = {-n1.a,n2.b,n3.a,n4.a};
tetrahedron = Transpose[{total,cons}];

total = {{1,0,0},{0,1,0},{0,0,1},{-1,0,0},{0,-1,0},{0,0,-1}};
cons = {1,1,1,1,1,1};
cube = Transpose[{total,cons}];

Clear[a,b,c,d,f];
a = {1,0,-.35355,0};b={-.5,.866,-.35355,0};c={-.5,-.866,-.35355,0};
d={0,0,1.06066,0};e={0,0,0,1.3693};
n1 = cross[d-a,c-a,b-a];
n2 = cross[e-a,d-a,b-a];
n3 = cross[e-a,c-a,b-a];
n4 = cross[e-a,d-a,c-a];
n5 = cross[e-b,d-b,c-b];
total = {-n1,-n2,n3,n4,-n5};
cons = {n1.a,-n2.a,n3.a,n4.a,-n5.b};
simplex = Transpose[{total,cons}];

Clear[a,b,c,d,f];
a = {1,0,-.35355,0};b={-.5,0.866025403784439,-.35355,0};c={-.5,-0.866025403784439,-.35355,0};
d={0,0,1.06066,0};e={0,0,0,1.3693};
n1 = cross[d-a,c-a,b-a];
n2 = cross[e-a,d-a,b-a];
n3 = cross[e-a,c-a,b-a];
n4 = cross[e-a,d-a,c-a];
n5 = cross[e-b,d-b,c-b];
n6 = cross[N[(c+a)/2]-(f=N[(b+a)/2]), N[(d+a)/2]-f, N[(e+a)/2]-f];
n7 = cross[N[(c+b)/2]-(g=N[(a+b)/2]), N[(d+b)/2]-g, N[(e+b)/2]-g];
n8 = cross[N[(b+c)/2]-(h=N[(a+c)/2]), N[(d+c)/2]-h, N[(e+c)/2]-h];
n9 = cross[N[(b+d)/2]-(i=N[(a+d)/2]), N[(c+d)/2]-i, N[(e+d)/2]-i];
n10 = cross[N[(b+e)/2]-(j=N[(a+e)/2]), N[(c+e)/2]-j, N[(d+e)/2]-j];
total = {-n1,-n2,n3,n4,-n5,-n6,n7,-n8,n9,-n10};
cons = {n1.a,-n2.a,n3.a,n4.a,-n5.b,-n6.f, n7.g, -n8.h, n9.i, -n10.j};
truncsimp = Transpose[{total,cons}];

box = {{1,0,0,0},{0,1,0,0},{0,0,1,0},{0,0,0,1},{-1,0,0,0},{0,-1,0,0},{0,0,-1,0},{0,0,0,-1}};
boxcons = {1,1,1,1,1,1,1,1};
hypercube = Transpose[{box, boxcons}];
v0={1,1,1,1};v1={1,1,1,-1};v2={1,1,-1,1};v3={1,1,-1,-1};v4={1,-1,1,1};
v5={1,-1,1,-1};v6={1,-1,-1,1};v7={1,-1,-1,-1}
v8={-1,1,1,1};v9={-1,1,1,-1};v10={-1,1,-1,1};
v11={-1,1,-1,-1};v12={-1,-1,1,1};v13={-1,-1,1,-1};v14={-1,-1,-1,1};v15={-1,-1,-1,-1};
otot = {v0,v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12,v13,v14,v15};
ocons = {.5,.5,.5,.5,.5,.5,.5,.5,.5,.5,.5,.5,.5,.5,.5,.5};
octaplex = Transpose[{otot,ocons}];

truncube = Flatten[{hypercube,octaplex}, 1];
Clear[v1, v2, v3, v4, v5, n1, n2, n3, n4, n5];
{v1,v2,v3,v4,v5} = {{1,0,0},{0,1,0},{-1,0,0},{0,-1,0},{0,0,1}};
n1 = Append[cross[v2-v5,v3-v5],0];
n2 = Append[cross[v3-v5,v4-v5],0];
n3 = Append[cross[v1-v5,v2-v5],0];
n4 = Append[cross[v1-v5,v4-v5],0];
n5 = Append[cross[v2-v1,v3-v1],0];
n6 = {0,0,0,1};
pyramidtot = {n1,n2,n3,-n4,-n5,n6,-n6};
pyracons = {n1.{0,0,1,0},n2.{0,0,1,0},n3.{0,0,1,0},-n4.{0,0,1,0},-n5.{1,0,0,0},0,0};
pyramid = Transpose[{pyramidtot, pyracons}];
