/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */


/* Generated by Interface Builder */

#import <objc/objc.h>
#import <appkit/Application.h>
#include "link_edit_types.h"
#include "link_types.h"
#include "link_edit_global.h"
#include "link.h"
#import "Link.h"
#import "EditBrancher.h"
#import "EditView.h"
#import <appkit/Panel.h>
#import <appkit/Matrix.h>
#import <appkit/Cell.h>
@implementation EditBrancher

- SJoin:sender
{
  if (gnrc) LinkModeJoinLinks(gnrc->link_status);
  return self;
}

- Flip:sender
{
  if (gnrc) LinkModeFlipCrossing(gnrc->link_status);
  return self;
}

- Alternate:sender
{
  if (gnrc) [currentLinkObj alternate];
  return self;
}

- Reflect:sender
{
  if (gnrc) [currentLinkObj reflect];
  return self;
}

- SMove:sender
{
  if (gnrc) LinkModeTranslateLink(gnrc->link_status);
  return self;
}

- PAdd:sender
{
  if (gnrc) LinkModeAddPoint(gnrc->link_status);
  return self;
}

- PAnchor:sender
{
  if (gnrc) LinkModeAddAnchor(gnrc->link_status);
  return self;
}

- PMove:sender
{
  if (gnrc) LinkModeMovePoint(gnrc->link_status);
  return self;
}

- SSelect:sender
{
  if (gnrc) LinkModeSelectLink(gnrc->link_status);
  return self;
}

- SEnd:sender
{
  if (gnrc) LinkModeCloseStrand(gnrc->link_status);
  return self;
}

- SDelete:sender
{
  if (gnrc) LinkModeDeleteStrand(gnrc->link_status);
  return self;
}

- PDelete:sender
{
  if (gnrc) LinkModeDeletePoint(gnrc->link_status);
  return self;
}

- Reverse:sender
{
  [globalEditView reverseArrows];
  return self;
}

- SOpen:sender
{
  if (gnrc) LinkModeOpenStrand(gnrc->link_status);
  return self;
}

- SBegin:sender
{
  if (!gnrc) return self;
  [globalEditView lockFocus];
  LinkCreateNewLink(gnrc->link_status);
  LinkModeAddPoint(gnrc->link_status);
  LinkPublicReDraw(gnrc->link_status);
  [globalEditView unlockFocus];
  return self;
}

- VTranslate:sender
{
  if (gnrc) LinkModeShiftView(gnrc->link_status);
  return self;
}

- VCenter:sender
{
  /* There's a weird bug here, but things work out if you center
     the link multiple times, till it settles in */
  int i;
  if (!gnrc) return self;
  for (i=0; i<5; i++)
    LinkCenterView(gnrc->link_status);
  [globalEditView lockFocus];
  [globalEditView clearScreen];
  [globalEditView ReDrawLinkTopWindow:gnrc->link_status];
  [globalEditView unlockFocus];
  
  return self;
}

- SHide:sender
{
  [globalEditView hideStrand];
  return self;
}

- VZoom:sender
{
  if (gnrc) LinkModeZoomView(gnrc->link_status);
  return self;
}

- Unhide:sender
{
  if (!gnrc) return self;
  [globalEditView lockFocus];
  LinkShowAll(gnrc->link_status);
  [globalEditView unlockFocus];
  return self;
}

- ClearAll:sender
{
  int button;
  if (!gnrc) return self;
  button = NXRunAlertPanel("Alert for doing something potentially dumb",
		  "Do you really want to erase work done in Edit Window?",
		  "Erase", "No, sorry, just kidding", NULL);
  if (button == NX_ALERTALTERNATE)
    return self;
  [globalEditView eraseWindow];
  return self;
}

- RedrawToEditor:sender
{
  [currentLinkObj redrawToEditor];
  return self;
}

@end
