/*
 * Copyright (c) 1992, The Geometry Center
 *                     University of Minnesota 
 *                     1300 South Second Street
 *                     Minneapolis, MN  55454
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *     The National Science and Technology Research Center for
 *      Computation and Visualization of Geometric Structures
 */

/* link_edit_global.h */


/* extern Display *dpy;*/
extern double xppmm,yppmm;  /* x and y pixels per millimeter */
extern double WidthMM,HeightMM;
extern LinkEditStatus *link_edit_status;
extern LinkStatus *link_status;
extern LinkData *link_data;

extern id currentLinkObj;
extern id globalEditView;
extern id globalDisplayView;
extern LinkEditStatus *gnrc;
extern int dave_file_type;    /* Determines which type the file about
				 to be saved is */
void LinkComputeDeviceCoords(LinkStatus *gnrc);
void LinkComputePointWorldCoords(LinkStatus *gnrc,LinkPointList *pnt);
void LinkComputePointDeviceCoords(LinkStatus *gnrc,LinkPointList *pnt);
LinkCrossingList *LinkFindCrossing(LinkStatus *gnrc,float x,float y);
LinkList *LinkFindLink(LinkStatus *gnrc,float x,float y);
LinkPointList *LinkFindEdge(LinkStatus *gnrc,LinkList *lnk,float x,float y);
LinkPointList *LinkFindPoint(LinkStatus *gnrc,LinkList *lnk,float x,float y);
int LinkAddPointWorldCoords(LinkStatus *gnrc, float x, float y,
			    BOOL automated, BOOL hitAutomated);
int LinkAddPoint(LinkStatus *gnrc,float x,float y);
void LinkAddAnchor(LinkStatus *gnrc, LinkList *lnk, LinkPointList *pnt, float x,float y);
int LinkAddPointAfter(LinkStatus *gnrc,LinkList *lnk,float x,float y);
void LinkFreeEdgeCrossings(LinkStatus *gnrc,LinkList *lnk,LinkPointList *pnt);
void LinkDeleteAll(LinkStatus *gnrc);
void LinkDeleteLink(LinkStatus *gnrc,LinkList *lnk);
void LinkDeletePoint(LinkStatus *gnrc,LinkList *lnk,LinkPointList *pnt);
void LinkReComputeEdgeCrossings(LinkStatus *gnrc,LinkList *lnk,LinkPointList *pnt);
void LinkFreeCrossing(LinkStatus *gnrc,LinkPointList *pnt,LinkCrossingList *crssng);
int LinkComputeEdgeCrossings(LinkStatus *gnrc,LinkList *lnk,LinkPointList *pnt);
int LinkInsertCrossing(LinkStatus *gnrc,LinkList *lnk1,
		       LinkPointList *pnt1, LinkList *lnk2,
		       LinkPointList *pnt2,
		       LinkCrossingList *crossing,
		       double param1, double param2);
int LinkEdgeCrossEdge(LinkStatus *gnrc,LinkList *lnk1,
		      LinkPointList *pnt1, LinkList *lnk2,
		      LinkPointList *pnt2, LinkCrossingList *crossing,
		      double *param1,double *param2);
void LinkClearData(LinkStatus *gnrc);
void LinkReverseArrows(LinkStatus *gnrc,LinkList *lnk);
void LinkJoinLinks(LinkStatus *gnrc, LinkList *first,LinkList *second);
void LinkPrintMessage(char *s);
LinkList *LinkCreateNewLink(LinkStatus *status);
void LinkModeNone(LinkStatus *status);
void LinkModeAddPoint(LinkStatus *status);
void LinkModeAddAnchor(LinkStatus *status);
void LinkModeDeletePoint(LinkStatus *status);
void LinkModeMovePoint(LinkStatus *status);
void LinkModeSelectLink(LinkStatus *status);
void LinkModeHideLink(LinkStatus *status);
void LinkModeTranslateLink(LinkStatus *status);
void LinkModeRotateLink(LinkStatus *status);
void LinkModeScaleLink(LinkStatus *status);
void LinkModeShiftView(LinkStatus *status);
void LinkModeFlipCrossing(LinkStatus *status);
void LinkModeZoomView(LinkStatus *status);
void LinkModeJoinLinks(LinkStatus *status);
void LinkModeReverseArrows(LinkStatus *status);
void LinkModeCloseStrand(LinkStatus *status);
void LinkModeOpenStrand(LinkStatus *status);
void LinkModeDeleteStrand(LinkStatus *status);
void LinkShowXRuler(LinkStatus *status);
void LinkShowYRuler(LinkStatus *status);
void LinkHideXRuler(LinkStatus *status);
void LinkHideYRuler(LinkStatus *status);
void LinkPublicReDraw(LinkStatus *status);
void LinkPublicClear(LinkStatus *status);
void LinkOpenCurrentLink(LinkStatus *status);
int LinkCloseCurrentLink(LinkStatus *status);
void LinkPublicPrintMessage(LinkStatus *status,char *mssg);
int LinkPublicUrgentWindowDialogue(LinkStatus *status,char *prmpt,char *rtrn);
void LinkShowAll(LinkStatus *status);
void LinkDeleteCurrentSelection(LinkStatus *status);
void LinkPublicDeleteAll(LinkStatus *status);
void LinkSetAxes(LinkStatus *status,int set);
void LinkSetArrows(LinkStatus *status,int set);
void LinkSetVertices(LinkStatus *status,int set);
void LinkSetRulers(LinkStatus *status,int set);
void LinkSetAnchors(LinkStatus *status,int set);
int LinkSaveThreeD(LinkStatus *status,char *name);
void LinkCenterView(LinkStatus *status);
void LinkCutCurrentLink(LinkStatus *status, LinkList *lnk, LinkPointList *pnt);
void LinkPause(long microsec);
void LinkDCTranslateLink(LinkStatus *gnrc,LinkList *lnk,float dx,float dy);
void LinkSetUp(id linkObj);
void LinkInitialize(id linkObj);
VOID LinkEditInitialize(id linkObj);
int LinkPrintStrand3D(LinkStatus *gnrc,FILE *fp,LinkList *lnk);
void resetVisited(LinkStatus *gnrc);
LinkCrossingList *getNextXing(LinkList *lnk, LinkPointList **pnt);
void alternateFromCrossing(LinkPointList *pnt, LinkCrossingList *xing);
void reflectLink(LinkStatus *gnrc);
