


STUFF(1)		 USER COMMANDS			 STUFF(1)



NAME
     stuff - move OOGL objects to or from shared memory

SYNOPSIS
     stuff  [-i] symbolname  [infile ...]  - infile -> memory
     stuff  -o	symbolname  [outfile]	   - memory -> outfile

DESCRIPTION
     Stuff by default reads an OOGL geometric object  from  stan-
     dard  input  or  a	 file  and stuffs it into a given shared-
     memory symbol.  With -o  it  does	the  reverse,  reading	a
     shared-memory  symbol and writing it in OOGL format to stan-
     dard output or a file.

     If	the filenames are  omitted,  stuff  reads  from	 standard
     input or writes to	standard output.

     The accepted file formats,	ASCII and binary,  are	described
     in	oogl(5).  Stuff	-o always writes in ASCII format; thus

	  stuff	thing <input; stuff -o thing >output

     could be used to convert binary-format input to ASCII-format
     output.

     Multiple objects may coexist in shared memory at once,  each
     known  by	its symbol name.  Symbol names are arbitrary; any
     ASCII string will do.  This same symbol name is accepted  by
     MinneView's -M  option.   Use  smem(1)  to	 see what symbols
     exist or to erase them.

     Stuff can be used to make movies.	When reading  from  stan-
     dard  input,  a  character	marks the end of an object; stuff
     stuffs it into the	given symbol and  continues  reading  the
     next  object.   Thus  a  program  may write a series of OOGL
     objects, terminating each with a semicolon, to a pipe to the
     "stuff"  program.	 If  MinneView	is told	to watch the same
     shared-memory symbol, its display will change as new objects
     are stuffed.  See the examples directory.

     Since  present  OOGL  object  file	 formats  will	still  be
     accepted by the next OOGL release,	programs using stuff this
     way should	not need to change.

     Stuff can also to group objects together.	If given multiple
     input  files on the command line, all the objects from those
     files are automatically combined in a List	object.	 Display-
     ing  the  resulting object	shows all the components superim-
     posed.

BUGS
     Some shared memory	(enough	for one	copy  of  an  object)  is



Geometry Center	   Last	change:	20 August 1991			1






STUFF(1)		 USER COMMANDS			 STUFF(1)



     lost each time stuff is run; it is	occasionally necessary to
     clear out the contents of shared memory.  This  may  not  be
     needed  often;  in	 typical use, clearing it once in several
     days or even weeks	may suffice.   You might periodically run
     smem with no parameters to	see how	much memory is in use; if
     more than 10-15 megabytes are, it's  time	to  run	 smem -i.
     Alternatively  you	can wait until an error	occurs;	see DIAG-
     NOSTICS.

     Note that the memory loss depends on  the	number	of  times
     stuff  is	run,  not  the	number	of  objects  sent.   When
     displaying	a series of objects, it's much more efficient  to
     run  stuff	 once and feed it a series of semicolon-separated
     objects than to run it separately on each object.

     Some diagnostic information really	 should	 be  provided  in
     case of syntax errors.  Wait for the next release.


DIAGNOSTICS
     Can't load	object from file XXX (or from stdin)
	 An unspecified	error occurred while reading the  object;
	 the  file  may	 be  unreadable, or there may be a syntax
	 error.

     GeomGrowSM: can't grow to 33554432	bytes, already	using  16
     segments
     or
     GeomGrowSM: can't shmget()	another	segment
	 Shared	memory is  full.   Try	running	 ``smem	-i''  and
	 rerunning   any  programs  (e.g.  MinneView)  which  are
	 currently using shared	memory.

SEE ALSO
     smem(1), MinneView(1)




















Geometry Center	   Last	change:	20 August 1991			2



