/* isom.d/src file gptree.c */
# include <stdio.h>
# include "defs.h"
# include "gptree.h"
void 
gt_init(gtp)
  gptree * gtp;
{
  gtp->root = gt_vertex_create();
}

void 
gt_clear(gtp)
  gptree * gtp;
{
  gt_vertex * vp1,*vp2;
  intlink * lp1,*lp2;
  gt_edge * ep1,*ep2;
  vp1 = gtp->root;
  while (vp1!=0){
    lp1 = vp1->pseq;
    while (lp1!=0) {
      lp2 = lp1->next;
      Free_dp((dp)lp1);
      lp1 = lp2;
    }
    lp1=vp1->firstai;
    while (lp1!=0) {
      lp2 = lp1->next;
      Free_dp((dp)lp1);
      lp1 = lp2;
    }
    lp1=vp1->firstord;
    while (lp1!=0) {
      lp2 = lp1->next;
      Free_dp((dp)lp1);
      lp1 = lp2;
    }
    ep1=vp1->firstedge;
    while (ep1!=0) {
      ep2 = ep1->next;
      Free_dp((dp)ep1);
      ep1 = ep2;
    }
    vp2 = vp1->next;
    Free_dp((dp)vp1);
    vp1 = vp2;
  }
}
  
gt_vertex * 
gt_vertex_create()
{
  gt_vertex * vp;
  vp = vzalloc1(gt_vertex);
  vp->subabquot = FALSE;
  vp->pseq = 0;
  vp->firstai = 0;
  vp->lastai = 0;
  vp->firstord = 0;
  vp->lastord = 0;
  vp->firstedge = 0;
  vp->lastedge = 0;
  vp->next = 0;
  return vp;
}

void 
gt_ai_append(vp,i)
  gt_vertex * vp;
  int i;
{
  intlink * lp = vp->lastai;
  intlink * newlp = vzalloc1(intlink);
  newlp->i = i;
  newlp->next = 0;
  if (lp ==0)
    vp->firstai = vp->lastai = newlp;
  else
    lp->next = vp->lastai =  newlp;
}

void 
gt_order_append(vp,i)
  gt_vertex * vp;
  int i;
{
  intlink * lp = vp->lastord;
  intlink * newlp = vzalloc1(intlink);
  newlp->i = i;
  newlp->next = 0;
  if (lp ==0)
    vp->firstord = vp->lastord = newlp;
  else
    lp->next = vp->lastord =  newlp;
}

gt_edge * 
gt_edge_append(vp,p,n)
  gt_vertex * vp;
  int p,n;
{
  gt_edge * ep = vp->lastedge;
  gt_edge * newep = vzalloc1(gt_edge);
  newep->p = p;
  newep->n = n;
  newep->target = 0;
  newep->next = 0;
  if (ep==0)
    vp->firstedge = vp->lastedge = newep;
  else
    ep->next = vp->lastedge = newep;
  return newep;
}
  
void 
gt_set_primeseq(child,parent,p)
  gt_vertex * child,* parent;
  int p;
{  
  intlink * parentlp = parent->pseq;
  intlink * childlp = child->pseq = vzalloc1(intlink);
  while (parentlp!=0){
    childlp->i = parentlp->i;
    childlp = childlp->next = vzalloc1(intlink);
    parentlp = parentlp->next;
  }  
  childlp->i = p;
  childlp->next = 0;
}
    
boolean
gt_equiv(gtp1,gtp2,diffp)
  gptree * gtp1, * gtp2;
  gt_diff * diffp;
{
  gt_vertex * vp1, * vp2;
  intlink * lp1, * lp2;
  gt_edge * ep1, * ep2;
  vp1 = gtp1->root;
  vp2 = gtp2->root;
  while (vp1!=0 &&vp2!=0){
/* first we check that the vertices are in matching positions in the two
trees; the prime sequence stored at the vertex allows us to check this */
    int sgn=0;
    lp1 = vp1->pseq;
    lp2 = vp2->pseq;
    while (lp1!=0 || lp2!=0) {
      if (lp1==0 || lp1->i<lp2->i){
        sgn = 1;
        break;
      }
      else if (lp2==0 || lp2->i<lp1->i){
        sgn = -1;
        break;  
      }
      lp1 = lp1->next;
      lp2 = lp2->next;
    }
    if (sgn==1){
      vp1 = vp1->next;
      continue;
    }
    else if (sgn==-1){
      vp2 = vp2->next;
      continue;
    }
    if ((vp1->subabquot) && (vp2->subabquot)){
/* if subabquot has completed at both vertices compare the abelian invariants */
      lp1=vp1->firstai;
      lp2=vp2->firstai;
      while (lp1!=0 || lp2!=0) {
        if (lp1==0 || lp2==0){
          diffp->type = 0;
          diffp->vp1 = vp1;
          diffp->vp2 = vp2;
          return FALSE;
        }
        if (lp1->i!=lp2->i){
          diffp->type = 0;
          diffp->vp1 = vp1;
          diffp->vp2 = vp2;
          return FALSE;
        }
        lp1 = lp1->next;
        lp2 = lp2->next;
      }
    }
/* now compare the orders */
    lp1=vp1->firstord;
    lp2=vp2->firstord;
    while (lp1!=0 || lp2!=0) {
      if (lp1==0 || lp2==0){
        diffp->type = 1;
        diffp->vp1 = vp1;
        diffp->vp2 = vp2;
        return FALSE;
      }
      if (lp1->i!=lp2->i){
        diffp->type = 1;
        diffp->vp1 = vp1;
        diffp->vp2 = vp2;
        return FALSE;
      }
      lp1 = lp1->next;
      lp2 = lp2->next;
    }
/* now compare the edges out of the two vertices. It's possible that there may
be more edges out of one vertex than the other, because of time and memory
constraints, and because if the subabquot info is not available at some
vertex, foxreg may have been run with irrelevant primes */
    ep1=vp1->firstedge;
    ep2=vp2->firstedge;
    while (ep1!=0 && ep2!=0) {
      if ((ep1->p)<(ep2->p)){
        ep1 = ep1->next;
        continue;
      }
      else if ((ep1->p)>(ep2->p)){
        ep2 = ep2->next;
        continue;
      }
      if (ep1->n!=ep2->n){
        diffp->type = 2;
        diffp->vp1 = vp1;
        diffp->vp2 = vp2;
        diffp->ep1 = ep1;
        diffp->ep2 = ep2;
        return FALSE;
      }
      ep1 = ep1->next;
      ep2 = ep2->next;
    }
    vp1 = vp1->next;
    vp2 = vp2->next;
  }
  return TRUE;
}

void
gt_diff_message(diffp,gp1,gp2,rep,j,k)
  gt_diff * diffp;
  char * gp1,* gp2,* rep;
  int j,k;
{
  intlink * lp=diffp->vp1->pseq;
  if (diffp->type == 1)
    printf("The quotients of %s and %s with \n",gp1,gp2);
  else 
    printf("The subgroups of %s and %s whose quotients have\n",gp1,gp2);
  printf("descending series consisting of\n");
  if (strcmp(rep,"-t")!=0){
    printf("%s (regular reps nos. %d and %d respectively)\n",rep,j,k);
    if (lp)
      printf("and then ");
  }
  if (lp){
    if (lp->next)
      printf("elementary abelian groups on the primes ");
    else
      printf("an elementary abelian group on the prime ");
    do {
      printf("%d ",lp->i);
      lp = lp->next;
    } while (lp!=0);
    printf("\n");
  }
  printf("must be non-isomorphic because\n");
  switch (diffp->type) {
    case 0:
printf("the sequences of elementary abelian invariants, which determine\n");
printf("which elementary abelian sections may lie below the two subgroups,\n"); 
      printf("are  different. The sequences are\n");
      lp = diffp->vp1->firstai;
      while (lp){
        printf("%d ",lp->i);
        lp = lp->next;
      }
      printf("and ");
      lp = diffp->vp2->firstai;
      while (lp){
        printf("%d ",lp->i);
        lp = lp->next;
      }
      printf("respectively.\n");
      break;
    case 1:
  printf("the order sequences of the two quotients, which list the orders\n");
  printf("of elements (and their multiplicities) are different.\n"); 
      printf("The sequences are\n");
      lp = diffp->vp1->firstord;
      while (lp){
        printf("%d ",lp->i);
        lp = lp->next;
      }
      printf("and\n");
      lp = diffp->vp2->firstord;
      while (lp){
        printf("%d ",lp->i);
        lp = lp->next;
      }
      printf("respectively.\n");
      break;
    case 2:
  printf("the subgroups admit non-isomorphic maximal elementary abelian\n");
  printf("quotients on the prime %d,",diffp->ep1->p);
  printf("of ranks %d and %d respectively.\n",diffp->ep1->n,diffp->ep2->n);
      break;
    default:
      printf("Error\n");
  }
}  
         
  
