/* isom.d/src file gptree.h */
typedef struct gptree {
	struct gt_vertex * root
} gptree;

typedef struct gt_vertex {
	boolean subabquot; /* set true if subabquot has successfully completed
*/
	struct intlink * pseq;
	struct intlink * firstai;
	struct intlink * lastai;
	struct intlink * firstord;
	struct intlink * lastord;
	struct gt_edge * firstedge;
	struct gt_edge * lastedge;
	struct gt_vertex * next;
} gt_vertex;


typedef struct intlink { 
	int  i;
	struct intlink * next;
} intlink;

typedef struct gt_edge {
	int p;
	int n;
	struct gt_vertex * target;
	struct gt_edge * next;
} gt_edge;

typedef struct gt_diff {
	int type;
	gt_vertex * vp1;
	gt_vertex * vp2;
	gt_edge * ep1;
	gt_edge * ep2;
} gt_diff;


void gt_init PARMS((gptree *));
void gt_clear PARMS((gptree *));
gt_vertex * gt_vertex_create();
void gt_ai_append PARMS((gt_vertex *,int));
void gt_order_append PARMS((gt_vertex *,int));
gt_edge * gt_edge_append PARMS((gt_vertex *,int,int));
void gt_set_primeseq PARMS((gt_vertex * child,gt_vertex * parent,int p));
boolean gt_equiv PARMS((gptree * gtp1,gptree * gtp2,gt_diff * diffp));
void gt_diff_message 
 PARMS((gt_diff * diffp,char * gp1,char * gp2, char * rep, int j, int k));

