/* isom.d/src file permfns.c */
#include <stdio.h>
#define tmalloc(D,T,N) {D = (T *) malloc(sizeof(T)*(N)); \
  if (D==0) { fprintf(stderr,"Out of space.\n"); exit(2);}}
#define tfree(D) {if (D) free( (char *) D); D=0;}
char *malloc();

extern int npt,**cp,**lcp,**ucp,**pptr,*pno,*actgen,stop;
extern FILE *fopen(),*ip,*op;


image(pt) int pt;
{ int **p;
  p=lcp-1;
  while (++p<=ucp) pt=(*p)[pt];
  return(pt);
}

addsvb(pt,sv) int pt,**sv;
{ int *p;
  while ((p=sv[pt])!= &stop) {pt=p[pt]; lcp--; *lcp =p-(npt+1); }
  return;
}

addsvf(pt,sv) int pt,**sv;
{ int *p;
  while ((p=sv[pt])!= &stop) {pt=p[pt]; ucp++; *ucp=p; }
  return;
}

invert(ptr1,ptr2) int *ptr1,*ptr2;
/* permutation ptr1 is inverted and put in ptr2.
   Externals: npt.
*/
{ int i;
  for (i=1;i<=npt;i++) ptr2[ptr1[i]]=i;
  return;
}

readvec(ptr)  int *ptr;
/* The next npt points from ip are read into array ptr.
   Externals: npt,ip.
*/
{ int i;  for (i=1;i<=npt;i++) fscanf(ip,"%d",ptr+i); return(0);}

readbaselo(nb,base,lorb) int nb,*base, *lorb;
/* The nb base points are read into base, and the nb orbit lengths into lorb,
   from ip.
   Externals:ip.
*/
{ int i;
  for (i=1;i<=nb;i++) fscanf(ip,"%d",base+i);
  for (i=1;i<=nb;i++) fscanf(ip,"%d",lorb+i);
  return(0);
}

readperms(nb,nperms,perm) int nb,nperms,*perm;
/* nperms permutations (up to npt+1) are read into perm  and inverted.
  Externals:npt,pptr.
*/
{ int i,j,k,*ptr,*temp,npt1;
  npt1=npt+1;
  ptr=perm-1;
  for (i=1;i<=nperms;i++)
  { readvec(ptr); invert(ptr,ptr+npt1);
    seeknln();
    pptr[2*i-2]=ptr; pptr[2*i-1]=ptr+npt1;
    ptr+= 2*npt1;
  }
  return(0);
}

seeknln()
/* The next new line in ip is found. */
{while (getc(ip)!='\n'); }

exprep(pt,ptr,sv) int pt,*ptr,**sv;
/* The word for pt is computed using Schreier vector sv, and the corresponding
   perm (i.e. the inverse of cp) stored in ptr. The inverse of the perm is
   stored in ptr+npt
   Externals: npt,cp.
*/
{ int i;
  ucp=lcp-1; addsvf(pt,sv);
  for (i=1;i<=npt;i++) ptr[npt+i]=image(i);
  invert(ptr+npt,ptr);
  return(0);
}

cycle(p) int *p;
/* Externals: npt */
{ int i,m,im,*temp; char id;
  tmalloc(temp,int,npt+1)
  for (i=1;i<=npt;i++) temp[i]=1;
  id=1;
  for (m=1;m<=npt;m++) if (temp[m])
  { if ((im=p[m])!=m)
    { id=0; temp[im]=0; fprintf(op,"(%d,%d",m,im);
      while ((im=p[im])!=m) { temp[im]=0; fprintf(op,",%d",im); }
      fprintf(op,")");
    }
  }
  if (id) fprintf(op,"Identity\n"); else fprintf(op,"\n");
  tfree(temp)
}

gp(base,anb,lorb,svptr,anp2,baseknown)
   int *base,*anb,*lorb,***svptr,*anp2;
   char baseknown;
/* baseknown=1 means base[1-nb] is known to be a base.
   baseknown=2 means in addtition that generators are already
   known to be a stron generating set
*/
/* Externals pptr, pno, cp, lcp, ucp,  npt */
{ int i,j,k,l,m,bno,u,v,**w,**x,y,z,**lsv,np2,nb,*p,npt1,*orb;
  char trivrel,id;
  npt1=npt+1;
  tmalloc(orb,int,npt1)
  nb= *anb;
  np2= *anp2;
  for (i=0;i<np2;i+=2)
  { pptr[i][npt1]=0;
    for (j=1;j<=nb;j++) if (pptr[i][base[j]]!=base[j]) {pptr[i][npt1]=j; break;}
    if ((baseknown==0 && pptr[i][npt1]==0) || nb==0)
    { for (k=1;k<=npt;k++)
        if (pptr[i][k]!=k)
        { nb++; base[nb]=k;
          pptr[i][npt1]=nb;
          tmalloc(svptr[nb],int *,npt1)
          break;
        }
    }
  }

/* Just in case all generators are trivial: */
  if (nb==0)
  { nb=1; base[1]=1; tmalloc(svptr[nb],int *,npt1)}

  bno=nb;
  tmalloc(pptr[np2],int,2*npt1) pptr[np2+1]=pptr[np2]+npt1;

loop:
  *pno=0;
  for (i=0;i<np2;i+=2)
  { if (pptr[i][npt1]>=bno && actgen[i]<=bno)
    { (*pno)++; pno[*pno]=i; }
  }
  lorb[bno]=orbitsv(base[bno],svptr[bno],orb);
  if (*pno!=0 && baseknown<2)
  { y=np2+1;
    for (i=1;i<=lorb[bno];i++)
    { ucp=lcp-1; addsvf(orb[i],svptr[bno]);
      for (w=lcp,x=ucp;w<=x;w++,x--)
      { if (w==x) (*w)-=npt1; else {p= *w; *w= *x-npt1; *x=p-npt1;}}
      lsv= ucp;
      for (j=1;j<=*pno;j++)
      { ucp=lsv;
        trivrel = (ucp>=lcp) ? *ucp==pptr[pno[j]] : 0;
        if (trivrel==0)
        { *(++ucp)=pptr[pno[j]+1]; id=1;
          for (l=bno;l<=nb;l++)
          { v=base[l]; u=image(v); if (svptr[l][u]==0) {id=0; break;}
            addsvf(u,svptr[l]);
          }
          if (id==0)
          { pptr[np2][npt1]=l; actgen[np2]=bno+1;
            for (m=1;m<=npt;m++) {u=image(m); pptr[np2][m]=u; pptr[y][u]=m;}
            np2+=2;
            tmalloc(pptr[np2],int,2*npt1) pptr[np2+1]=pptr[np2]+npt1;
            bno=l; goto loop;
          }
          if (baseknown==0)
          { for (l=1;l<=npt;l++) if (image(l)!=l)
            { nb++; base[nb]=l; tmalloc(svptr[nb],int *,npt1);
              pptr[np2][npt1]=nb; actgen[np2]=bno+1;
              for (m=1;m<=npt;m++) {u=image(m); pptr[np2][m]=u; pptr[y][u]=m;}
              np2+=2;
              tmalloc(pptr[np2],int,2*npt1) pptr[np2+1]=pptr[np2]+npt1;
              bno=nb;
              goto loop;
            }
          }
        }
      }  
    }  
  }
  bno--;

  if (bno==0)
  { *anp2=np2;
    *anb=nb;
    tfree(pptr[np2])
    tfree(orb)
    return(0);
  }
  else goto loop;
}

ingp(base,nb,svptr,p) int *base,nb,***svptr, *p;
/*Externals: cp, lcp, ucp. */
{ int i,im;
  ucp=lcp; *ucp=p;
  for (i=1;i<=nb;i++)
  { im=image(base[i]);
    if (svptr[i][im]==0) return(0);
    addsvf(im,svptr[i]);
  }
  return(1);
}

orbitsv(pt,svec,orb) int pt,**svec,*orb;
/* Externals: npt,stop,pno,pptr. */
{ int u,v,w,x,y,z,lo;
  for (u=1;u<=npt;u++) svec[u]=0;
  orb[1]=pt; lo=1; svec[pt]= &stop;
 
  for (x=1;x<=lo;x++)
  { z=orb[x];
    for (y=1;y<= *pno;y++)
    { w=pno[y]; v=pptr[w][z];
      if (svec[v]==0) { lo++; orb[lo]=v; svec[v]=pptr[w+1]; }
    }
  }  
  return(lo);
}
