/* isom.d/src file subabquot.c */
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/times.h>
#include "defs.h"
#include "list.h"
#include "word.h"
#include "input.h"
#define ORDRELSOP "ordrels"
#define WARNSIZE 100000000
#define MAXDEG 360
#define tmalloc(D,T,N) {D = (T *) malloc(sizeof(T)*(N)); \
  if (D==0) { fprintf(stderr,"Out of space.\n"); exit(2);}}
#define tfree(D) {if (D) free( (char *) D); D=0;}
int npt,nperms,rellen,relpow,nsubgens,nsubrels;
    *permprod,*reln,**perm,*orbpt,**perminv,**coeff,**coeffinv,**subrel;
char *hadpt,check=0,elim;
extern word * user_gen_name;
extern gen * inv_of;
extern int num_gens;
extern int gen_array_size;
word rel;
word baseword;
list rels;
int num_rels = 0;
int paired_gens = 0;
int * pairnumber = 0;


char *malloc();
FILE *fopen(),*ip,*op;
char inf1[100],inf2[100],outf[100];
int triv_rep = 0, maxtime=0;
int timeout=0;
struct tms buffer;

main(argc,argv) int argc; char *argv[];
{ int arg;
  char err;
  err=0;  arg=1; if (argc<=arg) {err=1; goto error;}
  if (argc<=arg) {err=1; goto error;}
  while (argv[arg][0]=='-')
  { if (argv[arg][1]=='c') check=1;
    else if (argv[arg][1]=='t')
    { arg++; if (argc<=arg) {err=1; goto error;}
      maxtime=stringtoint(argv[arg]);
    }
    else {err=1; goto error;}
    arg++;
    if (argc<=arg) {err=1; goto error;}
  }
  strcpy(inf1,argv[arg]); strcat(inf1,".");
  strcpy(inf2,inf1); strcpy(outf,inf1);
  arg++; if (argc<=arg) strcat(inf1,"ip"); 
       else if (strcmp(argv[arg],"-t")==0) triv_rep = 1;
         else strcat(inf1,argv[arg]);
  strcat(inf2,ORDRELSOP);
  arg++; if (argc<=arg) strcat(outf,"subabquot"); else strcat(outf,argv[arg]);
  

  subabquot();
error:
  if (err)
  { fprintf(stderr,"Usage:    ");
   fprintf(stderr,"subabquot  [-c] [-t maxtime] gpname [inf1] [outf]\n");
    exit(2);
  }
  else exit(0);
}

subabquot()
{ int  i,j,k,l,m,n,r,pt,ngens;
  char *label;
  gen gg,hh;

/* Chunk of old "powrels" stuff follows */
  if ((ip=fopen(inf2,"r"))==0)
  { fprintf(stderr,"Cannot open %s.\n",inf2); exit(2); }
  word_init(&rel);
  word_init(&baseword);
  list_init(&rels,WORD,ORDERED);
  label = vzalloc2(char,9);

  while (read_next_string(label,8,ip)){
    if (strcmp(label,"Format  ")==0)
                format_check("2.2",ip);
    else if (strcmp(label,"words   ")==0 || strcmp(label,"gens    ")==0)
      /* The order of the generators in the group is being specified */
      read_gen_name_array(ip);
    else if (strcmp(label,"inverses")==0){
        read_inverse_array(ip);
    }
    else if (strcmp(label,"rels    ")==0){
      if (inv_of==0)
        default_inverse_array();
      while (getc(ip)!='\{')
        ;
      word_init(&rel);
          while (read_next_rel(&rel,ip)){
        if (word_length(&rel)>2 || (word_length(&rel)==2 &&
        word_get_last(&rel,&gg)&&word_get_first(&rel,&hh)&&gg!=hh))
            word_creduce(&rel,&rel);
                else if (gg==hh){ /* gg is an involution */
/* if the inverse table doesn't already record g as an involution, we need
to change it. The lower numbered of the two generators gg and inv(gg) should
appear as the inverse of both in the inverse table. The higher numbered
generator then becomes redundant, but we won't delete it, because that would
mean rewriting all our relators. */
                        if (gg<inv_of[gg]) {
                                inv_of[gg] = gg;
                        }
                        else if (gg>inv_of[gg])
                                inv_of[inv_of[gg]] = inv_of[gg];
                }
        if (word_length(&rel)!=0){
          list_insert(&rels,&rel);
          num_rels++;
        }
        word_reset(&rel);
      }  
      while (getc(ip)!='\}')
        ;
    }
  }  
  fclose(ip);
     
  for (i=1;i<=num_gens;i++){
    if (inv(i)==i){
      word_put_last(&rel,i);
      word_put_last(&rel,i);
      if (list_insert(&rels,(dp)&rel))
        num_rels++;
      word_reset(&rel);
    }
  }  
  Free_dp((dp)label); label = 0;
  pairnumber=vzalloc2(int,num_gens+1);
  for (i=1;i<=num_gens;i++){
    if (inv(i)<=i){
      paired_gens++;
      pairnumber[i]=pairnumber[inv(i)]=paired_gens;
    }
  }  

  if ((ip=fopen(inf1,"r"))==0)
  { triv_rep = 1;
    npt=1; nperms=paired_gens;
  }
  else
  { fscanf(ip,"%d%d%d%d",&npt,&nperms,&j,&k); seeknln();
    if (npt>MAXDEG)
    { printf("Degree too big. Exiting subabquot.\n"); exit(2);}
    if (j!=0) seeknln(); if (k!=0) seeknln();
    if (paired_gens!=nperms)
    { fprintf(stderr,"Number of generators in input files do not agree.\n");
      exit(2);
    }
  }
  tmalloc(perm,int *,nperms+1); tmalloc(perminv,int *,nperms+1);
  tmalloc(coeff,int *,nperms+1); tmalloc(coeffinv,int *,nperms+1);
  tmalloc(hadpt,char,npt+1); tmalloc(orbpt,int,npt+1);
  tmalloc(permprod,int,npt+1);
  for (i=1;i<=nperms;i++)
  { tmalloc(perm[i],int,npt+1);
    if (ip)
    { for (j=1;j<=npt;j++) fscanf(ip,"%d",perm[i]+j); seeknln();}
    else perm[i][1]=1;
    if (order(perm[i])<=2) perminv[i]=perm[i];
    else
    { tmalloc(perminv[i],int,npt+1);
      for (j=1;j<=npt;j++) perminv[i][perm[i][j]]=j;
    }
    tmalloc(coeff[i],int,npt+1); tmalloc(coeffinv[i],int,npt+1);
  }
  fclose(ip);
  setcoeff(1);

  tmalloc(subrel,int *,npt*num_rels);

  nsubrels=0;
 
/* Read next relation and check its validity */
  while (list_delget_first(&rels, (dp)&rel)){
    int length = word_length(&rel);
    int baselength =0;
    int exponent;
    word power;
        if (length==0)
                continue;
    word_init(&power);
    baselength = 0;
    while (baselength <= length){
     word_traverser wt;
      int count = 0;
      word_traverser_init(&wt,&rel);
      while (word_next(&wt,&gg)){
        count++;
        if (count<=baselength)
          continue;
        word_put_last(&baseword,gg);
        baselength++;
        if (baselength>length/2 ||length%baselength==0)
          break;
      }  
      word_traverser_clear(&wt);
      if (baselength > length/2){
        baselength = length;
        exponent = 1;
        break;
      }  
      else {
        exponent = length/baselength;
        for (i=1;i<=exponent;i++)
          word_append(&power,&baseword);
        if (word_sgn(&rel,&power)==0)
          break;
      }  
      word_reset(&power);
    }
    word_clear(&power);
    if (baselength == length)
      word_cpy(&rel,&baseword);
    rellen=baselength; relpow=exponent;

    tmalloc(reln,int,rellen+1);
    i=0;
    while (word_delget_first(&baseword,&gg)){
        reln[++i]= (gg<=inv(gg)) ? pairnumber[gg] : -pairnumber[gg];
    }
    word_reset(&baseword);

    if (maxtime>0)
    { times(&buffer);
      if (buffer.tms_utime/60 > maxtime) { timeout=1; break;}
    }
    for (n=1;n<=npt;n++)
    { m=n;
      for (i=1;i<=rellen;i++) 
             m= reln[i]>0 ? perm[reln[i]][m] : perminv[-reln[i]][m];
      permprod[n]=m;
    }
    if (relpow % order(permprod) != 0)
    { fprintf(stderr,"Relation number %d is not satisfied.\n",r); exit(2);}

    for (i=1;i<=npt;i++) hadpt[i]=0;
    for (i=1;i<=npt;i++) if (hadpt[i]==0)
    { nsubrels++;
      pt=i;
      tmalloc(subrel[nsubrels],int,nsubgens+1);
      for (j=1;j<=nsubgens;j++) subrel[nsubrels][j]=0; 
      for (j=1;j<=relpow;j++)
      { for (k=1;k<=rellen;k++)
        if ((l=reln[k])>0)
        { if (coeff[l][pt]) subrel[nsubrels][coeff[l][pt]]++;
          pt=perm[l][pt];
        }
        else
        { if (coeffinv[-l][pt]) subrel[nsubrels][coeffinv[-l][pt]]--;
          pt=perminv[-l][pt];
        }
        hadpt[pt]=1;
      }
    }
  }

/*
for (i=1;i<=nsubrels;i++)
{ for (j=1;j<=nsubgens;j++) printf(" %2d",subrel[i][j]); printf("\n");}
*/
    
  if (timeout==0)
  diagonalise();
  
  op=fopen(outf,"w");
  fprintf(op,"Format 2.2\n");
  if (timeout){
	fprintf(op,"timeout\n");
	exit(0);
  }
  fprintf(op,"abinvariants \{ ");
  for (i=1;i<=nsubgens;i++){
    if (i<=nsubrels){
      if (subrel[i][i]!=1)
        fprintf(op,"%d ",subrel[i][i]);
    }
    else
      fprintf(op,"0 ");
  }
  fprintf(op,"\}\n");  

}
      

order(per) int *per;
{ int h,i,j,k,l,order;
  order=1;
  for (i=1;i<=npt;i++) hadpt[i]=0;
  for (i=1;i<=npt;i++) if (hadpt[i]==0)
  { l=1; j=i;
    while ((k=per[j])!=i) {l++; j=k; hadpt[j]=1;}
    h=hcf(order,l);
    order *= (l/h);
  }
  return(order);
}

hcf(a,b) int a,b;
{  int c;
   if (b<0) b= -b; if (a<0) a= -a;
   if (b>a) {c=b; b=a; a=c;}
   while (b!=0) {c=a%b; a=b; b=c;}
   return(a);
}

setcoeff(n) int n;
{ int len,i,j,pt;

  for (j=1;j<=nperms;j++) for (i=1;i<=npt;i++) coeff[j][i]=coeffinv[j][i]= -1;

  for (i=1;i<=npt;i++) hadpt[i]=0;
  len=1; orbpt[len]=n; hadpt[n]=1;
  for (i=1;i<=len;i++) for (j=1;j<=nperms;j++)
  { pt=perm[j][orbpt[i]];
    if (hadpt[pt]==0)
    { orbpt[++len]=pt; hadpt[pt]=1;
      coeff[j][orbpt[i]]=coeffinv[j][pt]=0;
    }
  }

  nsubgens=0;
  for (j=1;j<=nperms;j++) for (i=1;i<=npt;i++) if (coeff[j][i]== -1)
  { coeff[j][i]= ++nsubgens; coeffinv[j][perm[j][i]]= nsubgens;}
  
}

seeknln()
{ char c; while ((c=getc(ip))!='\n'); }

diagonalise()
{
  int i,j,i0,j0;
  int d,x,y,shift;  
  int m=nsubrels, n=nsubgens;
  shift=0;
  while (m>=0 && n>=0 & minposn(&i0,&j0,m,n)){
    char repeat = 0;
        if (maxtime>0)
        { times(&buffer);
          if (buffer.tms_utime/60 > maxtime) {timeout=1; return;}
        }
    for (i=1;i<=m;i++)
      if (i!=i0 && subrel[i][j0])
      rowadd(i,i0,-((subrel[i][j0])/(subrel[i0][j0])),n);
    for (j=1;j<=n;j++)
      if (j!=j0 && subrel[i0][j])
      coladd(j,j0,-((subrel[i0][j])/(subrel[i0][j0])),m);
    for (i=1;i<=m;i++)
      if (i!=i0 && subrel[i][j0]!=0){
        repeat=1;
        break;
      }
    for (j=1;j<=n;j++)
      if (j!=j0 && subrel[i0][j]!=0){
        repeat=1;
        break;
      }
    if (repeat==0){
      rowswap(1,i0);
      colswap(1,j0,m);
      if (subrel[1][1]<0)
        rownegate(1,n);
      shift++;
      subrel++;
      m--;
      n--;
      for (i=1;i<=m;i++)
        subrel[i]++;
    }
  }
  while (m<nsubrels){
    for (i=1;i<=m;i++)
      subrel[i]--;
    m++;
    n++;
    subrel--;
  }
  shift=0;
  while (m>1 && n>1 & subrel[1][1]!=0){
    for (i=2;i<=m && i<=n;i++)
      if ((subrel[i][i])%(subrel[1][1])!=0){
/* replace subrel[1][1] by the hcf of the two numbers
  and subrel[i][i] by
  their least common multiple
*/
        int d,x,y;
        euclid(subrel[1][1],subrel[i][i],&d,&x,&y);
        rowadd(i,1,x,n);
        coladd(1,i,y,m);
        rowswap(1,i);
        rowadd(i,1,-((subrel[i][1])/d),n);
        coladd(i,1,-((subrel[1][i])/d),m);
        rownegate(i,n);
      }
    shift++;
    subrel++;
    m--;
    n--;
    for (i=1;i<=m;i++)
      subrel[i]++;
  }
  while (m<nsubrels){
    for (i=1;i<=m;i++)
      subrel[i]--;
    m++;
    n++;
    subrel--;
  }
}

rowswap(i,j)
  int i,j;
{
  int * temp;
  temp = subrel[i];
  subrel[i] = subrel[j];
  subrel[j] = temp;
}
  
colswap(i,j,m)
  int i,j;
{
  int temp;
  int k;
  for (k=1;k<=m;k++){
    temp = subrel[k][i];
    subrel[k][i] = subrel[k][j];
    subrel[k][j] = temp;
  }
}

minposn(ip,jp,m,n)
  int * ip, * jp,m,n;
{
  int smallest=0;
  int i,j;
  *ip=0;
  *jp=0;
  for (i=1;i<=m;i++)
    for (j=1;j<=n;j++){
      int x = subrel[i][j];
      if (x>0 && (x < smallest || smallest==0)){
        smallest = x;
        *ip = i;
        *jp = j;
        if (smallest==1) return 1;
      }
      else if (x<0 && (-x < smallest || smallest==0)){
        smallest = -x;
        *ip = i;
        *jp = j;
        if (smallest==1) return 1;
      }
    }
  if (smallest==0)
    return 0;
  else
    return 1;
} 

rowadd(i,j,lambda,n)
  int i,j,lambda;
{
  int k;
  if (lambda)
  for (k=1;k<=n;k++) {
    subrel[i][k] = subrel[i][k] +lambda * subrel[j][k];
    if (check)
        if (subrel[i][k]>WARNSIZE || subrel[i][k]< -WARNSIZE)
    {fprintf(stderr,"Integer %d encountered. Danger of overflow.\n",
      subrel[i][k]);
      exit(2);
    }
  }
}
      
coladd(i,j,lambda,m)
  int i,j,lambda,m;
{
  int k;
  if (lambda)
  for (k=1;k<=m;k++) {
    subrel[k][i] = subrel[k][i] +lambda * subrel[k][j];
    if (check)
      if (subrel[k][i]>WARNSIZE || subrel[k][i]< -WARNSIZE)
    {fprintf(stderr,"Integer %d encountered. Danger of overflow.\n",
      subrel[k][i]);
      exit(2);
    }
  }
}

rownegate(i,n)
  int i,n;
{
  int k;
  for (k=1;k<=n;k++)
    subrel[i][k] *= -1;
}

euclid(a,b,dp,xp,yp)
  int a,b;
  int *dp,*xp,*yp;
{
  int a1,a2,x1,y1,x2,y2,x,y,r,q;
  if (a>b){
    a1 = a;
    a2 = b;
    x1 = 1;
    y1 = 0;
    x2 = 0;
    y2 = 1;
  }
  else {
    a1 = b;
    a2 = a;
    x1 = 0;
    y1 = 1;
    x2 = 1;
    y2 = 0;
  }
  while ((r=a1%a2)!=0){
    q = a1/a2;
    x = x1 - q*x2;
    y = y1 - q*y2;
    a1 = a2; x1 = x2; y1 = y2;
    a2 = r; x2 = x; y2 = y;
  }
  *dp = a2;
  *xp = x2;
  *yp = y2;
}

stringtoint(w) char *w;
{ char *p; int n;
  p=w; n=0;
  while (*p!='\0')
  { if (isdigit(*p)==0)
    { fprintf(stderr,"Usage:    ");
   fprintf(stderr,"subabquot  [-c] [-t maxtime] gpname [inf1] [inf2] [outf]\n");
      exit(2);
    }
    n=10*n+(*p-'0');
    p++;
  }
  return(n);
}
