#include <stdio.h>

double atof();

struct value_struct {
  double value;
  struct value_struct *next;
  struct value_struct *equal;  /* points back to equal valued node */
 };

typedef struct value_struct Value;

double epsilon = 0.0;
Value value;

#define YES 1
#define NO 0

#define F_FORMAT 0
#define G_FORMAT 1
#define D_FORMAT 2

int format = F_FORMAT;  /* Output format */
int integer = NO; /* Compare integers ? */

main(argc,argv)

int argc;
char *argv[];

{
  char aux[32],strng[1024];
  FILE *infile, *outfile;
  int integer,found_it;
  double real;
  Value *tmp_val_ptr,*val_ptr;
  char ch;
  int total,collapsed;

  ProcessCommandLine(argc,argv);

  if(argc < 4) {
     fprintf(stderr,
     "Usage: epsilon <threshold> <infile> <outfile> \n");
     fprintf(stderr,"  If infile = '-' or outfile = '-' then they are\n ");
     fprintf(stderr,"  replaced by stdin or stdout respectively.\n");
     exit(0);
    }

  epsilon = atof(argv[1]);

  if(strcmp(argv[argc-2],"-") == 0) {
     infile = stdin;
    }
  else {
     if((infile = fopen(argv[argc-2],"r")) == NULL) {  
       fprintf(stderr,"Can't open infile %s\n",argv[argc-2]);
       exit(-1);
      }
    }

  if(strcmp(argv[argc-1],"-") == 0) {
     outfile = stdout;
    }
  else {
     if((outfile = fopen(argv[argc-1],"w")) == NULL) {
          fprintf(stderr,"Can't open outfile %s\n",argv[argc-1]);
          exit(-1);
         }
    }

  value.value = 0.0;
  value.next = NULL;
  value.equal = NULL;

  total = 0;
  collapsed = 0;

  while(1) {

     /* Build the next string and print whitespace */

     if(fscanf(infile,"%[ \t\r\n]",strng) != 0) fprintf(outfile,"%s",strng);

     if(fscanf(infile,"%s",strng) == EOF) break;

     /* Try to determine type of string */

    if(!is_a_float(strng))  {  /* Not a floating point number */
       fprintf(outfile,"%s",strng);
      }


    else {   /* search list for near equality */

       sscanf(strng,"%lf",&real);

       found_it = 0;
       val_ptr = &value;
       while(val_ptr->next != NULL && !found_it) {

          val_ptr = val_ptr->next;

          if(real-val_ptr->value < epsilon && val_ptr->value-real < epsilon) {
              found_it = 1;
              collapsed++;
              break;
             }
         }

        /* Add new value to list */

       total++;

       tmp_val_ptr = &value;
       while(tmp_val_ptr->next != NULL) {
          tmp_val_ptr = tmp_val_ptr->next;
         }
       tmp_val_ptr->next = (Value *) malloc(sizeof(Value));
       tmp_val_ptr = tmp_val_ptr->next;
       if(tmp_val_ptr == NULL) {
          fprintf(stderr,"PANIC!!! Out of memory!!! Abandoning ship!!!\n");
          fclose(infile); 
          fclose(outfile); 
          exit(-1);
         }
       tmp_val_ptr->value = real;
       tmp_val_ptr->next = NULL;

       if(found_it == 1) { /* Link to equal value */ 
          tmp_val_ptr->equal = val_ptr;
         }
       else {  
          tmp_val_ptr->equal = NULL;
         }

       /* follow list back to original value */

       val_ptr = tmp_val_ptr;
       while(val_ptr->equal != NULL) {
          val_ptr = val_ptr->equal;
         }

       real = val_ptr->value;

       /* Check special case: number close to zero, print as 0.000 */

       if(real < epsilon && -real < epsilon) {
          real = 0.0;
         }

       switch(format) {
          case F_FORMAT:

             fprintf(outfile,"%lf",real);
             break;

          case D_FORMAT:
             fprintf(outfile,"%d",(int) (real+0.5));
             break;

          case G_FORMAT:
             fprintf(outfile,"%lg",real);
             break;
         }
      }

    }

  fclose(infile);
  fclose(outfile);
  fprintf(stderr,"Total number of values: %d\n",total);
  fprintf(stderr,"Number of values collapsed: %d\n",collapsed);
}

is_a_float(strng) 

char *strng; 

{ 
  char *ch; 
  int passes,is_an_int;
  int dec_pnts;
  double val;

  /* Check if convertible to floating point number */

  passes = 1;
  is_an_int = 1;   /* Until otherwise determined */

  val = strtod(strng,&ch);
  if(*ch != '\0')  {   /* Not correct format */
     passes = 0;
    }

  if(integer) {  /* Regard integers as floating point data */
     is_an_int = 0;
    }

  else {

     /* Check to see if its an integer */

     ch = strng;

     while(*ch != '\0' && passes) {

        switch(*ch) {

           case '.':
           case 'e':
           case 'E':
             is_an_int = 0;
             ch++;
             break;

           default:
             ch++;
          }
 
       }
    }

  if(passes == 1 && is_an_int == 0) return(1);
  else return(0);
}

ProcessCommandLine(argc,argv)

int argc;
char *argv[];

{
  int i,valid;

  if(argc < 4) {
     fprintf(stderr,
     "Usage:\n  epsilon <threshold> [-format [fgd]] [-integer] <infile> <outfile> \n");
     fprintf(stderr,"  If infile = '-' or outfile = '-' then they are\n ");
     fprintf(stderr,"  replaced by stdin or stdout respectively.\n");
     exit(0);
    }

  for(i=2;i<argc-2;++i) {
     valid = 0;

     if(strcmp(argv[i],"-format") == 0) {
        valid = 1;
         switch(argv[++i][0]) {
            case 'f':
              format = F_FORMAT;
              break;

            case 'g':
              format = G_FORMAT;
              break;

            case 'd':
              format = D_FORMAT;
              break;

            default:
             fprintf(stderr,"Unknown format %c.\n",argv[i][0]);
           }

        }
     if(strcmp(argv[i],"-integer") == 0) {
        valid = 1;
        integer = YES;
       }

     if(valid == 0) {
        fprintf(stderr,"Unknown argument %s.\n",argv[i]);
       }

    }

}
