
/*
  $Header: /usr2/meuer/Geom_utilities/Arc2list/RCS/parse_command.c,v 1.1 91/02/05 15:11:05 meuer Exp $

  Parse the command line, print usage message if necessary.

  Mark Meuer
  #1267045

  */


#include	<malloc.h>
#include	<strings.h>
#include	"breakarc.h"


void
parse_command_line( argc, argv, in_file, out_file, arc_size )
     int	argc;
     char	**argv;
     char	**in_file;
     char	**out_file;
     double	*arc_size;
{
    double	atof();
    int	cur_arg = 1;		/* Current argument being processed */
    int	more_options = TRUE;

    /* PROCESS THE OPTIONS */
    for( cur_arg = 1; (cur_arg < argc) && (more_options); cur_arg++ )
    {
	if ( strcmp("-size", argv[cur_arg]) == 0 )
	{
	    cur_arg++;
	    if ( cur_arg > argc )
	    {
		usage( argv[0] );
	    }
	    else
	    {
		*arc_size = atof(argv[cur_arg]);
		fprintf(stderr, "Arc size changed to %lf.\n", *arc_size );
	    }
	}
	else	/* no options were found */
	{
	    more_options = FALSE;
	    cur_arg--;	/* This is to remove the effect of cur_arg++ at end of loop */
	}
    }
    
    /* GET THE FILE NAMES */
    /* Check for 2 arguements left */
    if ( argc - cur_arg != 2 )
    {
	usage( argv[0] );
    }
    else
    {
	*in_file = malloc(sizeof(char) * strlen(argv[cur_arg]));
	strcpy(*in_file, argv[cur_arg++]);
	*out_file = malloc(sizeof(char) * strlen(argv[cur_arg]));
	strcpy(*out_file, argv[cur_arg++]);
    }
}



/*
  PRINT A USAGE MESSAGE, COUGH UP A HAIRBALL, AND DIE.
  */
void
usage( prog_name )
     char	*prog_name;     
{
    fprintf(stderr, "Usage: %s [-size <size of arc>] <input file> <output file>\n", prog_name );
    fprintf(stderr, "  Where infile contains a list of 3-tuples of points in\n");
    fprintf(stderr, "  3-space.  The points are interpreted as the center and\n");
    fprintf(stderr, "  two points of an arc.  Outfile is filled with a polyline\n");
    fprintf(stderr, "  interpolation of the arcs.\n\n");
    fprintf(stderr, "  The -size option specifies the maximum angular\n");
    fprintf(stderr, "  measurement (in radians) of any line segment output.\n");
    fprintf(stderr, "  The default is 0.05.\n\n");
    fprintf(stderr, "  A \"-\" may be used in place of a file name to\n");
    fprintf(stderr, "  indicate standard input or output, respectively.\n\n");

    exit(-1);
}
