
/*
 * $Header: /n/poincare/usr2/meuer/5117/RCS/ang_from_z.c,v 1.1 89/05/04
 * 11:36:39 meuer Exp $
 */
/* $Source: /usr2/meuer/Geom_utilities/Matrix_util/RCS/ang_from_z.c,v $ */

/*
 * Routine to take a vector and return the radians it is rotated away from
 * the Z axis.
 *
 * It returns two angles:  Theta is the radians away from the XZ plane and phi
 * is the radians away from the Z axis once in the XZ plane.
 *
 * To rotate the vector into the Z axis, rotate first by -theta, then by -phi
 *
 *
 * Mark Meuer
 */

#include	"matrix.h"

void
angles_from_z(vector, user_theta, user_phi)
Vector          vector;
Angle          *user_theta;
Angle          *user_phi;
{
	/* DECLARE VARIABLES */
	Vector          temp_vector;
	Angle           theta;
	Angle           phi;
	double          vector_radius;
	double          xy_radius;	/* length of vector projected onto xy */
	char            error_string[ERROR_STRING_LENGTH];
	char            debug_string[DEBUG_STRING_LENGTH];

	/* GET LENGTH OF VECTOR PROJECTED ONTO XY PLANE */
	copy_vector(temp_vector, vector);
	temp_vector[2] = 0.0;
	xy_radius = (double) vector_norm(temp_vector);
	vector_radius = (double) vector_norm(vector);

	/* MAKE SURE VECTOR IS NOT NULL */
	if (vector_radius == (double) 0.0)
	{
		sprintf(error_string,
			"angles_from_z: NULL rotation vector = (%f, %f, %f)",
			(float) vector[0],
			(float) vector[1],
			(float) vector[2]);
		fatal_error(error_string);
	}
	/* GET ANGLE NEEDED TO SWING VECTOR INTO XZ PLANE */
	/* ONLY DO IT IF NOT IN Z AXIS ALREADY */
	if (xy_radius != (double) 0.0)
	{
		theta = (float) asin((double) (fabs((double) vector[1]) / xy_radius));
		/* theta = (float) asin((double) (vector[1] / xy_radius)); */
		/* GET ANGLE TO SWING INTO Z AXIS */
		/* ONLY DO IF Z IS NOT ZERO */
		if (vector_radius != (double) 0.0)
		{
			phi = (float) asin((double) (xy_radius / vector_radius));
		} else
		{
			phi = (Angle) (PI / 2.0);
		}

		sprintf(debug_string,
			"angles_from_z: before octant corrections: theta = %f, phi = %f\n",
			(float) theta,
			(float) phi);
		debug(debug_string);


		/*
		 * THESE ANGLES HAVE BEEN FIGURED FOR THE FIRST OCTANTANT.
		 * CORRECT ANGLES FOR OCTANTS THEY ARE IN.
		 */
		/* CORRECT THETA */

		/*
		 * if ((vector[0] < 0.0) && (vector[1] > 0.0)) { theta +=
		 * (Angle) (PI / 2.0); } else if ((vector[0] < 0.0) &&
		 * (vector[1] < 0.0)) { theta += (Angle) PI; } else if
		 * ((vector[0] > 0.0) && (vector[1] < 0.0)) { theta +=
		 * (Angle) (3.0 * PI / 2.0); }
		 */
		/* First, correct for X <= 0 */
		if (vector[0] <= 0.0)
		{
			if (vector[1] <= 0.0)	/* X and y < 0 */
			{
				theta = (Angle) (PI + theta);
			} else	/* x < 0, y > 0 */
			{
				theta = (Angle) (PI - theta);
			}
		} else		/* Now correct for x > 0 */
		{
			if (vector[1] <= 0.0)	/* X > 0, y < 0 */
			{
				theta *= -1.0;
			}
		}


		/*
		 * if ((vector[0] > 0.0) && (vector[1] < 0.0)) { theta *=
		 * -1.0; } else if ((vector[0] <= 0.0) && (vector[1] >= 0.0))
		 * { theta = (Angle) (PI - theta); } else if ((vector[0] <
		 * 0.0) && (vector[1] < 0.0)) { theta = (Angle) (PI + theta);
		 * }
		 */
		/* CORRECT PHI */
		if (vector[2] < 0.0)
		{
			phi += (Angle) (PI / 2.0);
		}
	} else			/* vector is already Z axis */
	{
		theta = (Angle) 0.0;
		phi = (Angle) 0.0;
	}

	sprintf(debug_string,
		"angles_from_z: after octant corrections theta = %f, phi = %f,\nxy_radius = %f, vector_radius = %f\n",
		(float) theta,
		(float) phi,
		(float) xy_radius,
		(float) vector_radius);
	debug(debug_string);

	/* RETURN VALUES TO USER */
	*user_theta = theta;
	*user_phi = phi;
}
