
/*
  $Header: /usr4/Geom_utilities/Poly2xy/RCS/parse_command.c,v 1.2 91/03/12 16:43:50 meuer Exp $

  Parse the command line, print usage message if necessary.

  Mark Meuer
  #1267045

  */


#include	<malloc.h>
#include	<strings.h>
#include	"poly2xy.h"


void
parse_command_line( argc, argv, in_file, out_file, sides )
     int	argc;
     char	**argv;
     char	**in_file;
     char	**out_file;
     int	*sides;		/* Number of sides in the polygons */
{
    int	cur_arg = 1;		/* Current argument being processed */
    int	more_options = TRUE;

    /* PROCESS THE OPTIONS */
    *sides = 3;		/* Default to processing triangles. */
    for( cur_arg = 1; (cur_arg < argc) && (more_options); cur_arg++ )
    {
	  if ( strcmp("-sides", argv[cur_arg]) == 0 )
	{
	    cur_arg++;
	    if ( cur_arg > argc )
	    {
		usage( argv[0] );
	    }
	    else
	    {
		*sides = atoi(argv[cur_arg]);
		if ( *sides < 3 )
		{
		    fprintf(stderr, "-sides %d option in effect.\n", *sides );
		    fprintf(stderr, "Whoa!  Input polygons have to have at least 3 sides!  Bye.\n");
		    exit(-1);
		}
		
	    }

	} 
	else	/* no options were found */
	{
	    more_options = FALSE;
	    cur_arg--;	/* This is to remove the effect of cur_arg++ at end of loop */
	}
    }
    fprintf(stderr, "Expecting %d sided polygons on input.\n", *sides);
    fflush(stderr);

    
    /* GET THE FILE NAMES */
    /* Check for 2 arguements left */
    if ( argc - cur_arg != 2 )
    {
	usage( argv[0] );
    }
    else
    {
	*in_file = malloc(sizeof(char) * strlen(argv[cur_arg]));
	strcpy(*in_file, argv[cur_arg++]);
	*out_file = malloc(sizeof(char) * strlen(argv[cur_arg]));
	strcpy(*out_file, argv[cur_arg++]);
    }
}



/*
  PRINT A USAGE MESSAGE, COUGH UP A HAIRBALL, AND DIE.
  */
void
usage( prog_name )
     char	*prog_name;     
{
    fprintf(stderr, "Usage: %s [-sides <n>] <input file> <output file>\n", prog_name );
    fprintf(stderr, "  Transforms a list of polygons to reside in the XY plane.\n\n");
    fprintf(stderr, "  -sides <n> - Specificy number of sides of input polygons.\n");
    fprintf(stderr, "               n defaults to 3.\n\n");
    fprintf(stderr, "  Use \"-\" for the file names to read and write\n" );
    fprintf(stderr, "  to standard input and output, repectively.\n\n" );
    fprintf(stderr, "  Program by Mark Meuer.  (C) 1991 by Geometry Supercomputer Project.\n\n");
                       
    exit(-1);
}
