#include 	"extern.h"

/* all the following functions draw circles to the screen or choose color schemes for drawing */

assigncolor()	{
/* assign colors constant on hexagonal generations concentric with the nullpoint */
	int		i, j, k, generation, maxgen, max, mynbrs[6], mypos[6][2], n;

	if (width>height)	max = width;
	else	max = height;
	for (i=0; i<hw; ++i)	
		RCirc[i].cnum = 0;
	if (nulli == 0)	{
	/* nullcircle is a hole; find a suitable entry in the hole for the origin of coloring */
		int	iholesum, jholesum, normcycle, indx;
	
		iholesum = jholesum = normcycle = 0;
		for (i=1; i<height-1; ++i)	{
			for (j=1; j<width-1; ++j)	{	
				indx = j+i*width;
				if (DCirc[indx].state == nullj+10)	{
					iholesum += i;
					jholesum += j;
					++normcycle;
				}
			}
		}			
		iholesum = iholesum/(double)normcycle;
		jholesum = jholesum/(double)normcycle;
		indx = jholesum+iholesum*width;
		RCirc[indx].cnum = 1;
	}
	else
		RCirc[nullj+nulli*width].cnum = 1;
	generation = maxgen = 1;

	for (k=0; k<max; ++k)	{	
	/* label the next concentric hexagon via the .cnum flag */
		for (i=1; i<height-1; ++i)	{
			for (j=1; j<width-1; ++j)	{	
				if (RCirc[j+i*width].cnum == 0)	{
				/* check whether the (i,j) entry has a neighbor on the last hexagon */
					getccindices(i, j, mypos);
					for (n=0; n<NUMNBRS; ++n)	{
						mynbrs[n] = RCirc[mypos[n][1]+mypos[n][0]*width].cnum;
						if (mynbrs[n] == generation)	{
							RCirc[j+i*width].cnum = generation+1;
							maxgen = generation+1;
							break;
						}
					}
				}
			}
		}
		generation++;
	}
	/* assign colors constant on hexagons */
	for (i=0; i<mynorm; ++i)
		mycolor[i] = 255-(11*RCirc[myindex[i]].cnum)%253;
	for (i=0; i<hw; ++i)
		RCirc[i].cnum = 0; 	
} /*assigncolor*/

changenull(mywin, a, b)
/* given a mouse point (a,b), this function changes the nullcircle to that interior circle */
/* closest to (a,b) and prints the resulting range packing */
Window	mywin;
int	a, b;
{
	int	oldtemp, newtemp, oldnulli, oldnullj, x, y, i, j;
	
	massagemode = FALSE;
	/* Save old nullcircle index */
	oldnulli = nulli;
	oldnullj = nullj;

	/* Get a new nullcircle index (nulli, nullj) */
	if (mywin == rangewin)
		getplotnull(RPlot, a, b);
	if (mywin == domainwin)
		getplotnull(DPlot, a, b);

	if ((nulli != oldnulli) || (nullj != oldnullj))	{
	/* New nullcircle is different from old */
		oldtemp = oldnullj+oldnulli*width;
		newtemp = nullj+nulli*width;

		/* Get new color scheme */
		assigncolor();

		/* If mouse was clicked in the domain window, redraw domain first */
		if (mywin == domainwin)	{
			drawdomain();
		}

		/* recenter range circle packing at the origin */
		translate(RCirc, -RANGERAD, -RANGERAD);

		/* Scale range packiing down to unit disk size */
		scalecircs(RCirc, 1/RANGERAD);

		/* Recompute nullcircle */
		if (nulli == 0)	{
			/* Nullcircle is a hole */
			twist(RHole[newtemp].x, RHole[newtemp].y);
			linfract(RHole[newtemp].x);
		}
		else	{
			/* Nullcircle is not a hole circle */
			twist(RCirc[newtemp].x, RCirc[newtemp].y);
			linfract(RCirc[newtemp].x);
		}
		if (nulli == 0)	{
		/* Nullcircle is a hole
		Twist so average of outer border circle to right lies on the positive real axis */
			int	iholemax, iholemin, ihole, jhole, indx;
		
			ihole = jhole = iholemax = 0;
			iholemin = 9999;
			/* Find extreme indices of inner boundary indices */
			for (i=1; i<height-1; ++i)	{
				for (j=1; j<width-1; ++j)	{	
					indx = j+i*width;
					if (DCirc[indx].state == nullj+10)	{
						if (iholemax < i) iholemax = i;
						if (iholemin > i) iholemin = i;
					}
				}
			}			

			/* Find central outer border index to right of hole */
			ihole = (iholemax + iholemin)/2.0;
			for (j=width-1; j>=1; --j)	{	
				indx = j+ihole*width;
				if (DCirc[indx].state > 0)	{
					jhole = j;
					break;

				}
			}

			/* Twist so average of outer border circle to right lies on the positive real axis */
			indx = jhole+ihole*width;
			twist(RCirc[indx].x, RCirc[indx].y);
		}
		else	{
		/* Twist so first domain circle to right of nullcircle lies on the positive real axis. */
			i = 1;
			while (RCirc[newtemp+i].state <= OUTSIDE)	++i;
				twist(RCirc[newtemp+i].x, RCirc[newtemp+i].y);
		}

		/* Redraw range circle packing */
		scalecircs(RCirc, RANGERAD);
		translate(RCirc, RANGERAD, RANGERAD);
		drawrange();

		/* If mouse was clicked in range window, redraw domain last */
		if (mywin == rangewin)
			drawdomain();
	}
}


drawdomain()	{
/* Draw the circle domain and its bounding curves */
	int		i, j, x, y, indx;
	Bool		newloop, inner;
	
	XESetFlushGC(dpy, 0, NULL);
	XFlush(dpy);
	XClearWindow(dpy, domainwin);
	XSetForeground(dpy, gc, 1);
	/* Draw the bounding curves */
	newloop = TRUE;
	for (i=0; i<normRgn; ++i)	{
		if (myRgnPoint[i].x < 0)	
			newloop = TRUE;
		else	{
			if (newloop)	{
			/* Draw a point */
				XDrawLine (dpy, domainwin, gc, myRgnPoint[i].x, myRgnPoint[i].y, myRgnPoint[i].x, myRgnPoint[i].y);
				newloop = FALSE;
			}
			else
			/* Draw a line segment */
				XDrawLine (dpy, domainwin, gc, myRgnPoint[i-1].x, myRgnPoint[i-1].y, myRgnPoint[i].x, myRgnPoint[i].y);
		}
	}
	/* Draw the circles packing the curves interior */
	for (i=0; i<mynorm; ++i)	{
		inner = TRUE;
		if (massagemode)	{
		/* In Thurston boundary modification mode.
		Draw only inner domain circles here.
		Border circles might be adjusted before drawing */
			if ((DCirc[myindex[i]].state != INTERIOR)
			&& (DCirc[myindex[i]].state != DEEPINSIDE))	{
				inner = FALSE;
			}
		}
		if (inner)	{
			x = DCirc[myindex[i]].x-fillrad;
			y = DCirc[myindex[i]].y-fillrad;
			XSetForeground(dpy, gc, mycolor[i]);
			if (bdrymode == PLAINMODE)
			/* Draw a disk */
				XFillArc(dpy, domainwin, gc, x, y, (int)(2*fillrad+1), (int)(2*fillrad+1), 0, X360DEGREES);
			if (bdrymode == THURSTONMODE)
			/* Draw a circle */
				XDrawArc(dpy, domainwin, gc, x, y, (int)(2*fillrad+1), (int)(2*fillrad+1), 0, X360DEGREES);
		}
	}
	XSetForeground(dpy, gc, 1);
	if (nulli != 0)	{
	/* Dot nullcircle */
		i = nullj+nulli*width;
		x = DCirc[i].x-2;
		y = DCirc[i].y-2;
		XFillArc(dpy, domainwin, gc, x, y, 4, 4, 0, X360DEGREES);
	}
	XFlush(dpy);
} /*drawdomain*/
				
drawrange()	{
/* Draw the range packing of the disk */
	int		i, j, x, y, indx, diam;
	
	XESetFlushGC(dpy, 0, NULL);
	XFlush(dpy);
	XClearWindow(dpy, rangewin);
	XSetForeground(dpy, gc, 1);

	/* Draw the "unit" circle */
	XDrawArc(dpy, rangewin, gc, 0, 0, (int)(2*RANGERAD), (int)(2*RANGERAD), 0, X360DEGREES);
	for (i=0; i<mynorm; ++i)	{
	/* Draw circles packing the disk */
		x = RCirc[myindex[i]].x-RCirc[myindex[i]].r;
		y = RCirc[myindex[i]].y-RCirc[myindex[i]].r;
		diam = fabs(2*RCirc[myindex[i]].r);
		XSetForeground(dpy, gc, mycolor[i]);
		if (bdrymode == PLAINMODE)
		/* Draw a disk */
			XFillArc(dpy, rangewin, gc, x, y, diam+1, diam+1, 0, X360DEGREES);
		if (bdrymode == THURSTONMODE)
		/* Draw a circle */
			XDrawArc(dpy, rangewin, gc, x, y, diam+1, diam+1, 0, X360DEGREES);
	}

	/* Record in RPlot the plotted coordinates of the range circles */
	for (i=0; i<hw; ++i)	{
		RPlot[i].x = RCirc[i].x;
		RPlot[i].y = RCirc[i].y;
		RPlot[i].state = RCirc[i].state;
	}
	 
	/* Draw the hole circles */
	XSetForeground(dpy, gc, 1);
	for (i=0; i<numholes; ++i)	{
		x = RHole[i].x-RHole[i].r;
		y = RHole[i].y-RHole[i].r;
		diam = fabs(2*RHole[i].r);
		XDrawArc(dpy, rangewin, gc, x, y, diam, diam, 0, X360DEGREES);
	}
	if (nulli != 0)	{
	/* Dot nullcircle */
		i = nullj+nulli*width;
		x = RCirc[i].x-2;
		y = RCirc[i].y-2;
		XFillArc(dpy, rangewin, gc, x, y, 4, 4, 0, X360DEGREES);
	}
	XFlush(dpy);
} /*drawrange*/

