#include "extern.h"

#define BORDER	1
#define DSTRING	"Domain"
#define RSTRING	"Range"
static	double		minrad = MINRAD;

/* All these functions involve windowing or dialog */

mygetbutton() 	{
/* Handle mouse clicks for recomputing nullpoint or subdividing the mesh */
    	XEvent     	myevent;	
	int		downx, downy, a, b;
	
	subdividing = FALSE;
	printf("\nButton 1 or 2 on a circle recomputes the nullpoint.\n");
	printf("Button 3 halves the filling radius and resumes computations.\n");
	printf("Control c terminates.\n");
    	XSelectInput(dpy, rangewin, ButtonPressMask);
    	while (!subdividing) {
	/* User is examining pictures and perhaps computing a new nullpoint */
		XNextEvent(dpy, &myevent);
		if (myevent.type == ButtonPress) 	{
			downx = myevent.xbutton.x;
			downy = myevent.xbutton.y;
			if (myevent.xbutton.window == rangewin) 	{
				if (myevent.xbutton.button < 3) {
				/* recompute nullpoint */
					changenull(rangewin, downx, downy);	/* Mobius transformation */
					doholeinfo();	/* print center and radii of holes */
				}
			}
			if (myevent.xbutton.window == domainwin) 	{
				if (myevent.xbutton.button < 3) {
				/* recompute nullpoint */
					changenull(domainwin, downx, downy);	/* Mobius transformation */
					doholeinfo();	/* print center and radii of holes */
				}
			}
			if (myevent.xbutton.button > 2) {
			/* Halve the filling radius, refill the domain and resume computations */
				if (bdrymode == THURSTONMODE)	massagemode = TRUE;
				subdividing = TRUE;
			}
		}
	}
} /* mygetbutton */


static XWMHints	xwmh = {
    			(InputHint|StateHint),		/* flags */
    			True,				/* input */
    			NormalState,			/* initial_state */
    			0,				/* icon pixmap */
    			0,				/* icon window */
    			0, 0,				/* icon location */
    			0,				/* icon mask */
    			0,				/* Window group */
		};

myXbegin(argc, argv)
int argc;
char **argv;
{
    	unsigned long 		fg, bg, bd, bw;
    	XGCValues   		gcv;		
    	XSizeHints  		xsh;	
    	XSetWindowAttributes 	xswa;	
	XEvent			myevent;

	LRATIO = sizeof(double)/sizeof(int);

	XSetErrorHandler(NULL);
    	dpy = XOpenDisplay(NULL);

	/* Set up domain window */
    	bd = BlackPixel(dpy, DefaultScreen(dpy));
    	bg = WhitePixel(dpy, DefaultScreen(dpy));
    	fg = BlackPixel(dpy, DefaultScreen(dpy));

    	bw = 1;

    	xsh.flags = PSize;
	/* Height and width of domain window */
	xsh.width = (int) (2*DOMAINRAD);
	xsh.height = (int) (2*DOMAINRAD);

    	domainwin = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), 0, 0, xsh.width, xsh.height, bw, bd, bg);
    	XSetStandardProperties(dpy, domainwin, DSTRING, DSTRING, None, argv, argc, &xsh);
    	XSetWMHints(dpy, domainwin, &xwmh);
	
    	xswa.colormap = DefaultColormap(dpy, DefaultScreen(dpy));
    	xswa.bit_gravity = CenterGravity;
    	XChangeWindowAttributes(dpy, domainwin, (CWColormap | CWBitGravity), &xswa);

    	gcv.foreground = fg;
    	gcv.background = bg;
    	gc = XCreateGC(dpy, domainwin, (GCForeground | GCBackground), &gcv);

	/* Wait for user to open domain window */
    	XSelectInput(dpy, domainwin, ExposureMask);
    	XMapRaised(dpy, domainwin);
	XNextEvent(dpy, &myevent);
	XDefineCursor(dpy, domainwin, XCreateFontCursor(dpy, XC_draft_small));

	/* Set up range window */

	/* Height and width of domain window */
	xsh.width = (int)(2*RANGERAD);
	xsh.height = (int)(2*RANGERAD);
    	rangewin = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), 0, 0, xsh.width, xsh.height, bw, bd, bg);
    	XSetStandardProperties(dpy, rangewin, RSTRING, RSTRING, None, argv, argc, &xsh);
    	XSetWMHints(dpy, rangewin, &xwmh);
    	XChangeWindowAttributes(dpy, rangewin, (CWColormap | CWBitGravity), &xswa);
    	gc = XCreateGC(dpy, rangewin, (GCForeground | GCBackground), &gcv);

	/* Wait for user to open range window */
    	XSelectInput(dpy, rangewin, ExposureMask);
    	XMapRaised(dpy, rangewin);
	XNextEvent(dpy, &myevent);
	XDefineCursor(dpy, rangewin, XCreateFontCursor(dpy, XC_draft_small));
} /* myXbegin */


graceful_exit()
{
    	XEvent      		myevent;	
	int waiting = TRUE;
	/* if we haven't drawn anything yet, draw it before leaving */
	if (!drawdomain_flag)	{
		drawdomain();
	}
        XSelectInput(dpy, rangewin, ButtonPressMask);
        printf("Min radius attained. Click mouse to exit.\n");
        /* Wait for mouse click */
        while (waiting) {
                XNextEvent(dpy, &myevent);
                if (myevent.type == ButtonPress) exit();
	}
} /* graceful_exit */


getoption() 	{
/* Let user choose boundary modification */
	Bool	prompting;

	prompting = TRUE;
	while (prompting)	{
		printf ("Enter 1 for no boundary modification\n ");
		printf ("     2 for Thurston boundary modification\n ");
		printf ("===> ");
		scanf ("%d", &bdrymode);
		printf ("\n");
		if (bdrymode == PLAINMODE)	{
		/* No boundary modification; all circles are tangent */
			massagemode = FALSE;
			prompting = FALSE;
		}
		if (bdrymode == THURSTONMODE)	{
		/* Some circles near the border may intersect at prescribed angles */
			massagemode = TRUE;
			prompting = FALSE;
		}
	}
} /* getoption */

mygetradius()
/* Dialog with user to get a filling radius and fill the region with the regular hexagonal circle packing */
{
	double	rad;
	Bool	filling;
	if (runcount==0)	{
	/* Let user choose filling radius */
		filling = TRUE;
		while (filling)	{
			printf ("Enter a filling radius, or 0 if satisfied with the mesh ==> ");
			scanf ("%lf", &rad);
			if (rad > 0)	{
			/* Fill the region with circles of radius rad */
				fillrad = rad;
				endcircs();
				fillcircles(fillrad);
			}
			else	
			filling = FALSE;
		} /*while*/
	}
	else	{
	/* Halve previous filling radius */
		fillrad = fillrad/2.0;
		if (fillrad < minrad) 
		/* Exit program if filling radius is too small */
			graceful_exit();
		endcircs();
		/* Fill the region with circles of radius fillrad */
		fillcircles(fillrad);
	}
} /* mygetradius */


doholeinfo()	{
/* Print centers and radii of the hole circles */
	int	i;

	if (numholes > 0)
		printf ("\nCenters and radii of holes\n");
	for (i=0; i<numholes; ++i)	{
		printf ("x = %lf    y = %lf   radius = %.14lf\n", 
			(RHole[i].x-RANGERAD)/RANGERAD, -(RHole[i].y-RANGERAD)/RANGERAD, RHole[i].r/RANGERAD);
	}
} /* doholeinfo */

/* Print various error diagnostics; remove later */
doinfo(circ, hole)
circleinfo *circ, *hole;
{
	int	i, j, k;

	if (circ == DCirc)	printf("DCirc\n");
	else		printf("RCirc\n");

	for (i=0; i<height; ++i)	{
		for (k=0; k<i; ++k)	printf("   ");
		for (j=0; j<width; ++j)	{
			if (circ[j+i*width].state > 0)
				printf("%6.3lf", circ[j+i*width].x);
			else
				printf("      ");
		}
		printf("\n");
	}
	printf("\n\n");
	sleep(3);

} /*doinfo*/
