        SUBROUTINE  NNFC
     *     (N, R,C,IC, IA,JA,A, Z, B,                                     CD 843
     *      LMAX,IL,JL,IJL,L, D, UMAX,IU,JU,IJU,U,                        CD 844
     *      ROW, TMP, IRL,JRL, FLAG)                                      CD 845
C                                                                         CD 846
C       INPUT VARIABLES:   N, R, C, IC, IA, JA, A, B,                     CD 847
C                          IL, JL, IJL, LMAX, IU, JU, IJU, UMAX           CD 848
C       OUTPUT VARIABLES:  Z, L, D, U, FLAG                               CD 849
C                                                                         CD 850
C       PARAMETERS USED INTERNALLY:                                       CD 851
C NIA   \ IRL,  - VECTORS USED TO FIND THE ROWS OF  L.  AT THE KTH STEP   CD 852
C NIA   \ JRL       OF THE FACTORIZATION,  JRL(K)  POINTS TO THE HEAD     CD 853
C       \           OF A LINKED LIST IN  JRL  OF COLUMN INDICES J         CD 854
C       \           SUCH J .LT. K AND  L(K,J)  IS NONZERO.  ZERO          CD 855
C       \           INDICATES THE END OF THE LIST.  IRL(J)  (J.LT.K)      CD 856
C       \           POINTS TO THE SMALLEST I SUCH THAT I .GE. K AND       CD 857
C       \           L(I,J)  IS NONZERO.                                   CD 858
C       \           SIZE OF EACH = N.                                     CD 859
C FIA   \ ROW   - HOLDS INTERMEDIATE VALUES IN CALCULATION OF  U AND L.   CD 860
C       \           SIZE = N.                                             CD 861
C FIA   \ TMP   - HOLDS NEW RIGHT-HAND SIDE  B'  FOR SOLUTION OF THE      CD 862
C       \           EQUATION UX = B'.                                     CD 863
C       \           SIZE = N.                                             CD 864
C                                                                         CD 865
C  INTERNAL VARIABLES:                                                    CD 866
C    JMIN, JMAX - INDICES OF THE FIRST AND LAST POSITIONS IN A ROW TO     CD 867
C      BE EXAMINED.                                                       CD 868
C    SUM - USED IN CALCULATING  TMP.                                      CD 869
C                                                                         CD 870
        INTEGER RK,UMAX                                                   CD 871
        INTEGER  R(1), C(1), IC(1), IA(1), JA(1), IL(1), JL(1), IJL(1)    CD 872
        INTEGER  IU(1), JU(1), IJU(1), IRL(1), JRL(1), FLAG               CD 873
C       REAL  A(1), L(1), D(1), U(1), Z(1), B(1), ROW(1)                  CD 874
C       REAL TMP(1), LKI, SUM, DK                                         CD 875
        DOUBLE PRECISION  A(1), L(1), D(1), U(1), Z(1), B(1), ROW(1)      CD 876
        DOUBLE PRECISION  TMP(1), LKI, SUM, DK                            CD 877
C                                                                         CD 878
C  ******  INITIALIZE POINTERS AND TEST STORAGE  ***********************  CD 879
        IF(IL(N+1)-1 .GT. LMAX) GO TO 104                                 CD 880
        IF(IU(N+1)-1 .GT. UMAX) GO TO 107                                 CD 881
        DO 1 K=1,N                                                        CD 882
          IRL(K) = IL(K)                                                  CD 883
          JRL(K) = 0                                                      CD 884
   1      CONTINUE                                                        CD 885
C                                                                         CD 886
C  ******  FOR EACH ROW  ***********************************************  CD 887
        DO 19 K=1,N                                                       CD 888
C  ******  REVERSE JRL AND ZERO ROW WHERE KTH ROW OF L WILL FILL IN  ***  CD 889
          ROW(K) = 0                                                      CD 890
          I1 = 0                                                          CD 891
          IF (JRL(K) .EQ. 0) GO TO 3                                      CD 892
          I = JRL(K)                                                      CD 893
   2      I2 = JRL(I)                                                     CD 894
          JRL(I) = I1                                                     CD 895
          I1 = I                                                          CD 896
          ROW(I) = 0                                                      CD 897
          I = I2                                                          CD 898
          IF (I .NE. 0) GO TO 2                                           CD 899
C  ******  SET ROW TO ZERO WHERE U WILL FILL IN  ***********************  CD 900
   3      JMIN = IJU(K)                                                   CD 901
          JMAX = JMIN + IU(K+1) - IU(K) - 1                               CD 902
          IF (JMIN .GT. JMAX) GO TO 5                                     CD 903
          DO 4 J=JMIN,JMAX                                                CD 904
   4        ROW(JU(J)) = 0                                                CD 905
C  ******  PLACE KTH ROW OF A IN ROW  **********************************  CD 906
   5      RK = R(K)                                                       CD 907
          JMIN = IA(RK)                                                   CD 908
          JMAX = IA(RK+1) - 1                                             CD 909
          DO 6 J=JMIN,JMAX                                                CD 910
            ROW(IC(JA(J))) = A(J)                                         CD 911
   6        CONTINUE                                                      CD 912
C  ******  INITIALIZE SUM, AND LINK THROUGH JRL  ***********************  CD 913
          SUM = B(RK)                                                     CD 914
          I = I1                                                          CD 915
          IF (I .EQ. 0) GO TO 10                                          CD 916
C  ******  ASSIGN THE KTH ROW OF L AND ADJUST ROW, SUM  ****************  CD 917
   7        LKI = -ROW(I)                                                 CD 918
C  ******  IF L IS NOT REQUIRED, THEN COMMENT OUT THE FOLLOWING LINE  **  CD 919
            L(IRL(I)) = -LKI                                              CD 920
            SUM = SUM + LKI * TMP(I)                                      CD 921
            JMIN = IU(I)                                                  CD 922
            JMAX = IU(I+1) - 1                                            CD 923
            IF (JMIN .GT. JMAX) GO TO 9                                   CD 924
            MU = IJU(I) - JMIN                                            CD 925
            DO 8 J=JMIN,JMAX                                              CD 926
   8          ROW(JU(MU+J)) = ROW(JU(MU+J)) + LKI * U(J)                  CD 927
   9        I = JRL(I)                                                    CD 928
            IF (I .NE. 0) GO TO 7                                         CD 929
C                                                                         CD 930
C  ******  ASSIGN KTH ROW OF U AND DIAGONAL D, SET TMP(K)  *************  CD 931
  10      IF (ROW(K) .EQ. 0) GO TO 108                                    CD 932
          DK = 1 / ROW(K)                                                 CD 933
          D(K) = DK                                                       CD 934
          TMP(K) = SUM * DK                                               CD 935
          IF (K .EQ. N) GO TO 19                                          CD 936
          JMIN = IU(K)                                                    CD 937
          JMAX = IU(K+1) - 1                                              CD 938
          IF (JMIN .GT. JMAX)  GO TO 12                                   CD 939
          MU = IJU(K) - JMIN                                              CD 940
          DO 11 J=JMIN,JMAX                                               CD 941
  11        U(J) = ROW(JU(MU+J)) * DK                                     CD 942
  12      CONTINUE                                                        CD 943
C                                                                         CD 944
C  ******  UPDATE IRL AND JRL, KEEPING JRL IN DECREASING ORDER  ********  CD 945
  13      I = I1                                                          CD 946
          IF (I .EQ. 0) GO TO 18                                          CD 947
  14      IRL(I) = IRL(I) + 1                                             CD 948
          I1 = JRL(I)                                                     CD 949
          IF (IRL(I) .GE. IL(I+1)) GO TO 17                               CD 950
          IJLB = IRL(I) - IL(I) + IJL(I)                                  CD 951
          J = JL(IJLB)                                                    CD 952
  15      IF (I .GT. JRL(J)) GO TO 16                                     CD 953
            J = JRL(J)                                                    CD 954
            GO TO 15                                                      CD 955
  16      JRL(I) = JRL(J)                                                 CD 956
          JRL(J) = I                                                      CD 957
  17      I = I1                                                          CD 958
          IF (I .NE. 0) GO TO 14                                          CD 959
  18      IF (IRL(K) .GE. IL(K+1)) GO TO 19                               CD 960
          J = JL(IJL(K))                                                  CD 961
          JRL(K) = JRL(J)                                                 CD 962
          JRL(J) = K                                                      CD 963
  19      CONTINUE                                                        CD 964
C                                                                         CD 965
C  ******  SOLVE  UX = TMP  BY BACK SUBSTITUTION  **********************  CD 966
        K = N                                                             CD 967
        DO 22 I=1,N                                                       CD 968
          SUM =  TMP(K)                                                   CD 969
          JMIN = IU(K)                                                    CD 970
          JMAX = IU(K+1) - 1                                              CD 971
          IF (JMIN .GT. JMAX)  GO TO 21                                   CD 972
          MU = IJU(K) - JMIN                                              CD 973
          DO 20 J=JMIN,JMAX                                               CD 974
  20        SUM = SUM - U(J) * TMP(JU(MU+J))                              CD 975
  21      TMP(K) =  SUM                                                   CD 976
          Z(C(K)) =  SUM                                                  CD 977
  22      K = K-1                                                         CD 978
        FLAG = 0                                                          CD 979
        RETURN                                                            CD 980
C                                                                         CD 981
C ** ERROR:  INSUFFICIENT STORAGE FOR L                                   CD 982
 104    FLAG = 4*N + 1                                                    CD 983
        RETURN                                                            CD 984
C ** ERROR:  INSUFFICIENT STORAGE FOR U                                   CD 985
 107    FLAG = 7*N + 1                                                    CD 986
        RETURN                                                            CD 987
C ** ERROR:  ZERO PIVOT                                                   CD 988
 108    FLAG = 8*N + K                                                    CD 989
        RETURN                                                            CD 990
        END                                                               CD 991
