./" $Id: lgd.tpl,v 1.7 89/09/20 17:49:16 mbp Exp $
./"
./" lgd.?: main manual page for LGD procedures
./"
./" by Mark B. Phillips
./"
./" BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
./" 
./" This is a manual page "template". Before formatting to make the
./" actual manual page, this file should be edited to change the
./" following strings to whatever is appropriate for your system:
./" 
./" MANSECTION_VALUE:
./"	extension (section numer) for man page
./" 
./" INCLDIR_VALUE:
./"	pathname of directory containing installed copy of lgd.h
./"
./" LIBDIR_VALUE:
./"	pathname of directory containing installed library file (liblgd.a)
./"
./" LIBFLAGS_VALUE:
./"     flags to pass to ld(1) to tell it where to find the libraries
./"     necessary for LGD programs.  Should include the LGD library
./"     itself as well as any required -L options and additional
./"     libraries.
./"
./" AUXDIR_VALUE:
./"	pathname of directory containing installed copies of
./"	  auxiliary files (lgdsunview.help)
./"
./" SAMPLEDIR_VALUE:
./"	pathname of directory containing installed copy of
./"	  lgddemo.c
./"
./" This can be done with a sed command, which is normally done by the
./" lgd makefile during installation, or by the explicit command 'make
./" lgd.<n>', where <n> is the number you specify for MANEXT in the
./" Makefile.
./" 
./" EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
.TH LGD MANSECTION_VALUE "September 19, 1989"
.SH NAME
lgd - LGD procedures
.SH SYNOPSIS
.B #include
"INCLDIR_VALUE/lgd.h"
.nf

cc myprogram.c LIBFLAGS_VALUE

.PP
.B lgd_initialize()
.PP
.B lgd_define_world(dim, wbox_low, wbox_high)
.B int dim;
.B double wbox_low[], wbox_high[];
.PP
.B lgd_set_menu( menu )
.B lgd_Menu \(**menu;
.PP
.B lgd_main_loop()
.PP
.B lgd_end_loop()
.PP
.B lgd_move_abs( v )
.B double v[];
.PP
.B lgd_draw_abs( v )
.B double v[];
.PP
.B lgd_move_rel( v )
.B double v[];
.PP
.B lgd_draw_rel( v )
.B double v[];
.PP
.B lgd_point()
.PP
.B lgd_set_color( color )
.B int \(**color;
.PP
.B lgd_begin_segment( n )
.B int \(**n;
.PP
.B lgd_end_segment()
.PP
.B lgd_update_display()
.PP
.B lgd_delete_segment( n )
.B int n;
.PP
.B lgd_delete_all()
.B int n;
.PP
.B lgd_set_segment_visibility( n, v )
.B int n, v;
.PP
.B lgd_set_view( view )
.B lgd_View3 \(**view;
.PP
.B lgd_get_default_view( view )
.B lgd_View3 \(**view;
.PP
.B lgd_save_world( filename )
.B char \(**filename;
.PP
.B lgd_load_world( filename )
.B char \(**filename;
.PP
.B lgd_get_string( s )
.B char \(**s;
.PP
.B lgd_put_string( s )
.B char \(**s;
.PP
.B int lgd_confirm( prompt )
.B char \(**prompt;
.PP
.B lgd_get_point( v )
.B double v[];
.PP
.B lgd_pick_segment( s, n )
.B int **s, *n;
.PP
.B lgd_set_pick_tolerance( t )
.B double t;
.PP
.B lgd_inquire_world(dim, wbox_low, wbox_high)
.B int \(**dim;
.B double wbox_low[], wbox_high[];
.PP
.B lgd_inquire_color( n )
.B int \(**n;
.PP
.B lgd_inquire_menu( menu )
.B lgd_Menu \(***menu;
.PP
.B lgd_inquire_current_segment( n )
.B int \(**n;
.PP
.B lgd_inquire_segment_visibility( n, v )
.B int n, \(**v;
.PP
.B lgd_inquire_view( view )
.B lgd_View3 \(**view;
.PP
.B lgd_inquire_pick_tolerance( t )
.B double \(**t;
.PP
.B lgd_signal(sig, func)
.B int sig, (\(**func)();
.PP
.B lgd_set_input_func(func, fd)
.B int (\(**func)(), fd;
.SH DESCRIPTION
These are the LGD functions.  See
lgdintro(MANSECTION_VALUE)
for an introduction to LGD.
.PP
An application program should call
.I lgd_initialize
before calling any other LGD procedure.  It should then call
.I lgd_define_world
to define the "world" coordinate system.  This is the coordinate
system in which all subsequent moves and draws will be done.  In the
call to 
.I lgd_define_world,
.I dim
must equal 3 (future versions may allow other dimensions),
.I wbox_low
and 
.I wbox_high
should be 3-component arrays giving the lower
and upper limits, respectively, of the three coordinate directions.
The world coordinate system will consist of the rectangular
box in three-space with these two points as diagonally opposite
corners.
.PP
The program should then call
.I lgd_set_menu
to specify a menu of options to be presented to the user
once the device is "started".  The menu is specified by a pointer
to an object of type
.I lgd_Menu,
which is a structure defined (in "lgd.h") as follows:
.sp 1
.in +2
.nf
typedef struct lgd_Menu_s {
        char     *title;    /* menu title */
        int      nopts;     /* number of entries */
        lgd_Opt_pair *list; /* opt-pair array */
        } lgd_Menu;
typedef struct lgd_Opt_pair_s {
        char    *string;    /* option string */
        int     (*proc)();  /* option-proc   */
        } lgd_Opt_pair;
.fi
.in -2
.sp 1
The structure
.I lgd_Menu
consists of 3 members: a pointer to a string which serves as
the menu's title, an integer telling the number of options in
the menu, and a pointer to an array of 
.I lgd_Opt_pair
structures.  Each of these structures contains a string which will be
an option in the menu, and a pointer to a procedure which is to be
called when the user picks that option in the menu.  These procedures,
called "option-procs", should take no arguments and return no values.
See the sample program mentioned in the 
.B FILES
section below for an example showing how to set up this menu structure.
.PP
After the application program has called these set-up procedures,
it should call
.I lgd_main_loop
to bring the "device" into life and to begin the main user interaction
loop.  This loop consists of getting a menu choice from the user and
then calling the option-proc associated with that menu choice, over and
over again until one of the option-procs calls
.I lgd_end_loop.
When this option-proc returns, the call to
.I lgd_main_loop
returns.
.PP
The remaining LGD procedures are usually called from within the
option-procs.
.I lgd_move_abs,
.I lgd_move_rel,
.I lgd_draw_abs,
.I lgd_draw_rel
do the obvious graphics primitives.  These functions all
take a pointer to an array of 3 doubles representing a point
in the world coordinate system.
.I lgd_point
draws a point (a dot) at the most recently moved-to or drawn-to
point in the world.
.PP
.I lgd_set_color
sets the drawing color.  color must be one of the constants LGD_WHITE,
LGD_BLACK, LGD_RED, LGD_GREEN, LGD_YELLOW, LGD_BLUE, LGD_MAGENTA, or
LGD_CYAN.  See the section below on
.B COLORS
for more information about the LGD colors.
.PP
.I lgd_begin_segment
begins a new segment, which is a group of graphics commands
which can later be operated on as a unit.  Each segment is
given a unique identifying number, which is returned as \(**n.
All graphics primitives (moves, draws, points, and color
commands) must be contained in a segment.  Once a segment has
been begun, all primitive commands until the next call to
.I lgd_end_segment
become a part of that segment.
.PP
.I lgd_update_display
makes sure that the graphics screen accurately
displays the entire current picture.  Since many graphics devices
buffer commands in the interest of efficiency, the application
program should call
.I lgd_update_display
any time it wants the picture which the user sees to reflect changes.
A typical sequence of calls in an application program is
.sp1
.in +2
.nf
int n;

lgd_begin_segment( &n );
/* make a series move, draw, and color calls */
lgd_end_segment();
lgd_update_display();
.sp1
.in -2
.fi
.PP
.I lgd_delete_segment
deletes segment number n from the picture
completely.
.I lgd_delete_all
deletes everything from the picture.  It does not destroy your world
coordinate system, however.
.I lgd_set_segment_visibility 
can be used to turn the visibility of segment 
.I n
off
.I (v=0)
or on
.I (v=1).
.PP
.I lgd_set_view
can be used to force a particular viewing transformation to be used.
In most situations, you should not use this, because the user has
interactive control over the viewing transformation.  There are times,
however, when it is useful to be able to have the application program
explicity set it.  This is done with a call to
.I lgd_set_view,
where
.I view
is a pointer to an object of type
.I lgd_View3.
This type is a structure, defined (in "lgd.h") as
.sp1
.in+2
.nf
typedef struct lgd_View3_s {
  double eye[3];
  double focus[3];
  double up[3];
  double u1,u2,v1,v2,h1,h2;
} lgd_View3;
.fi
.in-2
.sp1
The members of this structure define a central perspective projection
with "eye" as the center of projection, "focus" is a point on the
plane of the projection (this plane is called the view plane and is
normal to the line containing the eye and the focus), and u1,u2,v1,v2
define a rectangular subset (u=horizontal, v=vertical) of the view
plane which is mapped linearly onto the graphics screen.  This
rectangular region is called the view plane window, and its
orientation is determined by the "up" vector.  The orientation is
always so that the projection of the "up" vector onto the view plane
will appear vertical.  The up vector must not lie on the line through
the eye and the focus.  h1 and h2 specify a near and far depth setting,
which on some devices is used for depth clipping and or depth cueing.
.PP
.I lgd_get_default_view
can be used to obtain a standard viewing transformation based on the
world coordinate specifications.  This is the default view which the
user sees before interactively changing the transformation.
.PP
.I lgd_save_world
and
.I lgd_load_world
can be used to write a picture to a disk file and load it back
in later.  Calling
.I lgd_load_world
causes all current data (including the world coordinate system) to be
lost and replaced with what it read from the file.  The exact state of
the graphics device (including the viewing transformation which was in
effect) at the time the file was written is restored.  Files written
by
.I lgd_save_world
contain unformatted binary data and may not be moved from one type of
machine to another (although they may be moved among different
machines of the same type, such as Suns).
.PP
.I lgd_get_string
and
.I lgd_put_string
display and get one-line messages to/from the user without interfering
with the graphics display.
.I lgd_confirm
displays a short prompt and gets a yes/no response from the user.
It returns the value of this response (0 means no, 1 means yes).
Since some graphics devices use
stdin/stdout for graphics commands, or use the same screen for
graphics and text, doing direct user I/O with stdin/stdout can be
risky.  It is therefore better to use
.I "lgd_get_string, lgd_put_string,"
and
.I lgd_user_confirm
for all user I/O.

.I lgd_get_point
gets a coordinate triple in the world coordinate system from the user.
Eventually this procedure may rely on some form of 3D input to get a
point from the user; the present version, however, simply asks the use
to type in the point's coordinates.

.I lgd_pick_segment
allows the user to pick a segment from the picture interactively
(usually by pointing at it in some way).  It sets
.I s
to point to an array of integers which are the segment numbers of all
segments within the current pick tolerance of the point picked by the
user.  This calculation is done in screen coordinates, which always
go from (0,0) to (1,1).
.I *n
is set to the lenth of this array.  The space to which *s points is
allocated dynamically.  LGD keeps track of this location, and on the
next call to 
.I lgd_pick_segment
this array is freed before the new array is allocated.  This means
that the array returned by a call to
.I lgd_pick_segment 
is valid only until the next call.  If the user picks no segments, *s
is set to NULL and *n to 0.
.I lgd_set_pick_tolerance
sets the pick tolerance to
.I t,
measured in screen coordinates.  The default tolerance is 0.01.
.PP
The
.I lgd_inquire_
functions all return information about the current state
of the graphics device.  They are all self-explanatory, with the
possible exception of the following:
.I lgd_inquire_menu
sets *menu to point to the actual place in memory where the current
menu is stored, whereas
.I lgd_inquire_view
writes the current viewing transformation into the structure
pointed to by view.  This is always the current viewing
transformation, regardless of whether it has been set by the
user interactively, or by the program via
.I lgd_set_view.

.I lgd_signal
and
.I lgd_set_input_func
set traps for Unix signals, and should be used instead of the Unix
.I signal(3)
procedure.  In both of these,
.I func
is a pointer to a function which will be called when a certain signal
is received.
.I lgd_set_input_func
specifies that the function is to be called when input is available to
be read from file descriptor
.I fd;
.I lgd_signal
specifies that the function is to be called when signal
.I sig
is received.  See
.I signal(3)
for a list of valid signals.

.SH ERROR HANDLING
There is an external varable named
.I lgd_error
of type
.B char \(**
which during normal operation has the value NULL.  When LGD
detects an error of any kind, it sets
.I lgd_error
to point to an ascii character string which briefly describes
the error.  It is the responsibility of the application program
to test the value of this variable to determine if an error has
occurred; LGD never prints out any error messages on its own.
.I lgd_error
is 
.I not
reset to null on successful calls to LGD procedures; this is
also the resposibility of the application program.
.SH RESERVED NAMESPACES
The LGD library procedures use certain prefixes for all external
symbols; application programs should avoid using names with following
prefixes in either lower, upper, or mixed case: lgd_, mf_, dpu_.

In addition, LGD uses the GR graphics package, which reserves the
prefixes gr_ and GR_.  GR in turn uses the SunView library, whose
reserved prefixes are listed at the end of chapter 3 of the SunView
Programmer's Guide.  At the time of this writing these are: attr_,
canvas_, cursor_, defaults_, ei_, es_, ev_, event_, frame_, icon_,
menu_, notify_, panel_, pixrect_, pixwin_, pr_, pw_, rect_, rl_,
scrollbar_, scroll_, seln_, textsw_, text_, toolsw_, tool_, ttysw_,
tty_, window_, win_, and wmgr_.

.SH COLORS
NOTE: I have not yet implemented color in the SunView device driver.
LGD still thinks all Suns have monochrome monitors, because until very
recently, this was true of all the Suns I use.

LGD colors are defined to guarantee that
.I LGD_WHITE
is always visible, and
.I LGD_BLACK
is always invisible.  On graphics devices for which the background
color is white,
.I LGD_WHITE
actually shows up black on the screen, while
.I LGD_BLACK
shows up white.

On monochrome devices, all colors other than
.I LGD_BLACK
will show up the same as
.I LGD_WHITE.
Color information is retained in the metafile, however, so that if a
metafile created with color commands on a monochrome device is
displayed on one for which color is supported, the color will show up.

.SH "LGD ENVIRONMENT VARIABLES"
Upon startup, 
.I lgd
programs check to see if the following environment variables have been
defined:
.sp
.in +2
.I LGD_LIB
.br
.I GR_LIB
.br
.I GR_SPOOL
.in -2
.sp
You can alter some things about the way 
.I lgd
programs works by setting these variables.

First of all, 
.I lgd
programs need access to certain files they are run.  If the copy of
.I lgd
which you are using was compiled on your computer, then the location
of these files should have been specified when the
.I lgd
library was compiled, and you don't need to worry about them.  If you
are running a copy that was compiled elsewhere, however, you will need
to make sure you also have copies of these files, and you tell
.I lgd
their location through environment variables.  If any of the
environment variables mentioned below has a value,
.I lgd
takes that value to be the name of a directory, and looks for the
associated file or files in that directory before looking for them in
the "hardwired" locations.

.in +4
.ti -2
sunview.help: 
.I Lgd
programs look for this file in the directory specified by the
environment variable LGD_LIB.
.ti -2
gr_header.ps, gr_trailer.ps: 
.I Lgd
programs look for these files in the directory specified by the
environment variable GR_LIB.
.in -4

Secondly, when printing out PostScript files, 
.I lgd
checks to see if the environment variable GR_SPOOL has a value.  If it
does, the program takes that value to be a command (consisting of one
or more words separated by whitespace) which will send a PostScript
file to a printer.  The command should take one argument, which is the
name of the PostScript file to be printed.

.SH DEFAULTS DATABASE
.I Lgd
programs read certain parameter values from the SunView defaults
database each time they are started.  You can specify your own
customized values for these parameters in the .defaults file in your
home directory.

Depending on how 
.I lgd
is installed on your system, you may be able to use defaultsedit(1) to
specify these values.  If the category \'LGD\' is present in the
\'Category\' cycle in defaultsedit, you can use it to customize
.I lgd
parameters.

If the \'LGD\' category is not present when you run defaultsedit, you
can customize 
.I lgd
parameters by entering them in the \.defaults file in your home
directory.  For each parameter that you want to customize, simply
include a line in your .defaults file containing the name of the the
parameter followed by its value.  The parameters which you can
customize are:

.in +4
.ti -2
/LGD/RotationAngle		
.br
The initial value (0 - 360 degrees) for the \'Rotation Angle\' slider.
Default: 12.

.ti -2
/LGD/ZoomFactor		
.br
Initial value for Zoom Factor slider.  Must be one of 1.0, 1.1, 1.2,
1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, or 2.0.  Default: 1.5

.ti -2
/LGD/PerspectiveFactor	
.br
Initial value for Perspective Factor slider.  Must be one of 1.0, 1.1, 1.2,
1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, or 2.0.  Default: 1.5

.ti -2
/LGD/DrawingMode		
.br
Initial value for Drawing Mode cycle.  Must be either \'Batch\' or
\'Continuous\'.  Default: Batch.

.ti -2
/LGD/PanFactor		
.br
Factor by which rotation angle is multiplied in computing pan angle.
Can be any real number.  Default: 0.1.

.ti -2
/LGD/PointList
.br
List of pixels to draw when plotting points.  This should be a list of
pairs of integers, where each pair represents the location of a pixel
relative to the point to be plotted.  For example, 0,0 represents the
pixel at the point itself, 1,0 represents the next pixel to the right,
etc.  The integers in the list must be separated from each other by
spaces and/or commas.  The entire list, including the spaces and
commas, must be no more than 80 characters long.  Default: 0,0, 1,0,
-1,0, 0,1, 0,-1.

.in -4

.SH FILES
.in +2
.ti -2
LIBDIR_VALUE/liblgd.a: LGD library file
.ti -2
INCLDIR_VALUE/lgd.h: application program header file
.ti -2
SAMPLEDIR_VALUE/lgddemo.c: example application program
.ti -2
AUXDIR_VALUE/lgdsunview.hlp: file which is displayed when the user
presses the "Help" button

.in -2
.SH BUGS AND CAVEATS
LGD also does no checking to make sure that the viewing transformation
is reasonable, and it does not clip out vectors which are "behind"
the eye point.  Bizarre pictures can result if the eye is moved close
to or beyond the viewing plane.
.SH "SEE ALSO"
.I "lgdintro(MANSECTION_VALUE)"
.br
.I "grintro(MANSECTION_VALUE), gr(MANSECTION_VALUE)"
.SH "Author"
Mark B. Phillips
.br
Department of Mathematics
.br
University of Maryland
.br
College Park, Maryland  20742
.br
mbp@lakisis.umd.edu
.sp1
Copyright (C) 1989 by Mark B. Phillips
.sp1
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Mark B. Phillips or
the University of Maryland not be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission.  This software is provided "as is" without express
or implied warranty.
