/* $Id: lgddemo.tpl,v 1.7 89/09/20 17:58:06 mbp Exp $
 *
 * lgddemo.c: sample LGD program
 *
 * BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB
 *
 * This is a "template" for the demo program lgddemo.c.  Before
 * installing and/or compiling this program, this file must be
 * edited to change the following strings to whatever is appropriate
 * for your system:
 * 
 * INCLDIR_VALUE:
 *     pathname of directory containing installed copy of lgd.h
 *
 * LIBFLAGS_VALUE:
 *     flags to pass to ld(1) to tell it where to find the libraries
 *     necessary for LGD programs.  Should include the LGD library
 *     itself as well as any required -L options and additional
 *     libraries.
 *
 * FOPTION_VALUE
 *     The floating point option for the cc command to compile this
 *       program.  This should be the same as the one used in building
 *       the LGD library.
 *
 * This can be done with a sed command, which is normally done by the
 * lgd makefile during installation, or by the explicit command
 * 'make lgddemo.c'.
 * 
 * EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
 * To compile:
 *   cc -o lgddemo lgddemo.c FOPTION_VALUE\
 *      LIBFLAGS_VALUE
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

/* All LGD programs must include lgd.h: */
#include "INCLDIR_VALUE/lgd.h"

int door_proc(), window_proc(), pick_proc();

lgd_Opt_pair menu_list[] = {
  "Turn door on/off",	door_proc,
  "Turn window on/off",	window_proc,
  "Pick segment", pick_proc
  };

lgd_Menu menu = {
  "Demo Program Menu",
  sizeof(menu_list) / sizeof(lgd_Opt_pair),
  menu_list
  };

double wbox_low[3]  = { 0.0,  0.0,  0.0 };
double wbox_high[3] = {10.0, 10.0, 10.0 };

int main_seg, door_seg, window_seg;
char *segment_name();

main()
{
  /* Initialize, define world coord system, and specify menu: */
  lgd_initialize();
  lgd_define_world( 3, wbox_low, wbox_high );
  lgd_set_menu(&menu);

  /* Construct the house: */
  build_house();

  /* Display introductory message */
  lgd_put_string("This is lgddemo.  For more information, click the \
\"Help\" button (the one with the '?' on it) ---->");

  /* Start the device: */
  lgd_main_loop();
}

build_house()
{
  double v[3];

  /* Draw the main part of the house in one segment */
  lgd_begin_segment( &main_seg );
  lgd_set_color( LGD_GREEN );
  v[0] = v[1] = v[2] = 1;
             lgd_move_abs( v );	/* floor */
  v[0] = 9;  lgd_draw_abs( v );
  v[1] = 9;  lgd_draw_abs( v );
  v[0] = 1;  lgd_draw_abs( v );
  v[1] = 1;  lgd_draw_abs( v );
  v[2] = 7;  lgd_draw_abs( v ); /* ceiling */
  v[0] = 9;  lgd_draw_abs( v );
  v[1] = 9;  lgd_draw_abs( v );
  v[0] = 1;  lgd_draw_abs( v );
  v[1] = 1;  lgd_draw_abs( v );
  v[0] = 9;  lgd_move_abs( v ); /* walls */
  v[2] = 1;  lgd_draw_abs( v );
  v[1] = 9;  lgd_move_abs( v );
  v[2] = 7;  lgd_draw_abs( v );
  v[0] = 1;  lgd_move_abs( v );
  v[2] = 1;  lgd_draw_abs( v );
  v[1] = 1;
  v[0] = 1;  v[2] = 7;  lgd_move_abs( v );
  v[0] = 5;  v[2] = 9;  lgd_draw_abs( v );
  v[0] = 9;  v[2] = 7;  lgd_draw_abs( v );
  v[1] = 9;
  v[0] = 1;  v[2] = 7;  lgd_move_abs( v );
  v[0] = 5;  v[2] = 9;  lgd_draw_abs( v );
  v[0] = 9;  v[2] = 7;  lgd_draw_abs( v );
  v[0] = 5;  v[2] = 9;  lgd_move_abs( v );
  v[1] = 1;             lgd_draw_abs( v );
  lgd_end_segment();

  /* Draw the door in a segment by itself */
  lgd_begin_segment( &door_seg );
  lgd_set_color( LGD_RED );
  v[1] = 1;
  v[2] = 1;
  v[0] = 4.5; lgd_move_abs( v );
  v[2] = 5;   lgd_draw_abs( v );
  v[0] = 5.5; lgd_draw_abs( v );
  v[2] = 1;   lgd_draw_abs( v );
  lgd_end_segment();

  /* Draw the window in a segment by itself */
  lgd_begin_segment( &window_seg );
  lgd_set_color( LGD_BLUE );
  v[0] = 9;
  v[1] = 5;
  v[2] = 3;  lgd_move_abs( v );
  v[2] = 4;  lgd_draw_abs( v );
  v[1] = 6;  lgd_draw_abs( v );
  v[2] = 3;  lgd_draw_abs( v );
  v[1] = 5;  lgd_draw_abs( v );
  lgd_end_segment();

  /* Finally, we call lgd_update_display to make sure all graphics
   * instructions have been flushed, so that the picture will appear
   * when the device is started */
  lgd_update_display();
}


door_proc()
/* Turn the door's visibility on or off */
{
  int visible;

  lgd_inquire_segment_visibility( door_seg, &visible );
  if (visible) {
    lgd_set_segment_visibility( door_seg, 0 );
    lgd_put_string("Door turned off");
  }
  else {
    lgd_set_segment_visibility( door_seg, 1 );
    lgd_put_string("Door turned on");
  }
  lgd_update_display();
}

window_proc()
/* Turn the window's visibility on or off */
{
  int visible;

  lgd_inquire_segment_visibility( window_seg, &visible );
  if (visible) {
    lgd_set_segment_visibility( window_seg, 0 );
    lgd_put_string("Window turned off");
  }
  else {
    lgd_set_segment_visibility( window_seg, 1 );
    lgd_put_string("Window turned on");
  }
  lgd_update_display();
}

pick_proc()
/* Let user pick a segment with the mouse */
{
  int *s, n, i;
  lgd_Buf buf;

  lgd_put_string("Pick a segment with the mouse");
  lgd_pick_segment( &s, &n );
  switch (n) {
  case 0:
    lgd_put_string("No segments picked");
    break;
  case 1:
    sprintf(buf, "You picked the %s segment", segment_name(s[0]));
    lgd_put_string(buf);
    break;
  case 2:
    sprintf(buf, "You picked the %s and %s segments",
	    segment_name(s[0]), segment_name(s[1]) );
    lgd_put_string(buf);
    break;
  case 3:
    sprintf(buf, "You picked the %s, %s, and %s segments",
	    segment_name(s[0]), segment_name(s[1]), segment_name(s[2]));
    lgd_put_string(buf);
    break;
  default:
    sprintf(buf, "You picked %1d segments; see command window",n);
    lgd_put_string(buf);
    for (i=0; i<n; ++i) printf("picked segment %1d\n",s[i]);
    break;
  }
}


char *segment_name(n)
int n;
{
  if (n==main_seg) return("main");
  if (n==door_seg) return("door");
  if (n==window_seg) return("window");
  return("(unknown)");
}
