//$ImageShape$
#include "ImageShape.h"

//---- Image Shape --------------------------------------------------------------

MetaImpl0(ImageShape);

ImageShape::ImageShape(Bitmap*b)
{
    bm= b;
    bbox= Rectangle(gPoint0, bm->Size());
}

ImageShape::~ImageShape()
{
    SafeDelete(bm);
}

void ImageShape::Draw(Rectangle, Point p)
{
    GrFillRect(bbox+p);
    GrPaintBitMap(bbox+p, bm, penpattern);
}

ostream& ImageShape::PrintOn(ostream& s)
{
    Shape::PrintOn(s);
    return s << bm;
}

istream& ImageShape::ReadFrom(istream& s)
{
    Shape::ReadFrom(s);
    SafeDelete(bm);
    return s >> bm;
}
