//$RegionShape,RegionSketcher$
#include "RegionShape.h"
#include "DrawView.h"

//---- RegionShape -------------------------------------------------------------

static short RegionImage[]= {
#   include  "images/RegionShape.im"
};

MetaImpl0(RegionShape);

RegionShape::RegionShape()
{
}

ShapeSketcher *RegionShape::NewSketcher(class DrawView *dv, SketchModes m)
{
    return new RegionSketcher(dv, this, m);
}

short *RegionShape::GetImage()
{
    return RegionImage;
}

GrCursor RegionShape::SketchCursor()
{
    return eCrsPen;
}

//---- RegionSketcher ----------------------------------------------------------

RegionSketcher::RegionSketcher(class DrawView *dv, Shape *sp, SketchModes)
							: (dv, sp, eSMDefault)
{
    newshape= (Shape*) proto->Clone();
    newshape->SetView(view);
    ((PolyShape*) newshape)->Open();
    view->GetShapes()->Insert(newshape);
}

void RegionSketcher::TrackFeedback(Point, Point np, bool on)
{
    if (on && lastp != np) {
	GrSetPenNormal();
	GrLine(lastp, np);
    }
}

Command *RegionSketcher::TrackMouse(TrackPhase tp, Point ap, Point pp, Point np)
{
    DrawCommand::TrackMouse(tp, ap, pp, np);
    if (((PolyShape*)newshape)->AddPt(np))
	lastp= np;
    else
	lastp= pp;
    if (tp == eTrackRelease) {
	((PolyShape*)newshape)->Close();
	view->GetShapes()->RemovePtr(newshape);
    }
    return this;
}
