//$Shape,BoxShape,OvalShape,ShapeMover,PatternCommand,PatternMenuItem$
//$ShapeView,ShapeDocument,twoshapes$

#include "ET++.h"
#include "Alert.h"
#include "TwoShapesDoc.h"

//--- Shape --------------------------------------------------------------------

class Shape: public VObject { 
    GrPattern pattern;
public:
    MetaDef(Shape);
    
    Shape(View *vp, Rectangle r) : (vp, r)
	{ pattern= ePatGrey25; }

    Metric GetMinSize()
	{ return Metric(5); }
    void Draw(Rectangle)
	{ GrSetMode(eRopCopy); GrSetPattern(pattern); }
    void SetPattern(GrPattern newpat) 
	{ pattern= newpat; ForceRedraw(); Changed(); }
    GrPattern GetPattern()
	{ return pattern; }
    ostream &PrintOn(ostream &s)
	{ VObject::PrintOn(s);
	  return s << contentRect SP << pattern SP; }
    istream &ReadFrom(istream &s)
	{ VObject::ReadFrom(s);
	  return s >> contentRect >> Enum(pattern); }
};

MetaImpl(Shape, I_I(pattern));

//---- BoxShape --------------------------------------------------------

class BoxShape: public Shape {
public:
    MetaDef(BoxShape);
    BoxShape(View *vp, Rectangle r) : (vp, r)
	{ }
    void Draw(Rectangle r)
	{ Shape::Draw(r); GrFillRect(contentRect); }
};

MetaImpl0(BoxShape);

//---- OvalShape --------------------------------------------------------

class OvalShape: public Shape {
public:
    MetaDef(OvalShape);
    OvalShape(View *vp, Rectangle r) : (vp, r)
	{ }
    void Draw(Rectangle r)
	{ Shape::Draw(r); GrFillOval(contentRect); }
};

MetaImpl0(OvalShape);

//---- PatternCommand --------------------------------------------------------

class PatternCommand: public Command {
    Shape *shape;
    GrPattern oldPattern, newPattern;
public:
    PatternCommand(Shape *s, GrPattern newpat) : (101, "set pattern")
	{ shape= s; newPattern= newpat; oldPattern= shape->GetPattern(); }
    void DoIt()
	{ shape->SetPattern(newPattern); }
    void UndoIt()
	{ shape->SetPattern(oldPattern); }
};

//---- PatternMenuItem ---------------------------------------------------------

class PatternMenuItem : public VObject {
    GrPattern pat;
public:
    MetaDef(PatternMenuItem);
    PatternMenuItem(int id, GrPattern p) : (id)
	{ pat= p; SetExtent(Point(30, 20)); }
    void Draw(Rectangle)
	{ GrPaintRect(contentRect.Inset(2), pat); }
    void Highlight(HighlightState)
	{ GrSetPenSize(3); GrStrokeRect(contentRect.Expand(1)); }
};

MetaImpl(PatternMenuItem, I_I(pat));

//---- ShapeView ---------------------------------------------------------------

const int cSETPATTERN= 100;

class ShapeView: public View {
    Shape *shape1, *shape2;
public:
    MetaDef(ShapeView);
    
    ShapeView(Document *d, Point ext);
    ~ShapeView();

    void Draw(Rectangle r)
	{ shape1->Draw(r); shape2->Draw(r); }
    Command *DoLeftButtonDownCommand(Point, Token, int);
    Command *DoMenuCommand(int);
    void DoCreateMenu(Menu*);
    void DoSetupMenu(Menu*);
    ostream &PrintOn(ostream &s)
	{ return s << shape1 << shape2; }
    istream &ReadFrom(istream &);
};

MetaImpl(ShapeView, (I_O(shape1), I_O(shape2)));

ShapeView::ShapeView(Document *d, Point ext) : (d, ext)
{
    shape1= new BoxShape(this, Rectangle(100,100,100,100));
    shape2= new OvalShape(this, Rectangle(150,150,100,100));
}
    
ShapeView::~ShapeView()
{   
    SafeDelete(shape1);
    SafeDelete(shape2);
}

Command *ShapeView::DoLeftButtonDownCommand(Point p, Token t, int)
{
    Shape *s= 0;
    
    if (shape2->ContainsPoint(p))
	s= shape2;
    else if (shape1->ContainsPoint(p))
	s= shape1;
    if (s) {
	if (t.Flags & eFlgCntlKey)
	    return s->GetStretcher();
	return s->GetMover();
    }
    return gNoChanges;
}

istream &ShapeView::ReadFrom(istream &s)
{
    SafeDelete(shape1);
    SafeDelete(shape2);
    s >> shape1 >> shape2;
    shape1->SetView(this);
    shape2->SetView(this);
    ForceRedraw();
    return s;
}

Command *ShapeView::DoMenuCommand(int cmd)
{
    if (cmd >= cSETPATTERN+ePatBlack && cmd <= cSETPATTERN+ePatGrey12)
	return new PatternCommand(shape1, cmd-cSETPATTERN);
    return View::DoMenuCommand(cmd);
}

void ShapeView::DoCreateMenu(Menu *menu)
{
    View::DoCreateMenu(menu);
    menu->Append(new MenuLineItem);
    for (GrPattern p= ePatBlack; p <= ePatGrey12; p++)
	menu->Append(new PatternMenuItem(cSETPATTERN+p, p));
}

void ShapeView::DoSetupMenu(Menu *menu)
{
    View::DoSetupMenu(menu);
    for (GrPattern p= ePatBlack; p <= ePatGrey12; p++)
	menu->EnableItem(cSETPATTERN+p);
}

//---- ShapeDocument ----------------------------------------------------------

MetaImpl(ShapeDocument, (I_O(view)));

char *cDocTypeShapes    = "TWOSHAPES";

ShapeDocument::ShapeDocument(): (cDocTypeShapes)
{
}

void ShapeDocument::DoWrite(ostream &s, int o)
{ 
    Document::DoWrite(s, o);
    view->PrintOn(s); 
}
    
void ShapeDocument::DoRead(istream &s, class FileType *ft)
{ 
    Document::DoRead(s, ft);
    view->ReadFrom(s); 
}

Window *ShapeDocument::DoMakeWindows()
{
    view= new ShapeView(this, Point(600));
    return new Window(this, Point(400), eWinDefault, new Splitter(view));
}
