#ifndef Application_First
#define Application_First

#include "Dialog.h"

class Document;
extern char *cDocTypeUndef;

class Application: public EvtHandler {
    static class FileDialog *fileDialog;

    char *version, *label, **argv, *opts, *mainDocumentType;
    int argc;
    class ObjList *documents;
    class Menu *menu;
    class Dialog *applDialog;
    class ClipBoard *clipboard;
    Point lastDocPos;
    bool printHierarchy;
    
    //---- globals
    bool gBatch;
    bool gDebug;
    bool gAbort;
    class BlankWin *gWindow;
    Rectangle gScreenRect; 
    char **gEnviron;
    
public:
    MetaDef(Application);
    Application(int ac, char** av, char *mainDocType= cDocTypeUndef, char *opts= 0);
    ~Application();

    //---- dialogs
    virtual FileDialog *MakeFileDialog();

    //---- application attributes
    char *GetName()
	{ return label; }
    char *GetMainDocumentType()
	{ return mainDocumentType; }
    EvtHandler *GetNextHandler();

    //---- Command line arguments -------------------
    virtual void DoParseOptions(int, char *, int);
    void ParseCommandLine(int, char**, char*);
    char *ProgramName();

    //---- Document related methods -----------------
    virtual Point GetNewDocumentPos();
    virtual void AddDocument(Document *);
    void RemoveDocument(Document *);
    virtual bool CloseAllDocuments();
	// return TRUE on success
    virtual void OpenDocument(char *);
    virtual Document *DoMakeDocuments(char *type);
    void NewDocument(char *type);
    virtual bool CanOpenDocument(class FileType *);
    Document *FindDocument(int id);

    //---- generic application commands
    virtual void About();
    virtual void Quit();
    virtual void Debug(int level);
	// 0 < level < 10
    virtual void Open();
    virtual void DoOnError(int level, char *location, char *msg);

    //---- menu related methods
    class Menu *GetMenu();
    Command *DoMenuCommand(int);
    virtual class VObject *DoCreateDialog();
    virtual void ShowApplicationWindow();

    //---- event handling
    void Control(int, int, void*);

    //---- run the Application
    virtual void Run();

    //---- dynamic loading
    virtual int DynLoad(char *name);
    virtual int DynLoadHook(Object*);
    
    //---- inspector
    void InspectorId(char *buf, int sz);
    void UpdateGlobals();
};

extern bool         gBatch;
extern Application *gApplication;
extern ClipBoard   *gClipBoard;
extern char        *gProgname;

//---- Application Dialog -----------------------------------------------

class ApplDialog : public Dialog {
    Application *appl;
public:
    MetaDef(ApplDialog);
    ApplDialog(Application *eh, char *title= 0);
    void Control(int id, int part, void *vp);
    VObject *DoCreateDialog();
    Point GetInitialPos();
};

#endif Application_First

