//$BitSet,BitSetIter$
#include "BitSet.h"

MetaImpl(BitSet, I_I(m));

ObjPtr BitSet::DeepClone()
{
    return Clone();
}

int BitSet::Capacity()     
{ 
    return sizeof(int)*8; 
}

int BitSet::Hash() 
{   
    return m; 
}
	
bool BitSet::IsEmpty()  
{ 
    return m==0; 
}
	
bool BitSet::IsEqual(Object* ob)
{
    return ob->IsKindOf(BitSet) && m == ((BitSet*)ob)->m;
}

ostream& BitSet::PrintOn (ostream& s)
{
    Object::PrintOn(s);
    return s << m SP;  
}

istream& BitSet::ReadFrom (istream& s)
{
    Object::ReadFrom(s);
    return s >> m;
}

int BitSet::Size()
{
    register unsigned l, n;

    for (l= m, n= 0; l != 0; n++)
	l &= (l-1);     // removes rightmost 1 
    return n;
}

//---- class BitSetIter ----------------------------------------------------

void BitSetIter::Reset(BitSet *s)
{
    cb= s;
    pos= 0;
}
	
int BitSetIter::operator()()
{
    while (!cb->Includes(pos) && pos < cb->Capacity())
	pos++;
    if (pos == cb->Capacity())
	return 0;
    return pos++;
}


