//$Bitmap$
#include "Bitmap.h"
#include "Types.h"
#include "Error.h"
#include "Storage.h"
#include "WindowSystem.h"
#include "String.h"

static void encode(ostream &ofp, byte *buf, int l, int *col);
static void decode(istream &in, byte *buf, int l);

static char *cNoStaticBitmaps= "no static instances";

Bitmap::Bitmap()
{
}

Bitmap::Bitmap(Point sz, short *im)
{
    if (this == 0)
	gWindowSystem->MakeBitmap(&this, sz, im);
    else {
	Fatal("Bitmap::Bitmap", cNoStaticBitmaps);
	this= 0;    // can't reach
    }
}

Bitmap::Bitmap(const char *name)
{
    if (this == 0)
	gWindowSystem->MakeBitmap(&this, name);
    else {
	Fatal("Bitmap::Bitmap", cNoStaticBitmaps);
	this= 0;    // can't reach
    }
}

Bitmap::~Bitmap()
{
}

void Bitmap::GetLine(byte *bbp, int y, int bytes)
{
    register byte *bp= (byte*) GetImage();
    register int i, x, lb= ShortsPerLine()*2;
    int h= size.y, realbytes= BytesPerLine();
    
    for (x= 0, i= y*lb; x < bytes; x++) {
	if (x < realbytes && y >= 0 && y < h)
	    *bbp++= bp[i++];
	else
	    *bbp++= 0;
    }
}

void Bitmap::Init(Point, short*)
{
    AbstractMethod("Bitmap::Init");
}

ostream &Bitmap::StoreOn(ostream &s)
{
    register byte *bp= (byte*) GetImage();
    register int i, l= Bytes();
    int col= 0;
    
    s << size SP;
    if (l > 32) {
	s << "1\n";
	encode(s, bp, l, &col);
    } else {
	s << "0\n";
	for (i= 0; i < l; i++)
	    PutHex(s, *bp++, &col);
    }
    if (col > 0)
	s NL;
    return s;
}

istream& operator>> (istream &s, BitmapPtr &bmp)
{
    register int l, i;
    register byte *im;
    int d;
    Point sz;
    
    s >> sz >> d;
    l= ((sz.x-1)/16+1) * sz.y * 2;
    im= NewBytes(l);
    if (d)
	decode(s, im, l);
    else
	for (i= 0; i < l; i++)
	    im[i]= GetHex(s);
    
    gWindowSystem->MakeBitmap(&bmp, sz, (short*)im);
    return s;
}

//---- private stuff -----------------------------------------------------------

static void encode(ostream &ofp, byte *buf, int l, int *col)
{
    register int i, j, k, b;
    int start;

    for (i=0; i<l;) {
	b= buf[i];
	for (i++, j=1; i<l; i++, j++)
	    if (b != buf[i])
		break;
	if (j>1) {
	    while (j>128) {
		PutHex(ofp, 128-1, col);
		PutHex(ofp, b, col);
		j-= 128;
	    }
	    PutHex(ofp, j-1, col);
	    PutHex(ofp, b, col);
	} else 
	    i--;

	if (i>= l)
	    break;

	start= i;
	for (i++, j=1; i<l; i++, j++)
	    if (buf[i-1] == buf[i])
		break;
	if (i<l) {
	    i--;
	    j--;
	}
	if (j>0) {
	    while (j>128) {
		PutHex(ofp, 128+127, col);
		for (k= 0; k<128; k++, start++)
		    PutHex(ofp, buf[start], col);
		j-= 128;
	    }
	    PutHex(ofp, j+127, col);
	    for (; j>0; j--, start++)
		PutHex(ofp, buf[start], col);
	}
    }
}

static void decode(istream &in, byte *buf, int l)
{
    register int count, value, i, j;

    for (i=0; i<l;) {
	count= GetHex(in);
	if (count >= 128) {
	    count-= 127;
	    for (j= 0; j < count; j++)
		buf[i++]= GetHex(in);
	} else {
	    count++;
	    value= GetHex(in);
	    for (j= 0; j < count; j++)
		buf[i++]= value;
	}
    }
}
