//$BlankWin,BlankWindowStretcher$
#include "BlankWin.h"
#include "Error.h"
#include "WindowPort.h"
#include "WindowSystem.h"
#include "Menu.h"
#include "ObjectTable.h"

Token gToken;
BlankWin *gWindow;
bool gInUpdate;

static char *cNoPortMsg= "no port";

MetaImpl(BlankWin, I_O(nexthandler));

BlankWin::BlankWin(Point extent, BWinFlags f) : (0, extent)
{
    ResetFlag(eVObjOpen);
    SetFlag(f);
}

BlankWin::BlankWin(VObject *vp, Point extent, BWinFlags f) : (vp, extent)
{
    ResetFlag(eVObjOpen);
    SetFlag(f);
}

BlankWin::BlankWin(EvtHandler *eh, VObject *vp, Point extent, BWinFlags f) : (vp, extent)
{
    nexthandler= eh;
    ResetFlag(eVObjOpen);
    SetFlag(f);
}

BlankWin::~BlankWin()
{
    if (vop) {
	vop->FreeAll();
	SafeDelete(vop);
    }
    if (portDesc) {
	portDesc->Destroy();    // mark as free
	portDesc= 0;
    }
}

VObject *BlankWin::GetContainer()
{
    return container;
}

EvtHandler *BlankWin::GetNextHandler()
{
    return nexthandler;
}

void BlankWin::InvalidateRect(Rectangle r)
{
    if (portDesc)
	portDesc->InvalidateRect(r);
}

void BlankWin::SetExtent(Point e)
{
    VObject::SetExtent(e);
}

void BlankWin::SetOrigin(Point at)
{
    VObject::SetOrigin(gPoint0);
    if (portDesc) {
	Rectangle r(GetRect().origin+at, contentRect.extent);
	portDesc->SetRect(&r);
    }
}

void BlankWin::SetFocus(Rectangle r, Point o)
{
    if (IsOpen() && portDesc) {
	GrSetPort(portDesc);
	GrSetClip(Inter(contentRect, r), o);
    }
}

void BlankWin::UpdateEvent(bool batch)
{
    Rectangle r, *rp;
    register int i, n;
    
    if (portDesc == 0)
	return;
    gInUpdate= TRUE;
    if ((n= portDesc->inval) > 0) {
	rp= portDesc->invalRects;
	SetFocus(portDesc->invalBounds, 0);
	GrSetPenNormal();
	GrSetMode(eRopCopy);
	GrSetPattern(ePatBlack);
	if (batch) {
	    for (i= n-1; i >= 0; i--) {
		GrGiveHint(eHintBatch, sizeof(Rectangle), &rp[i]);
		DrawAll(rp[i]);
		GrGiveHint(eHintUnbatch);
	    }
	} else {
	    GrGiveHint(eHintLock, sizeof(Rectangle), &portDesc->invalBounds);
	    for (i= n-1; i >= 0; i--)
		DrawAll(rp[i]);
	    GrGiveHint(eHintUnlock);
	}
	portDesc->inval= 0;
    }
    gInUpdate= FALSE;
}

void BlankWin::DrawAll(Rectangle r)
{
    GrGiveHint(eHintTextBatch);
    VObject::DrawAll(r);
    GrGiveHint(eHintTextUnbatch);
}

void BlankWin::DrawBackground(Rectangle r)
{
    GrEraseRect(r);
}

void BlankWin::DrawForeground(Rectangle)
{
    extern bool gPrinting;
    
    if (!TestFlag(eBWinOverlay) && !gPrinting) {
	GrSetPenNormal();
	GrSetPenPattern(TestFlag(eBWinActive) ? ePatBlack : ePatGrey50);
	GrStrokeRect(contentRect);
    }
}

void BlankWin::Update()
{
    SetContainer(0);
    SetView((View*) this);
    vop->CalcExtent();
    vop->SetOrigin(gPoint0);
}

void BlankWin::input(void*, Token *t)
{
    if (! TestFlag(eBWinOverlay))
	gWindow= this;
    if (portDesc == 0)
	return;
    GrSetPort(portDesc);
    
    if (t->Code == eEvtDamage) {
	if (t->Flags == eFlgDamage1 || t->Flags == eFlgDamage5) {
	    if (! IsOpen())
		Clipper::Open(TRUE);
	    if (vop) {
		vop->SetExtent(t->ext);
		vop->SetOrigin(gPoint0);
	    }
	    if (t->Flags == eFlgDamage1) {
		portDesc->inval= 0;
		return;
	    }
	}
    } else {
	gToken= *t;
	
	if (t->IsKey() && t->Flags == (eFlgShiftKey|eFlgCntlKey|eFlgMetaKey)) {
	    switch (t->MapToAscii()) {
	    case 'q':           // emergency exit
		Close();
		return;
	    case 't':
		abort();
		return;
	    case 'p':
		Print();
		return;
	    case 'v':
		ObjectTableVisitObjects();
		return;
	    case 's':
		ClassInstanceStatistics();
		return;
	    case 'e':
		Error("input", "forced invocation of ErrorHandler");
		return;
	    case 'w':
		SetIgnoreLevel(0);
		return;
	    }
	}
	PerformCommand(DispatchEvents(gToken.Pos, gToken, this));
    }
    UpdateEvent();
}

Token BlankWin::ReadEvent(int timeout, bool overread)
{
    if (portDesc)
	portDesc->GetEvent(&gToken, timeout, overread);
    else
	Error("ReadEvent", cNoPortMsg);
    return gToken;
}

void BlankWin::MakePort()
{
    if (portDesc == 0)
	portDesc= new WindowPort((InpHandlerFun) &BlankWin::input, this, 0,
				TestFlag(eBWinOverlay), TestFlag(eBWinBlock));
}

void BlankWin::Open(bool mode)
{
    if (mode)
	OpenAt(GetRect().origin);
    else {
	Clipper::Open(FALSE);
	if (portDesc)
	    portDesc->Hide();
    }
}

void BlankWin::OpenAt(Point p, VObject *fp)
{
    WindowPort *fatherport= 0;
    
    MakePort();
    
    if (IsOpen()) {
	Top();
	return;
    }
    if (fp) {
	fatherport= (WindowPort*) (fp->GetWindow()->portDesc);    
	p= fp->GetPortPoint(p);
    }
	
    GrSetPort(portDesc);
    
    if (vop) {
	vop->SetView((View*)this);
	vop->SetContainer(this);
    }
    contentRect.extent= Max(GetMinSize().Extent(), contentRect.extent);
    portDesc->Show(fatherport, Rectangle(p, contentRect.extent));
    
    GrSetPort(fatherport);
}

Command *BlankWin::DoLeftButtonDownCommand(Point, Token, int)
{
    Top();
    return gNoChanges;
}

Command *BlankWin::DoMiddleButtonDownCommand(Point, Token t, int)
{
    if (t.Flags & eFlgCntlKey)
	return GetStretcher();
    return GetMover();
}

void BlankWin::ActivateWindow(bool mode)
{
    Focus();
    SetFlag(eBWinActive, mode);
    DrawForeground(gRect0);
}

Command *BlankWin::DispatchEvents(Point lp, Token t, Clipper *vf)
{
    if (! TestFlag(eBWinOverlay)) {
	if (t.Code == eEvtExit)
	    ActivateWindow(FALSE);
	else if (t.Code == eEvtEnter)
	    ActivateWindow(TRUE);
    }
    return Clipper::DispatchEvents(lp, t, vf);
}

Rectangle BlankWin::ScreenRect()
{
    return gScreenRect - GetRect().origin;
}

Rectangle BlankWin::GetRect()
{
    MakePort();
    return portDesc->GetRect();
}

Command *BlankWin::GetMover()
{
    Command *wm= new VObjectMover(this, ScreenRect(), gPoint1);
    wm->SetFlag(eCmdFullScreen);
    wm->ResetFlag(eCmdCanUndo);
    return wm;
}

Command *BlankWin::GetStretcher()
{
    if (TestFlag(eBWinFixed))
	return gNoChanges;
    return new BlankWindowStretcher(this, ScreenRect());
}

void BlankWin::PushBackEvent(Token t)
{
    MakePort();
    portDesc->PushEvent(t);
}

void BlankWin::Top()
{
    if (portDesc)
	portDesc->Top();
    else
	Error("Top", cNoPortMsg);
}

void BlankWin::Bottom()
{
    if (portDesc)
	portDesc->Bottom();
    else
	Error("Bottom", cNoPortMsg);
}

void BlankWin::Bell(long d)
{
    if (portDesc)
	portDesc->Bell(d);
    else
	Error("Bell", cNoPortMsg);
}

void BlankWin::SetMousePos(Point p)
{
    if (portDesc)
	portDesc->SetMousePos(p);
    else
	Error("SetMousePos", cNoPortMsg);
}

void BlankWin::Fullscreen(bool m)
{
    if (portDesc)
	portDesc->Fullscreen(m);
    else
	Error("Fullscreen", cNoPortMsg);
}

void BlankWin::Grab(bool m)
{
    if (portDesc)
	portDesc->Grab(m);
    else
	Error("Grab", cNoPortMsg);
}

void BlankWin::ScrollRect(Rectangle r, Point delta)
{
    if (portDesc)
	portDesc->ScrollRect(r, delta);
    else
	Error("ScrollRect", cNoPortMsg);
}

class Menu *BlankWin::GetMenu()
{
    return 0;
}

void BlankWin::DoCreateMenu(Menu *mp)
{
    mp->AppendItems(
	"collapse", cCOLLAPSE,
	"top",      cTOP,
	"bottom",   cBOTTOM,
	"redisplay    ",cREDISPLAY,
	0
    );
}

void BlankWin::DoSetupMenu(Menu *mp)
{
    if (TestFlag(eBWinBlock)) {
	mp->EnableItem(cREDISPLAY);
	return;
    }
    mp->EnableItems(cTOP, cREDISPLAY, cBOTTOM, cCOLLAPSE, 0);
}

Command *BlankWin::DoMenuCommand(int cmd)
{
    switch (cmd) {
    case cTOP:
	Top();
	break;
	
    case cBOTTOM:
	Bottom();
	break;
	
    case cREDISPLAY:
	ForceRedraw();
	break;
	
    default:
	return Clipper::DoMenuCommand(cmd);
    }
    return gNoChanges;
}

//---- BlankWindowStretcher ---------------------------------------------------------

BlankWindowStretcher::BlankWindowStretcher(BlankWin *w, Rectangle r) : (w, r)
{ 
    SetFlag(eCmdFullScreen);
    ResetFlag(eCmdCanUndo);
    ddd= 0;
}

void BlankWindowStretcher::TrackConstrain(Point ap, Point pp, Point *np)
{
    *np-= ddd;
    VObjectStretcher::TrackConstrain(ap, pp, np);
}

Command *BlankWindowStretcher::TrackMouse(TrackPhase atp, Point ap, Point pp, Point np)
{
    if (atp == eTrackPress) {
	VObjectStretcher::TrackMouse(atp, ap, pp, np);
	corner= Rectangle(oldRect.extent).PointToCorner(ap);
	Point ppp= Rectangle(oldRect.extent).CornerToPoint(corner);
	((BlankWin*)vop)->SetMousePos(ppp);
	// caution: because of SetMouse all following coordinates
	//          are translated by ddd
	ddd= ppp - ap;
	return this;
    }
    return VObjectStretcher::TrackMouse(atp, ap, pp, np);
}
