//$Class, AccessMembers$
#include "Class.h"
#include "Error.h"
#include "Storage.h"
#include "String.h"
#include "ObjArray.h"
#include "OrdCollection.h"
#include "Set.h"
#include "ObjectTable.h"

Class *classptr;
class ObjArray *classTable;
static int nClasses= 0;

static int classStatus= 0;
static AccessMembers *accessMembers= 0;

MetaImpl(Class, (I_O(super), I_CS(className), I_I(myId), I_I(size),
    I_O(instanceTable), I_O(proto), I_CS(declFileName), I_CS(declCompDir),
    I_I(declFileLine), I_CS(implFileName), I_CS(implCompDir),
    I_I(implFileLine), I_O(subclasses), I_I(instanceCount)));

Class::Class(char *name, int sz, Object *pro, char *implfn, char *declfn,
			int il, int dl, char *icd, char *dcd, bool abstract)
{
    size= sz;
    className= name;
    declFileName= declfn;
    implFileName= implfn;
    declFileLine= dl;
    implFileLine= il;
    declCompDir= dcd;
    implCompDir= icd;
    proto= pro;
    subclasses= 0;
    instanceTable= 0;
    instanceCount= 0;
    if (abstract)
	SetFlag(eClassAbstract);
    if (size) {
	if (classTable == 0) {
	    classTable= new ObjArray(200);
	    ObjectTableAddRoot(classTable);
	}
	classTable->Add(this);
	classTable->Sort();
	nClasses++;
    }
}

Class::~Class()
{
    delete (void*)proto;        // avoid call of destructor for prototype
    SafeDelete(instanceTable);
    SafeDelete(subclasses);
    if (size > 0 && --nClasses <= 0)
	SafeDelete(classTable);
}

int Class::Hash()
{
    register int hash;
    register char *p= className;

    for (hash= 0; *p; p++)
	hash= (hash << 1) ^ *p;
    return abs(hash);
}

bool Class::IsEqual(Object *op)
{
    return strcmp(className, ((Class*)op)->className) == 0;
}

int Class::Compare(Object *op)
{
    return strcmp(className, ((Class*)op)->className);
}

char* Class::AsString()
{
    return className;
}

void Class::EnumerateMembers(AccessMembers *ac)
{
    accessMembers= ac;
    if (className)
	D_C(className);
    if (proto)
	proto->Members();
    if (super)
	super->EnumerateMembers(ac);
}

bool Class::isKindOf(Class *c)
{
    register Class *cc;

    for (cc= this; cc; cc= cc->super)
	if (cc == c)
	    return TRUE;
    return FALSE;
}

Object *Class::New()
{
    if (size <= 0) {
	Error("New", "size <= 0 (%s)", className);
	return 0;
    }
    Object *op= (Object*) Malloc(size);
    ObjectTableAdd(op);
    bcopy((byte*) proto, (byte*) op, size);
    op->flags |= cObjNonDeleted; 
    op->flags &= ~cObjIsProto;  
    op->InitNew();
    return op;
}

ostream& Class::DisplayOn(ostream &s)
{
    int n= 0;

    if (proto) {    // virtual member count
	int *vt= (int*)proto->_vptr;

	for (n= 0; *vt; vt++, n++)
	    ;
    }

    s << form("%4d\t%-20s\t%-20s\t%d", size, className,
					    super ? super->className : "nil", n);
    return s;
}

void Class::Reset()
{
    if (instanceTable)
	for (int i= 0; i<instanceTable->Size(); i++)
	    (*instanceTable)[i]= 0;
}

void Class::AddSubclass(Class *cl)
{
    if (subclasses == 0)
	subclasses= new OrdCollection;
    subclasses->Add(cl);
}

Iterator *Class::SubclassIterator()
{
    if (subclasses == 0)
	subclasses= new OrdCollection;
    return subclasses->GetIterator();
}

void Class::SavePtr(ostream& o, ObjPtr p)
{
    bool newinstance;

    o.put('\n');
    o.put('{');
    o << className;
    o.put(' ');
    o.put('#');
    o << MakeIndex(p, &newinstance);
    if (newinstance) {
	o.put(' ');
	o << *p;
    }
    o.put('}');
}

void Class::InvalidatePtr(ObjPtr p)
{
    int ix;

    if (instanceTable == 0)
	return;
    if ((ix= instanceTable->ContainsPtrAt(p)) < 0) 
	return;
    (*instanceTable)[ix]= (ObjPtr) 0x01;    // hack !!
}

int Class::MakeIndex(ObjPtr p, bool *bp)
{
    int ix;
    bool isnew= FALSE;
    
    if (instanceTable == 0)
	instanceTable= new ObjArray(10);

    if ((ix= instanceTable->ContainsPtrAt(p)) < 0) {
	isnew= TRUE;
	instanceTable->Add(p);
	ix= instanceTable->ContainsPtrAt(p);
    }
    if (bp)
	*bp= isnew;
    return ix;
}

ObjPtr Class::LoadPtr(istream& is)
{
    ObjPtr p= 0;
    int ix;
    char c;

    is >> c >> ix;
    if (c != '#') {
	Error("LoadPtr", "missing \"#\" (%s)", className); 
	classStatus= 1;
	return NULL;
    }
    if (ix < 0) {
	Error("LoadPtr", "instance number out of range (%s)", ix); 
	classStatus= 2;
	return NULL;
    }

    if (instanceTable == 0)
	instanceTable= new ObjArray(ix*2);
    else if (ix >= instanceTable->Size())     // new
	instanceTable->Expand (2*instanceTable->Size());
    else
	p= instanceTable->At(ix);
    if (p == 0) {
	if ((p= New()) == 0) {
	    Error("LoadPtr", "can't make clone; New returns 0");
	    return NULL;
	}
	is >> *p;
	instanceTable->AtPut(ix, p);
    }

    is >> c;
    if (c != '}') {
	Error("LoadPtr", "missing \'}\' (%s,%d,%c)", className, ix, c);
	classStatus= 3;
	return NULL;
    }
    return p;
}

//---- friends -----------------------------------------------------------------

Class *ClassFind(char *name)
{
    Class lookFor(name, 0, 0, 0, 0, 0, 0, 0, 0);
    int at= classTable->BinarySearch(&lookFor, nClasses);
    if (at != -1)
	return (Class*) classTable->At(at);
    return 0;
}

ostream& ClassSavePtr(ostream& o, ObjPtr p)
{
    if (p == 0)
	return o << "0 ";
    if (p->IsA() == 0) {
	Error("ClassSavePtr", "Fatal Error: object has no class");
	return o;
    }
    p->IsA()->SavePtr(o, p);
    return o;
}

void ClassInvalidatePtr(ObjPtr p)
{
    if (p == 0)
	return ;
    if (p->IsA() == 0) 
	Error("ClassInvalidatePtr", "Fatal Error: object has no class");
    p->IsA()->InvalidatePtr(p);
}

static OObjMemberFunc DynLoadHook= 0;
static Object *dynLoadPrivData= 0;

void ClassSetDynLoadHook(Object *op, OObjMemberFunc of)
{
    dynLoadPrivData= op;
    DynLoadHook= of;
}

istream& ClassLoadPtr(istream& is, ObjPtr& op)
{
    char c, name[100];
    register Class *clp;    

    op= NULL;
    is >> c;
    if (c == '0')
	return is;
    if (c != '{') {
	Error("ClassLoadPtr", "missing \'{\', c=\'%c\'", c);
	classStatus= 4;
	return is;
    }
    is >> name;
    while ((clp= ClassFind(name)) == 0) {
	if ((DynLoadHook != 0) && (dynLoadPrivData != 0))
	    if ((dynLoadPrivData->*DynLoadHook)(name))
		continue;       // try again

	Error("ClassLoadPtr", "can't find class %s", name);
	classStatus= 6;
	return is;
    }
    op= clp->LoadPtr(is);
    return is;
}

int ClassReset()
{
    ObjArrayIter next(classTable);
    register Class *clp;
    int oldstatus= classStatus; 

    while (clp= (Class*) next())
	clp->Reset();
    classStatus= 0;
    return oldstatus;
}

void ClassPrintHierarchie()
{
    classTable->DisplayOn(cout);
}

void ClassSetupSubclasses()
{
    ObjArrayIter next(classTable);
    register Class *clp, *super;
    Set classes;

    while (clp= (Class*) next()) 
	if (clp->subclasses) 
	    clp->subclasses->Empty();

    next.Reset(classTable);
    while (clp= (Class*) next()) 
	if (super= clp->Super())
	    super->AddSubclass(clp);
}

void ClassInstanceStatistics()
{
    ObjArrayIter next(classTable);
    Class *clp;
    int cum= 0;
    
    cout << "Number of Instances per Class " NL;
    cout << "=============================" NL;
    ObjectTableUpdateInstCount();
    while (clp= (Class*) next()) {
	if (clp->className && clp->instanceCount > 0) {
	    cout << form("%-20s:\t%4d\n", clp->className, clp->instanceCount);
	    cum+= clp->instanceCount;
	}
    }
    cout << "-----------------------------" NL;
    cout << "Total " << cum NL;
    cout << "=============================" NL;
}
 
void Class::AddInstance()
{
    instanceCount++;
}

void Class::ResetInstanceCount()
{
    instanceCount= 0;
}

int Class::GetInstanceCount()
{
    return instanceCount;        
}

Iterator *ClassIterator(bool)
{
    return classTable->GetIterator();    
}

void Class::InspectorId(char *buf, int bufSize)
{
    if (className)
	strn0cpy(buf, className, bufSize);
    else
	Object::InspectorId(buf, bufSize);
}


//---- class AccessMembers ----------------------------------------------------

void AccessMembers::ClassName(char *)
{
}

void AccessMembers::Member(char *, short, int)
{
}

void AccessMembers::VectorMember(char *, short, short, int)
{
}

void AccessMembers::ConstVectorMember(char *, short, short, int)
{
}

//---- access functions ---------------------------------------------------

void D_A(char *n, short of, int t)
{
    if (accessMembers)
	accessMembers->Member(n, of, t);
}

void D_B(char *n, short of, short lenof, int t)
{
    if (accessMembers)
	accessMembers->VectorMember(n, of, lenof, t);
}

void D_C(char *n)
{
    if (accessMembers)
	accessMembers->ClassName(n);
}

void D_D(char *n, short of, short size, int t)
{
    if (accessMembers)
	accessMembers->ConstVectorMember(n, of, size, t);
}
