//$SunClipboardSystem,AcceptHandler,Connection$

#include "String.h"
#include "Error.h"
#include "Clipboard.h"
#include "SUNOS/SunSystem.h"
#include "SUNOS/sunsockets.h"

const int cMaxConnections= 32;

class Connection *connections[cMaxConnections];
static class Connection *clipboard;

//---- Connection --------------------------------------------------------------

class Connection : public SysEvtHandler {
    FILE *ifp, *ofp;
    
public:
    Connection(int);
    ~Connection();
    
    bool Read(void*, int);
    void Write(void *vp, int l, bool flush= TRUE);
    void Notify(SysEventCodes, int);
};

void Connection::Write(void *vp, int l, bool flush)
{
    if (ofp) {
	if (fwrite((char*)vp, 1, l, ofp) != l)
	    SysError("Write", "fwrite");
	if (flush)
	    fflush(ofp);
    }
}

Connection::Connection(int f) : (f)
{
    gSystem->AddFileInputHandler(this);
    ifp= fdopen(f, "r");
    ofp= fdopen(f, "w");
    connections[f]= this;
}

Connection::~Connection()
{
    if (ifp)
	fclose(ifp);
    if (ofp)
	fclose(ofp);
    connections[GetResourceId()]= 0;
}
    
bool Connection::Read(void *p, int l)
{
    if (fread((char*)p, l, 1, ifp) == 0) {
	Remove();
	return TRUE;
    }
    return FALSE;
}

void Connection::Notify(SysEventCodes, int)
{
    static bool cachegood= FALSE;
    static struct Response cache;
    static char *bp;
    
    struct Message m;
    struct Response rp;
    int i;
    
    if (Read(&m, sizeof(struct Message)))
	return;
	
    switch (m.tag) {
    
    case eMsgHaveClipboard:
	clipboard= this;
	
	rp.tag= eMsgNotOwner;
	for (i= 0; i < cMaxConnections; i++)
	    if (connections[i] && connections[i] != this)
		connections[i]->Write(&rp, sizeof(struct Response));
	SafeDelete(bp);
	cachegood= FALSE;
	break;
	
    case eMsgGetClipboard:
	if (clipboard) {
	
	    if (! cachegood) {
		clipboard->Write(&m, sizeof(struct Response));
		clipboard->Read(&cache, sizeof(struct Response));
		SafeDelete(bp);
		bp= NewChars(cache.len);
		clipboard->Read(bp, cache.len);
		cachegood= TRUE;
	    }
	    
	    Write(&cache, sizeof(struct Response), FALSE);
	    Write(bp, cache.len);
	}
	break;
	
    default:
	Error("Notify", "unknown message");
    }
}

//---- AcceptHandler -----------------------------------------------------------

class AcceptHandler : public SysEvtHandler {
public:
    AcceptHandler(int r) : (r)
	{ }
    void Notify(SysEventCodes, int);
};

void AcceptHandler::Notify(SysEventCodes, int)
{    
    int msgsock= accept(GetResourceId(), 0, 0);
    if (msgsock < 0) {
	SysError("Notify", "accept");
	return;
    }
    new Connection(msgsock);
}

//---- SunClipboardSystem ------------------------------------------------------

class SunClipboardSystem: public SunSystem {
public:
    SunClipboardSystem()
	{ }
    bool Init();
};

bool SunClipboardSystem::Init() 
{
    int sock= -1;
    
    if (SunSystem::Init())
	return TRUE;
    
    if ((sock= TcpService(SERVICENAME)) >= 0)
	AddFileInputHandler(new AcceptHandler(sock));
	
    if ((sock= UnixService(SERVERNAME)) >= 0)
	AddFileInputHandler(new AcceptHandler(sock));
    
    if (sock < 0) {
	Warning("SunClipboardSystem::Init", "no socket found");
	return TRUE;
    }
    
    cerr << "clipboard ready\n";
    return FALSE;
}

//---- Main --------------------------------------------------------------------

ONENTRY(Server)
{
    gSystem= new SunClipboardSystem();
    if (gSystem->Init()) {
	Warning("ONENTRY", "can't init operating system");
	_exit(1);
    }
}

ONEXIT(Server)
{
    SafeDelete(gSystem);
}

main()
{
    gSystem->Control();
}
