#ifndef DialogView_First
#define DialogView_First

#include "View.h"

//---- DialogView --------------------------------------------------------------

class DialogView: public View {
    class VObject *dialogRoot;
    class EditTextItem *activeText;
    class OrdCollection *textItems;
    class ActionButton *defaultButton;
    bool modified;
    class Menu *menu;
public:
    MetaDef(DialogView);

    DialogView(EvtHandler *eh= 0);
    ~DialogView();

    void Open(bool mode= TRUE);
    void SetOrigin(Point at);
    Metric GetMinSize();
    virtual VObject *DoCreateDialog();
    void Update();
    void CalcLayout(bool redraw= TRUE);
    VObject *SetDialog(VObject*, bool redraw= TRUE); // returns old dialogtree
    VObject *GetRoot()
	{ return dialogRoot; }
    bool IsModified()
	{ return modified; }
    void Draw(Rectangle);

    //---- event handling
    Command *DispatchEvents(Point p, Token t, Clipper*);
    void Control(int id, int, void *v);
    virtual void DoTab(Token t);

    //---- menues
    Command *DoMenuCommand(int cmd);
    Menu *GetMenu();
    bool HasSelection();

    virtual void EnableItem(int id, bool b = TRUE);
    void DisableItem(int id)
	{ EnableItem(id,FALSE); }
    void AddTextItem(EditTextItem *);
    VObject *FindItem(int id);
    EditTextItem *RemoveTextItem(EditTextItem *);
    void SetDefaultButton (ActionButton*);
    VObject* GetDefaultButton()
	{ return (VObject*) defaultButton; }
};

//---- Dialog -------------------------------------------------------------------

class Dialog: public DialogView {
protected:
    class BlankWin *dw;
    int actionId;
public:
    MetaDef(Dialog);

    Dialog(char *title, int f= 0); // BWinFlags f= eBWinDefault
    ~Dialog();

    virtual int ShowAt(VObject*, Point);
    virtual Point GetInitialPos();
    int Show();
    int ShowOnWindow(VObject *fp);
    void Control(int id, int part, void *v);
    virtual void DoSetDefaults();
    virtual void DoSave();
    virtual void DoRestore();
    virtual void DoSetup();
    BlankWin *GetWindow();
    void InspectorId(char *, int);
    void Close();
};

#endif DialogView_First

