//$EvtHandler$
#include "EvtHandler.h"
#include "Command.h"
#include "View.h"
#include "Clipper.h"

AbstractMetaImpl0(EvtHandler);

EvtHandler::EvtHandler()
{
}
    
EvtHandler *EvtHandler::GetNextHandler()
{
    AbstractMethod("GetNextHandler");
    return 0;
}

void EvtHandler::PerformCommand(Command *cmd)
{
    if (cmd == 0 || cmd == gNoChanges)
	return;
    if (GetNextHandler())
	GetNextHandler()->PerformCommand(cmd);
    else
	Perform(cmd);
}

class Menu *EvtHandler::GetMenu()
{ 
    if (GetNextHandler())
	return GetNextHandler()->GetMenu();
    return 0;
}

void EvtHandler::DoCreateMenu(class Menu *mp)
{
    if (GetNextHandler())
	GetNextHandler()->DoCreateMenu(mp);
}

void EvtHandler::DoSetupMenu(class Menu *mp)
{
    if (GetNextHandler())
	GetNextHandler()->DoSetupMenu(mp);
}

Command *EvtHandler::DoMenuCommand(int cmd)
{
    if (GetNextHandler())
	return GetNextHandler()->DoMenuCommand(cmd);
    return gNoChanges;
}

Command *EvtHandler::DoKeyCommand(int ch, Point lp, Token t)
{
    if (GetNextHandler())
	return GetNextHandler()->DoKeyCommand(ch, ContainerPoint(lp), t);
    return gNoChanges;
}

Command *EvtHandler::DoCursorKeyCommand(EvtCursorDir d, Point p, Token t)
{
    if (GetNextHandler())
	return GetNextHandler()->DoCursorKeyCommand(d, ContainerPoint(p), t);
    return gNoChanges;
}

Command *EvtHandler::DoFunctionKeyCommand(int pfk, Point lp, Token t)
{
    if (GetNextHandler())
	return GetNextHandler()->DoFunctionKeyCommand(pfk, ContainerPoint(lp), t);
    return gNoChanges;
}

Command *EvtHandler::DoRightButtonDownCommand(Point p, Token t, int clicks,
								Clipper *vf)
{
    if (GetNextHandler())
	return GetNextHandler()->DoRightButtonDownCommand(ContainerPoint(p), t,
								    clicks, vf);
    return gNoChanges;
}

Command *EvtHandler::DoMiddleButtonDownCommand(Point p, Token t, int clicks)
{
    if (GetNextHandler())
	return GetNextHandler()->DoMiddleButtonDownCommand(ContainerPoint(p), t, clicks);
    return gNoChanges;
}

Command *EvtHandler::DoLeftButtonDownCommand(Point p, Token t, int clicks)
{
    if (GetNextHandler())
	return GetNextHandler()->DoLeftButtonDownCommand(ContainerPoint(p), t, clicks);
    return gNoChanges;
}

Command *EvtHandler::DoOtherEventCommand(Point p, Token t)
{
    if (GetNextHandler())
	return GetNextHandler()->DoOtherEventCommand(ContainerPoint(p), t);
    return gNoChanges;
}

void EvtHandler::Control(int id, int part, void *val)
{
    if (GetNextHandler())
	GetNextHandler()->Control(id, part, val);
}

Command *EvtHandler::DoIdleCommand()
{
    if (GetNextHandler())
	return GetNextHandler()->DoIdleCommand();
    return gNoChanges;
}

void EvtHandler::DownControl(int, int, void*)
{
}

Point EvtHandler::ContainerPoint(Point p)
{
    return p;
}

Command *EvtHandler::TrackInContent(Point, Token, Command *currCmd)
{
    return currCmd;
}
#include "System.h"

Command *EvtHandler::DispatchEvents(Point lp, Token t, Clipper *vf)
{
    extern int Clicks;
    register Command *currCmd= gNoChanges;
    
    switch (t.Code) {
    case eEvtRightButton:
	if (!(t.Flags & eFlgButDown))
	    currCmd= DoRightButtonDownCommand(lp, t, Clicks, vf);
	break;
    case eEvtMiddleButton:
    case eEvtLeftButton:
	if (!(t.Flags & eFlgButDown)) {
	    if (t.Code == eEvtLeftButton)
		currCmd= DoLeftButtonDownCommand(lp, t, Clicks);
	    else
		currCmd= DoMiddleButtonDownCommand(lp, t, Clicks);
	    if (currCmd && currCmd != gNoChanges && vf)
		currCmd= vf->TrackInContent(lp, t, currCmd);
	}
	break;
    default:
	if (t.IsKey())
	    currCmd= DoKeyCommand(t.Code, lp, t);
	else if (t.IsFunctionKey()) 
	    currCmd= DoFunctionKeyCommand(t.FunctionCode(), lp, t);
	else if (t.IsCursorKey())
	    currCmd= DoCursorKeyCommand(t.CursorDir(), lp, t);
	else if (t.Code == eEvtIdle)
	    currCmd= DoIdleCommand();
	else
	    currCmd= DoOtherEventCommand(lp, t);
	break;
    }
    return currCmd;
}
