//$Expander$
#include "Expander.h"

MetaImpl(Expander, (I_I(dir), I_P(gap)));

Expander::Expander(int id, Direction d, Point g, VObject*, ...)
						    : (id, (Collection*)0)
{
    va_list ap;
    va_start(ap, g);
    dir= d;
    gap= g;
    SetItems(ap);
    va_end(ap);
}

Expander::Expander(Direction d, Point g, VObject*, ...)
						    : (cIdNone, (Collection*)0)
{
    va_list ap;
    va_start(ap, g);
    dir= d;
    gap= g;
    SetItems(ap);
    va_end(ap);
}

Expander::Expander(int id, Direction d, Point g, Collection *c= 0) : (id, c)
{
    dir= d;
    gap= g;
}

Metric Expander::GetMinSize()
{    
    Iter next(GetIterator());
    VObject *vop;
    Point e, ee;

    while (vop= (VObject*) next()) {
	ee= vop->GetMinSize().extent;
	if (dir) {
	    e.x= max(e.x, ee.x);
	    e.y+= ee.y+gap.y;
	} else {
	    e.x+= ee.x+gap.x;
	    e.y= max(e.y, ee.y);
	}
    }
    e[dir]-= gap[dir];
    return Metric(e);
}

int Expander::ExpandCnt()
{
    Iter next(GetIterator());
    register Object *op;
    int n= 0;
    
    while (op= next())
	if (! op->TestFlag(dir ? eVObjVFixed : eVObjHFixed))
	    n++;
    return n;
}

void Expander::SetExtent(Point e)
{
    Iter next(GetIterator());
    register VObject *vop;
    int d, div= 0, mod= 0, n= ExpandCnt();
    Point newsize;
    bool hfixed, vfixed;
    
    VObject::SetExtent(e);
    d= (e-GetMinSize().extent)[dir];
    if (n > 0) {
	div= d / n;
	mod= d % n;
    }
    
    while (vop= (VObject*) next()) {
	vfixed= vop->TestFlag(eVObjVFixed);
	hfixed= vop->TestFlag(eVObjHFixed);
	newsize= vop->GetMinSize().extent;
	if (dir) {
	    if (!hfixed)
		newsize.x= e.x;
	    if (!vfixed) {
		newsize.y+= div;
		if (mod > 0) {
		    newsize.y++;
		    mod--;
		}
	    }
	} else {
	    if (!vfixed)
		newsize.y= e.y;
	    if (!hfixed) {
		newsize.x+= div;
		if (mod > 0) {
		    newsize.x++;
		    mod--;
		}
	    }
	}
	vop->SetExtent(newsize);
    }
}

void Expander::SetOrigin(Point at)
{
    Iter next(GetIterator());
    register VObject *vop;

    VObject::SetOrigin(at);
    while (vop= (VObject*) next()) {
	vop->SetOrigin(at);
	if (dir)
	    at.y+= vop->Height() + gap.y;
	else
	    at.x+= vop->Width() + gap.x;
    }
}
