#ifndef FindDialog_First
#define FindDialog_First

#include "Dialog.h"
#include "Command.h"

//---- find/change dialog --------------------------------------------------

class FindDialog : public Dialog {
    class RegularExp *rex;
    class TextView *tvp;
    class EditTextItem *ei1, *ei2;
    bool atEnd, atBegin, ignoreCase, matchWord, selectionOnly, forward;
    char *pattern;
public:
    MetaDef(FindDialog);
    FindDialog(char *title, class TextView *tvp);
    ~FindDialog();
    class VObject *DoCreateDialog();
    void DoSetup();
    void Control(int id, int, void *v);
    virtual bool DoFind(EditTextItem*, bool forward, bool msg= TRUE);
    virtual void DoChangeAll(EditTextItem*, class Text*);
    virtual void DoChange(EditTextItem*, class Text*);
};

//---- class ChangeAllCommand ------------------------------------------------

class ChangeAllCommand: public Command {
    class TextView *tvp;
    class FindDialog *fd;
    int from, to;
    EditTextItem *find;
    class Text *change;
public:    
    ChangeAllCommand(class TextView *t, class FindDialog *fd, 
		    EditTextItem *find, class Text* change, int from, int to);
    void DoIt();
};

#endif FindDialog_First
