#ifndef FixedSizeStorage_First
#define FixedSizeStorage_First

#include "Object.h"

class FixedSizeStorage {
    class FixedSizeStorage *next;
    int chunkSize;
    struct Chunk *chunks;
    struct FreeNode *freeList;
    char *classname;
    int lastIndex;
    int objPerChunk;
    int objSize;
    bool stat;
    int allocated;
    int recycled;
    int freed;
    int nchunks;
    bool isObject;
public:
    FixedSizeStorage(int objSize, bool isObject, char *classname= 0, int chunkSize= 4096, 
					 bool showStatistics= FALSE);
    ~FixedSizeStorage();
    void *Alloc();
    bool Dealloc(void *);        // returns TRUE if not on stack
    bool ForObjects()
	{ return isObject; }
    friend void PrintFixedStorageStatistics();
};

#define FIXED_STORAGE(type,size) \
static FixedSizeStorage _NAME2_(_FixedStorage,type)(sizeof(type), FALSE, "type", size)

#define FIXED_OBJ_STORAGE(type,size) \
static FixedSizeStorage _NAME2_(_FixedStorage,type)(sizeof(type), TRUE, "type", size)

extern bool gAddToInstTable;

#define FIXED_SIZE_ALLOC(type) \
    gAddToInstTable= _NAME2_(_FixedStorage,type).ForObjects();\
    this= this ? this : (type*)_NAME2_(_FixedStorage,type).Alloc(); \
    gAddToInstTable= TRUE;
    
#define FIXED_SIZE_DEALLOC(type) \
    { if (_NAME2_(_FixedStorage,type).Dealloc(this)) this= 0; }

#endif FixedSizeStorage_First
