//$GotoDialog$
#include "GotoDialog.h"
#include "Dialog.h"
#include "DialogItems.h"
#include "TextView.h"
#include "Document.h"
#include "BlankWin.h"
#include "WindowSystem.h"
#include "ObjectTable.h"

//---- GotoDialog ---------------------------------------------------------------

class GotoDialog : public Dialog {
    class TextView *view;
    class NumItem *line;
    int lineNo;
    
    VObject *DoCreateDialog();
    void Control(int id, int, void *v);
public:
    MetaDef(GotoDialog);
    
    GotoDialog();
    int ShowGotoDialog(class TextView*); 
    void DoSetup(); 
    GetLineNo()
	{ return lineNo; }
};

static GotoDialog *gotoDialog;

//---- entry Point -----------------------------------------------------------

void GotoLine(TextView *tv)
{
    if (gotoDialog == 0) {
	gotoDialog= new GotoDialog;
	ObjectTableAddRoot(gotoDialog);
    }
    if (gotoDialog->ShowGotoDialog(tv) != cIdYes)
	return;
    int at= gotoDialog->GetLineNo();
    LineMark *lm= tv->MarkAtLine(at-1);
    tv->SetSelection(lm->Pos(),lm->End(),TRUE);
    tv->RevealSelection();
    GraphicDelay(500);
    tv->SetSelection(lm->Pos(),lm->Pos(),TRUE);    
}

//---- GotoDialog ---------------------------------------------------------------

MetaImpl(GotoDialog, (I_O(view), I_O(line)));

GotoDialog::GotoDialog() : (0, eBWinBlock)
{
    line= 0;
}

int GotoDialog::ShowGotoDialog(TextView *v)
{
    lineNo= -1;
    if (v) {
	view= v;
	return Show();
    }
    return -1;
}
 
VObject *GotoDialog::DoCreateDialog()
{
    return new BorderItem(
	new BorderItem(
	    new Cluster(cIdNone, eVObjHCenter, 10,
		new BorderItem ("Go to line",
		    new EnumItem(cIdNone, eVObjVBase, line= new NumItem(cIdNone, 1)),
		),
		new Cluster(cIdNone, eVObjVBase, 20,
		    new ActionButton(cIdYes, "Ok", TRUE),
		    new ActionButton(cIdCancel, "Cancel"),
		    0
		),
		0
	    ),
	    20, 3
	),
	Point(2,2),
	1
    );
}

void GotoDialog::DoSetup()
{
    int f,t;
    view->GetSelection(&f, &t);
    line->SetValue(view->CharToLine(f)+1);
    line->SetRange(1, view->NumberOfLines());
}

void GotoDialog::Control(int id, int p, void *v)
{
    Dialog::Control(id, p, v);
    if (id == cIdYes)
	lineNo= line->GetValue();
}
