#include "System.h"
#include "WindowSystem.h"
#include "ProgEnv.h"
#include "Error.h"

extern System *NewSunSystem();

extern WindowSystem *NewXWindowSystem();
extern WindowSystem *NewServerWindowSystem();
extern WindowSystem *NewSunWindowSystem();
extern WindowSystem *NewNeWSWindowSystem();

extern class Printer *gPrinters[];
extern Printer      *NewPrinter();
extern Printer      *NewPicPrinter();
extern Printer      *NewPostScriptPrinter();

extern ProgEnv      *NewEtProgEnv();

ONENTRY(Init) 
{

#   ifdef OS_SUNOS
    gSystem= NewSunSystem();
    if (gSystem->Init()) {
	Warning("Init", "can't init operating system");
	_exit(1);
    }
#   endif OS_SUNOS
    
    if (gSystem == 0) {
	Warning("Init", "can't find operating system");
	_exit(0);    // give up
    }

#   ifdef WS_SUNSERVER
    if (gWindowSystem == 0)
	gWindowSystem= NewServerWindowSystem(); // try to connect to SunWindow server
#   endif WS_SUNSERVER
    
#   ifdef WS_NEWS
    if (gWindowSystem == 0)
	gWindowSystem= NewNeWSWindowSystem();   // try to connect to NeWS server
#   endif WS_NEWS
    
#   ifdef WS_X
    if (gWindowSystem == 0)
	gWindowSystem= NewXWindowSystem();      // try to connect to X server
#   endif WS_X

#   ifdef WS_SUNWINDOW
    if (gWindowSystem == 0)
	gWindowSystem= NewSunWindowSystem();    // try SunWindow System
#   endif WS_SUNWINDOW
    
    if (gWindowSystem == 0) {
	Warning("Init", "can't find window system");
	_exit(0);    // give up
    }
    
#   ifdef ET_PROGENV
    if (gProgEnv == 0)
	gProgEnv= NewEtProgEnv(); 
#   endif ET_PROGENV

    if (gProgEnv == 0) 
	gProgEnv= new ProgEnv();
	
    gWindowSystem->Init();
    
    int i= 0;
    
#   ifdef PR_POSTSCRIPT
    gPrinters[i++]= NewPostScriptPrinter();
#   endif PR_POSTSCRIPT

#   ifdef PR_PIC
    gPrinters[i++]= NewPicPrinter();
#   endif PR_PIC

    gPrinters[i]= 0;
}

ONEXIT(Init)
{
    SafeDelete(gWindowSystem);
    SafeDelete(gSystem);
    SafeDelete(gProgEnv);
}
