#include "System.h"
#include "ProgEnv.h"
#include "Error.h"

extern System *NewSunSystem();

ONENTRY(Init) 
{
#   ifdef OS_SUNOS
    gSystem= NewSunSystem();
    if (gSystem->Init()) {
	Warning("Init", "can't init operating system");
	_exit(1);
    }
#   endif OS_SUNOS
    
    if (gSystem == 0) {
	Warning("Init", "no operating system found");
	_exit(0);    // give up
    }

    if (gProgEnv == 0) 
	gProgEnv= new ProgEnv();
}

ONEXIT(Init)
{
    SafeDelete(gSystem);
    SafeDelete(gProgEnv);
}
