#ifndef ObjList_First
#define ObjList_First

#include "SeqCollection.h"

typedef void (*ObjectFunction)(ObjPtr, ...);     

class ObjLink: public Object {
friend class ObjList;
friend class ObjListIter;
friend class RevObjListIter;
friend class FilterObjListIter;
friend class RevFilterObjListIter;
    ObjLink *next, *previous;
    ObjPtr op;
    
public:
    MetaDef(ObjLink);
    ObjLink(ObjPtr a, ObjLink* n, ObjLink* p);
    ObjLink(ObjPtr a, ObjLink*);
    ~ObjLink();
    ObjPtr Op()
	{ return op; }
    ObjLink *Next()
	{ return next; }
    void FreeAll();
};

class ObjList: public SeqCollection {
friend class ObjListIter;
friend class RevObjListIter;
friend class FilterObjListIter;
friend class RevFilterObjListIter;

protected:
    ObjLink *first, *last;
    void RemoveDeleted();
    void RemoveLink(ObjLink *l);
    
public:
    MetaDef(ObjList);
    
    ObjList();
    ~ObjList();
    void FreeAll();
    
    void Insert(ObjPtr a);
    void InsertBefore(ObjPtr before, ObjPtr a);
    void InsertAfter(ObjPtr after, ObjPtr a);
    ObjPtr Replace(ObjPtr a, ObjPtr b);
    ObjPtr First();
    ObjPtr Last();
    ObjPtr GetAt(int);
    ObjPtr Remove(ObjPtr);
    ObjPtr RemovePtr(ObjPtr);
    
    //---- collection compatibility
    Iterator *GetIterator();
    Iterator *ReversedIterator();
    ObjPtr Add(ObjPtr);
    void Empty(int);
    ObjPtr At (int i);
    ObjPtr AtBefore(ObjPtr);
    ObjPtr AtAfter(ObjPtr);
};

//---- class ObjListIter -------------------------------------------------------

class ObjListIter: public Iterator {
public:
    ObjLink *ce;
    ObjList *cs;

    ObjListIter(Collection *s);
    ~ObjListIter();
    void Reset(Collection *s= 0);
    Collection *Coll();
    Object* operator()();
};

//---- class RevObjListIter ----------------------------------------------------

class RevObjListIter: public ObjListIter {
public:
    RevObjListIter(ObjList *s);
    Object* operator()();
    void Reset(Collection *s= 0);
};

#endif ObjList
