//$Object,ChangeMessage$
#include "Object.h"
#include "OrdCollection.h"
#include "IdDictionary.h"
#include "ObjInt.h"
#include "Error.h"
#include "String.h"
#include "Storage.h"
#include "ProgEnv.h"
#include "System.h"
#include "ObjectTable.h"
#include "membuf.h"
 
bool gInPrintOn;
bool gAddToInstTable= TRUE;

//---- delayed changes ---------------------------------------------------------

// dictionary to store the delayed Change messages, the key is the object pointer
// (IdDictionary) the value is an OrderedCollection of ChangeMessages (see below).
// The first entry of the OrderedCollection is a reference count of the number of
// DelayChanges requests. FlushChanges will be executed when the count drops to 0.
// Whether change messages are delayed is set with the cObjDelayChanges flag

static IdDictionary DelayedChanges; 

class ChangeMessage: public Object {
    void *what;
public:
    ChangeMessage(void *w)
	{ what= w; }
    void *GetWhat()
	{ return what; }
};

// the following comment must be a C comment, otherwise havoc will result !!!
/*---- automatically added by macro MetaImpl -------------------------------*/

static Class ObjectClassMetaImpl0("Object",
				  sizeof (Object),
				  new Object((Class*)0),
				  __FILE__,
				  "./Object.h",
				  __LINE__,
				  1,
				  __COMPILEDIR__,
				  __COMPILEDIR__,
				  TRUE);

Object::Object(Class*)
{
    flags= cObjNonDeleted | cObjIsProto;
    classptr= 0;
    ObjectClassMetaImpl0.SetSuper();
}

Class *Object::IsA()
{
    return &ObjectClassMetaImpl0;
}

void Object::Members()
{
    I_O(dependents);    
    I_X(flags);
}

//---- ordinary methods ----------------------------------------------------

Object::Object(int f)
{
    dependents= 0;
    flags= (f & cFlagMask) | cObjNonDeleted;
    ObjectTableAdd(this);
}

Object::~Object()
{
    if (this == 0)
	return;
    if (! TestFlag(cObjNonDeleted)) {
	if (gMemStatistics)
	    Fatal("~Object", "object deleted twice");
	this= 0;
	return;
    }

    ObjectTableRemove(this);
    flags&= ~cObjNonDeleted;
    if (gInPrintOn) 
	ClassInvalidatePtr(this);
    if (dependents) {
	OrdCollection *olddependents= dependents;
	dependents= 0;
	olddependents->ForEach(Object,ChiefDied)(this);
	SafeDelete(olddependents);
    }
}

void Object::FreeAll()
{
}

char *Object::ClassName()
{
    Class *clp= IsA();

    if (clp)
	return clp->Name();
    return 0;
} 

ObjPtr Object::New()
{
    Class *clp= IsA();

    if (clp)
	return clp->New();
    return 0;
}

void Object::InitNew()
{
}

void Object::Inspect(bool block)
{
    gProgEnv->InspectObject(this, block);
}

void Object::EditSource(bool definition)
{
    gProgEnv->EditSourceOf(IsA(), definition);
}

void Object::InspectorId(char *buf, int)
{
    buf[0]= '\0';
}

void Object::DoError(int level, char *location, va_list va)
{
    ::ErrorHandler(level, form("%s::%s", ClassName(), location), va);
}

void Object::Error(char *location, char*, ...)
{
    va_list ap;
    va_start(ap, location);
    DoError(cError, location, ap);
    va_end(ap);
}

void Object::SysError(char *location,  char*, ...)
{
    va_list ap;
    va_start(ap, location);
    DoError(cSysError, location, ap);
    va_end(ap);
}

void Object::Warning(char *location, char*, ...)
{
    va_list ap;
    va_start(ap, location);
    DoError(cWarning, location, ap);
    va_end(ap);
}

void Object::Fatal(char *location, char*, ...)
{
    va_list ap;
    va_start(ap, location);
    DoError(cFatal, location, ap);
    va_end(ap);
}

Object *Object::Clone()
{
    Object *clone= New();

    if (clone)
	bcopy((byte*) this, (byte*) clone, IsA()->Size());
    return clone;
}

Object *Object::DeepClone()
{
    int status;
    membuf mb;
    ostream to(&mb);
    istream from(&mb);
    ObjPtr op;

    ClassReset();
    gInPrintOn= TRUE;
    to << this NL;
    to.flush();
    gInPrintOn= FALSE;

    ClassReset();
    from >> op;
    if (status= ClassReset()) {
	Error("DeepClone", "status %d", status);
	return 0;
    }
    return op;
}

void Object::SetFlag(int f, bool b)
{
    if (b)
	SetFlag(f);
    else
	ResetFlag(f);
}

//---- fire walls ----------------------------------------------------------

void Object::AbstractMethod(char *method)
{
    Warning(method, "abstract method called"); 
}

void Object::MayNotUse(char *method)
{
    Warning(method, "not allowed to use this method");
}

Object *Object::guard(bool ok, char *name)
{
    if (ok)
	return this;
    Error("Guard", "object is not a %s but a %s", name, ClassName());
    return 0;
}

//---- comparing -----------------------------------------------------------

int Object::Hash () 
{
    return (int) this;
}

bool Object::IsEqual (Object *anOp)
{
     return anOp == this;
}

int Object::Compare (Object*)
{
    AbstractMethod ("Compare");
    return 0;
}

//---- change propagation ------------------------------------------------------

void Object::AddDependent (ObjPtr op)
{
    if (op) {
	if (dependents == 0) 
	    dependents= new OrdCollection;
	else if (dependents->FindPtr(op)) {
	    cerr << "Duplicate in dependents\n";
	    return;
	}
	dependents->Add (op);
    }
}

ObjPtr Object::RemoveDependent (ObjPtr op)
{
    if (this && dependents) {
	if (op)
	    op= dependents->RemovePtr(op);
	if (dependents->IsEmpty())
	    SafeDelete(dependents);
	return op;
    }
    return 0;
}

void Object::DoUpdate(ObjPtr,void *)
{
}

void Object::ChiefDied(ObjPtr)
{
}  

int Object::DoChanged(void *what)
{
    // if (dependents == 0)
    //     return 0; 
    if (TestFlag(cObjDelayChanges)) {
	Collection *col= (Collection*) DelayedChanges.AtKey(this);
	if (!col)
	    Error("DoChanged", "No collection for change messages");
	col->Add(new ChangeMessage(what));
	DelayedChanges.AtKeyPut(this,col);
    } else {
	dependents->ForEach(Object,DoUpdate)(this, what);
    }
    return 0; // ??
}

bool Object::ChangeRequest()
{
    if (dependents) {
	Object *op;
	OrdCollectionIter next (dependents);

	while (op = next())
	    if (!op->UpdateRequest())
		return FALSE;
    }
    return TRUE;
}

bool Object::UpdateRequest()
{
    return TRUE;
}

void Object::BroadCast (ObjPtrFun fp,void* Arg)
{
    if (dependents) {
	register ObjPtr op;
	OrdCollectionIter next (dependents);

	while (op= next())
	    (*fp) (this, op, Arg);
    }
}

void Object::DelayChanges()
{
    flags |= cObjDelayChanges;
    Collection *col= (Collection*) DelayedChanges.AtKey(this);
    if (!col) {
	col= new OrdCollection;
	col->Add(new ObjInt(0));
	DelayedChanges.AtKeyPut(this,col);
    } else { // increment reference count
	ObjInt *ref= (ObjInt*)col->At(0);
	(*ref)++;
    }
}

void Object::FlushChanges()
{
    Collection *col= (Collection*) DelayedChanges.AtKey(this);
    if (col) {
	ObjInt *ref= (ObjInt*)col->At(0);
	if (ref->GetValue() == 0) {
	    flags &= ~cObjDelayChanges;
	    ChangeMessage *cm;
	    Iter next(col);
	    next(); // overread reference count
	    while (cm= (ChangeMessage*) next()) 
		ChangedWhat(cm->GetWhat());
	    col->FreeAll();
	    delete DelayedChanges.RemoveKey(this);
	}
	else 
	    (*ref)--;
    }   
}

class Iterator *Object::GetDepIter()        
{ 
    if (dependents)
	return new OrdCollectionIter(dependents); 
    return 0;
}

bool Object::PrintOnWhenDependent(Object *)
{
    return TRUE;    
}

//---- converting --------------------------------------------------------------

char* Object::AsString()
{
    return "";
}

//---- activation/passivation --------------------------------------------------

static bool printOnWhenDependent(ObjPtr, ObjPtr op, Object *from)
{
    return op->PrintOnWhenDependent(from);
}

ostream &Object::PrintOn(ostream &os)
{
    IsA()->MakeIndex(this);
    if (dependents) {
	if (dependents->IsEmpty()) {
	    SafeDelete(dependents);
	} else {
	    Collection *selectedDeps;
	    selectedDeps= dependents->Select(printOnWhenDependent, this);
	    if (selectedDeps->IsEmpty())
		SafeDelete(selectedDeps);
	    os << (flags & cFlagMask) SP << selectedDeps SP;
	    SafeDelete(selectedDeps);
	    return os;           
	}
    }
    return os << (flags & cFlagMask) SP << dependents SP;
}

istream &Object::ReadFrom(istream &is)
{
    int f;
    IsA()->MakeIndex(this);
    is >> f >> dependents;
    SetFlag(f);
    return is;
}

ostream &Object::DisplayOn(ostream &o)
{
    return o NL;
}

ONENTRY(Object)
{
    ObjectTableAddRoot(&DelayedChanges);
}

