//$EtProgEnv$

#include "EtProgEnv.h"
    
#include "Application.h"
#include "Window.h"
#include "Splitter.h"

#include "Browser.h"
#include "Inspector.h"
#include "VObjTreeView.h"
#include "CollTableView.h"
#include "Collection.h"
#include "Dialog.h"
#include "ObjectTable.h"

static char *cVObjectTree= "VObject Tree",
	    *cCollectionTable= "Collection Table";

//---- global entry point ----------------------------------------------------

ProgEnv *NewEtProgEnv()
{
    return new EtProgEnv();
}

//---- EtProgEnv ------------------------------------------------------------

EtProgEnv::~EtProgEnv()
{
    SafeDelete(browserDoc);
    SafeDelete(hierarchy);
    SafeDelete(flatInheritance);
    SafeDelete(fihView);
    SafeDelete(vobjTree);
    SafeDelete(vobjTreeView);
    SafeDelete(inspector);
    SafeDelete(colltableView);
    SafeDelete(collTable);
}

EtProgEnv::EtProgEnv()
{
    browserDoc= 0;
    hierarchy= 0;
    flatInheritance= 0;
    classTreeView= 0;
    fihView= 0;
    inspector= 0;
    vobjTreeView= 0;
    vobjTree= 0;
    collTable= 0;
    colltableView= 0;
}
    
void EtProgEnv::EditSourceOf(Class *cp, bool decl)
{
    if (browserDoc == 0) {
	browserDoc= new BrowserDoc;
	gApplication->AddDocument(browserDoc);
	browserDoc->OpenWindows();
    } else
	browserDoc->GetWindow()->Open();
    browserDoc->SetClass(cp, decl);
}

void EtProgEnv::EditSource(Class *cp)
{
    if (browserDoc == 0)
	EditSourceOf(cp, TRUE);
    else
	EditSourceOf(cp, browserDoc->GetMode());
}

void EtProgEnv::ShowInHierarchy(Class *cp)
{
    if (hierarchy == 0) {
	classTreeView= new ClassTreeView();
	hierarchy= new Window(0, Point(500, 600), eWinDefault+eWinCanClose,
			new Splitter(classTreeView), "Class Hierarchy");
	ObjectTableAddRoot(hierarchy);
    }
    hierarchy->OpenAt(Point(100, 200));
    classTreeView->ShowClass(cp);
}

void EtProgEnv::ShowInheritancePath(Class *cp)
{
    if (flatInheritance == 0) {
	fihView= new FihView(new FihClassTable);        
	flatInheritance= new Window(0, Point(600, 400),eWinDefault+eWinCanClose,
			new Splitter(fihView), "Flat Inheritance View");
	ObjectTableAddRoot(flatInheritance);
    }
    flatInheritance->OpenAt(Point(150,200));
    fihView->ShowClass(cp);
}

void EtProgEnv::Closed(Object *op)
{
    if (op == browserDoc)
	browserDoc= 0;
    if (op == inspector)
	inspector= 0;
}
   
void EtProgEnv::InspectObject(Object *op, bool block)
{
    if (inspector == 0) 
	inspector= new Inspector(block ? eWinDefault+eBWinBlock : eWinDefault);
    inspector->Init(op);      
} 

char *EtProgEnv::HasAbstractView(Object *op)
{
    if (op && op->IsKindOf(Window))
	op= ((Window*)op)->GetViewedVObject();
    if (op->IsKindOf(VObject)) {
	if (op->IsKindOf(CompositeVObject) || op->IsKindOf(DialogView))
	    return cVObjectTree;
	Object *vop= ((VObject*)op)->GetNextHandler();
	if (vop && vop->IsKindOf(CompositeVObject))
	    return cVObjectTree;
    }
    if (op->IsKindOf(Collection) && ((Collection*)op)->Size()) 
	return cCollectionTable;
    if (op->IsKindOf(CollectionView) && ((CollectionView*)op)->GetCollection()->Size()) 
	return cCollectionTable;
    return 0;
}

void EtProgEnv::ShowAbstractView(Object *op)
{
    if (op && op->IsKindOf(DialogView))
	op= ((DialogView*)op)->GetRoot();
    if (op && op->IsKindOf(Window))
	op= ((Window*)op)->GetViewedVObject();
    
    if (op) {
	if (op->IsKindOf(VObject)) 
	    ShowVObjectTree((VObject*)op);
	else if (op->IsKindOf(Collection)) 
	    ShowCollTable((Collection*)op); 
    }    
}

void EtProgEnv::ShowCollTable(Collection *col)
{
    if (collTable == 0) {
	colltableView= new CollTableView();        
	collTable= new Window(0, Point(400, 200), eWinDefault+eWinCanClose,
		    new Splitter(colltableView), "Collection");
	ObjectTableAddRoot(collTable);
    }
    collTable->OpenAt(Point(800,500));
    collTable->SetTitle(form("Collection: 0x%x (%s)", (int)col, col->ClassName()), TRUE);
    colltableView->ShowCollection(col);
}

void EtProgEnv::ShowVObjectTree(VObject *vop)
{
    if (vobjTree == 0) {
	vobjTreeView= new VObjTreeView();        
	vobjTree= new Window(0, Point(600, 400), eWinDefault+eWinCanClose,
		    new Splitter(vobjTreeView), "VObject Tree");
	ObjectTableAddRoot(vobjTree);
    }
    vobjTree->OpenAt(Point(300,400));
    vobjTree->SetTitle(form("VObject Tree: 0x%x (%s)", (int)vop, vop->ClassName()), TRUE);
    vobjTreeView->ShowVObjTree(vop);
}

