#ifndef Picture_First
#define Picture_First

#include "Port.h"

const cExpandIncr= 20;

typedef class Picture *PicturePtr;

class Picture {
    struct PictItem *pi;
    int len, size;
    Rectangle bbox;
    
public:
    Picture(int sz= cExpandIncr);
    ~Picture();
    
    void Close();
    void AddSimple(char, GrPattern, GrMode, Rectangle*, int, GrLineCap, Point);
    void AddPoly(char, GrPattern, GrMode, Point*, int, GrPolyType, int, GrLineCap);
    void AddLine(GrPattern, GrMode, Rectangle*, int, GrLineCap, Point, Point);
    void AddBitmap(GrPattern, GrMode, Rectangle*, Bitmap*);
    void AddText(GrPattern, GrMode, Rectangle*, Point, FontPtr, int, byte*);
    void AddPicture(Rectangle*, Picture*);
    void DevGiveHint(int, int, void*);
    
    void Expand(int sz= 0);
    void Show(Rectangle*, Port*);
    void Merge(Rectangle *r)
	{ bbox.Merge(*r); }
    Rectangle BBox()
	{ return bbox; }
	
    ostream& PrintOn (ostream&);
    ostream& ReadFrom (ostream&);
    friend ostream& operator<< (ostream&, PicturePtr&);
    friend istream& operator>> (istream&, PicturePtr&);
};

#endif Picture_First
