#ifndef Rectangle_First
#define Rectangle_First

#include "Metric.h"

overload Moveby;

class Rectangle {
public:
	Point origin;
	Point extent;
 
	
	Rectangle();

	Rectangle(short x, short y, short w, short h);

	Rectangle(Point o, Point e);
	    
	Rectangle(Point e);

	Rectangle(short w, short h);
	
	/*
	Rectangle()
	    { origin.x= origin.y= extent.x= extent.y= 0; }

	Rectangle(short x, short y, short w, short h)
	    { origin.x= x; origin.y= y; extent.x= w; extent.y= h; }

	Rectangle(Point o, Point e)
	    { origin= o; extent= e; }
	    
	Rectangle(Point e)
	    { origin= 0; extent= e; }

	Rectangle(short w, short h)
	    { origin= 0; extent.x= w; extent.y= h; }
	*/
	
	int Width()
	    { return extent.x; }

	int Height()
	    { return extent.y; }

	int Left()
	    { return origin.x; }

	int Top()
	    { return origin.y; }
	    
	Point Center()
	    { return Point(origin.x+extent.x/2, origin.y+extent.y/2); }

	Point NW()
	    { return origin; }
	    
	Point N()
	    { return origin + Point(extent.x/2, 0); }

	Point NE()
	    { return origin + Point(extent.x-1, 0); }

	Point E()
	    { return origin + Point(extent.x-1, extent.y/2); }
	    
	Point SE()
	    { return origin + extent - 1; }
	    
	Point S()
	    { return origin + Point(extent.x/2, extent.y-1); }
	    
	Point SW()
	    { return origin + Point(0, extent.y-1); }

	Point W()
	    { return origin + Point(0, extent.y/2); }
		
	friend Rectangle NormRect(Point p1, Point p2);
	    
	friend Rectangle BoundingBox(int, Point *);

	int Area ()
	    { return extent.x * extent.y; }

	Rectangle &Moveby (Point p)
	    { origin+= p; return *this; }
	    
	friend Rectangle Moveby (Rectangle r, Point p)
	    { r.origin+= p; return r; }
	    
	Rectangle operator+= (Point p)
	    { origin+= p; return *this; }
	    
	Rectangle operator+ (Point p)
	    { return Rectangle(origin+p, extent); }
	    
	Rectangle operator- (Point p)
	    { return Rectangle(origin-p, extent); }
	    
	Rectangle operator-= (Point p)
	    { origin-= p; return *this; }

	void Moveto (Point p)
	    { origin= p; }

	void Scaleby (Point p)
	    { extent*= p; }

	friend bool operator== (Rectangle &r1, Rectangle &r2)
	    { return r1.origin == r2.origin && r1.extent == r2.extent; }

	friend bool operator!= (Rectangle &r1, Rectangle &r2)
	    { return r1.origin != r2.origin || r1.extent != r2.extent; }
	    
	friend Rectangle Union(Rectangle &r1, Rectangle &r2);

	friend Rectangle Inter(Rectangle &r1, Rectangle &r2);

	friend int Difference(Rectangle *rp, Rectangle &r1, Rectangle &r2);
	
	Rectangle Intersect(Rectangle &r);
 
	bool Clip(Rectangle &r);
	
	bool ContainsRect(Rectangle &r);
	
	Rectangle Inset(Point p)
	    { return Rectangle(origin + p, extent - p*2); }

	Rectangle Expand(Point p)
	    { return Rectangle(origin - p, extent + p*2); }
	    
	Rectangle Merge(Rectangle &r);

	bool ContainsPoint(Point p)
	    { return p >= origin && p < origin + extent; }

	bool Intersects(Rectangle &r);
		      
	bool IsEmpty()
	    { return extent.x <= 0 || extent.y <= 0; }
		
	bool IsNotEmpty()
	    { return extent.x > 0 && extent.y > 0; }

	Point Constrain(Point p)
	    { return Max(Min(p, origin+extent), origin); }
	    
	friend Point ConstrainMoveRect(Rectangle &r1, Rectangle &r2, Point delta);

	Point AmountToTranslateWithin(Rectangle &r);

	int PointToAngle(Point);
	
	Point AngleToPoint(int);
		
	//         7|0|1
	//        -------
	//         6| |2
	//        -------
	//         5|4|3

	int PointToCorner(Point p);

	Point CornerToPoint(int n);
	
	friend ostream& operator<< (ostream &s, Rectangle &r);
		       
	friend istream& operator>> (istream &s, Rectangle &r);
	
	char *AsString();
};

extern const Rectangle gRect0;

#endif Rectangle_First
