#ifndef SunSystem_First
#define SunSystem_First

#include "../System.h"

//---- SunDirectory ------------------------------------------------------------

class SunDirectory : public Directory {
    void *dirp;
public:
    SunDirectory(char *name);
    ~SunDirectory();
    char *operator()();
};

//---- SunSystem ---------------------------------------------------------------

class SunSystem: public System {
public:
    SunSystem();
    bool Init();
    void InnerLoop();
    bool ExpandPathName(char *patbuf, int buflen);
    void GetTtyChars(char &backspace, char &rubout);
    class Directory *MakeDirectory(char *name);
    bool AccessPathName(char *path, int mode= 0);
    bool ChangeDirectory(char *path);
    char *WorkingDirectory();

    void wait(unsigned int duration);
    void SetUpMask(struct fd_set*, class ObjList*);
    void DispatchReadWrite(struct fd_set*, class ObjList*);
    void DispatchSignals(bool asynch);
    class PttyConnection *MakePttyConnection(char *prog, char **args);
    class FileType *GetFileType(char *path);

    //---- environment manipulation -----------------------------
    void Setenv(char *name, char *value);
	// set environment variable name to value   
    void Unsetenv(char *name);
	// remove environment variable
    char *getenv(char *);

    void stacktrace(int level, bool abortafter);
};

extern System *NewSunSystem();

#endif SunSystem_First
