/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.
 * Users may copy, modify or distribute this file at will.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 *
 * Modifications to the original Sun Microsystems, Inc. source code
 * made by the Grasshopper Group are in the Public Domain.
 *
 * Extensions to this file by Eric Messick of the Grasshopper Group.
 *
 * Grasshopper Group
 * 212 Clayton St
 * San Francisco, CA 94117
 *
 * Adapted for ET++ at ifi unizh
 *
 */
/*
 * Copyright (c) 1985 by Sun Microsystems, Inc. 
 */
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
/*
 * BSD Support Routines.
 */
#include <sgtty.h>
#include <sys/file.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>

extern void exit();
extern unsigned sleep();
extern char *getenv();
static void get_tty_util();

/* ET++ memory allocation routines */

extern void *Alloc();
extern char *NewChars();
extern void Free();
extern void *Realloc();

/* XXX - there should be a library routine to get a pty */
static char    ptcnameXX[] = "/dev/ptyXX";
static char    ptsnameXX[] = "/dev/ttyXX";
static char ptcname[sizeof ptcnameXX + 1], ptsname[sizeof ptsnameXX + 1];
extern  int errno;

/* Tty mode statics */
static  struct tchars tc;
static  struct ltchars ltc;
static  struct sgttyb sg;
static  int lm;                 /* localmodes */
static  int ld;                 /* ldisc */

/* Default settings for tty mode stuff */
static  struct tchars tc_df =
    { CINTR, CQUIT, CSTART, CSTOP, CEOF, CBRK };
static  struct ltchars ltc_df =
    { CSUSP, CDSUSP, CRPRNT, CFLUSH, CWERASE, CLNEXT };
static  struct sgttyb sg_df =
    { B9600, B9600, CERASE, CKILL, ANYP|ECHO|CRMOD };
static  int lm_df = LCRTBS|LCRTERA|LCRTKIL|LCTLECH;
static  int ld_df = NTTYDISC;

static int CharsPerLine= 80;
static int LinesPerScreen= 24;

struct PttyChars {
    char erase;
    char kill;
    char rprnt;
    char susp;
    char intr;
    char quit;
    char eof;
};

/*---- interface functions ----------------------------------------------*/

FILE       *
sunPttySpawnSlave(name, args, slavepid)
    char *name, **args;
    int *slavepid;
{
    int Mfd, Sfd;
    FILE *Master;
    int i, pid, uid, gid, pgrp;
    unsigned delay = 2 ;
#define MAXDELAY        120
    char *gp, *tp;
	
    signal(SIGTTOU, SIG_IGN);

    strcpy(ptcname, ptcnameXX);
    strcpy(ptsname, ptsnameXX);
    GetTTYDefaults();
    for (gp = "pqrst"; *gp; gp++)
	for (tp = "0123456789abcdef"; *tp; tp++) {
	    ptcname[sizeof ("/dev/pty")-1] = *gp;
	    ptcname[sizeof ("/dev/ptyX")-1] = *tp;
	    if ((Mfd = open(ptcname, 2)) < 0)
		continue;
	    ptsname[sizeof ("/dev/pty")-1] = *gp;
	    ptsname[sizeof ("/dev/ptyX")-1] = *tp;
	    if ((Sfd = open(ptsname, 2)) >= 0)
		goto done;
	    close(Mfd);
    }
done:
    if (Mfd < 0 || Sfd < 0)
	return (NULL);
    uid = getuid(), gid = getgid();
    (void) chown(ptsname, uid, gid);            /* set tty ownership */
    (void) chmod(ptsname, 0622);                /* set tty protection */
    /*
     * Establish tty state.
     */
    SetTTYState(Sfd);
    /*
     * If we're to operate in the background, fork
     * to return control to the shell and disassociate
     * ourselves from the tty.  The caller closes
     * file descriptors so that, for example, rsh
     * will not be kept around.
     */
    /*if (BackGround) {
	if (fork())
	    exit(0);
	(void) setpgrp(0, getpid());
	DisAssociateTTY();
    } else*/
	AssociateTTY();
    Master = fdopen(Mfd, "r+");
    while ((pid = vfork()) < 0 && errno == EAGAIN) {
	sleep(delay);
	if ((delay <<= 1) > MAXDELAY) {
	    close (Mfd); close (Sfd);
	    return (NULL);
	}
    }
    if (pid == 0) {
	/*
	 * Setup controlling tty.
	 */
	for (i = 0; i < 3; i++)
	    (void) dup2(Sfd, i);
	addut(uid, ptsname);
	for (i = getdtablesize(); i > 2; i--)
	    (void) close(i);
	SetupControllingTTY(ptsname);
	(void) setuid(uid), (void) setgid(gid);
	execvp(name, args);
	SysError("sunPttySpawnSlave", "execvp(%s)", name);
	exit(errno);
    }
    pgrp = pid;
    *slavepid= pid;
    (void) fcntl(Mfd, F_SETFL, fcntl(Mfd, F_GETFL, 0)|FNDELAY);
    close(Sfd);
    return (Master);
}

char *sunPttyGetSlaveTtyName()
{
    char *buf= (char*) Alloc(strlen(ptsname)+1);
    strcpy(buf, ptsname);
    return buf;
}

sunPttyCleanupPtty(ptsname)
char *ptsname;
{
    rmut();
    (void) chown(ptsname, 0, 0);                /* revoke ownership */
    (void) chmod(ptsname, 0666);                /* revoke protection */
}

sunPttyKillChild(sig, pgrp, ptsname)
int sig, pgrp;
char *ptsname;
{
    if (pgrp != 0)
	killpg(pgrp, sig);
    sunPttyCleanupPtty(ptsname);
}

sunPttyBecomeConsole(ptsname)
char *ptsname;
{
#ifdef TIOCCONS
    int fd;
    if ((fd = open(ptsname, O_RDWR, 0)) > 0) {
	if (ioctl(fd, TIOCCONS, 0) < 0)
	    SysError("sunPttyBecomeConsole", "sunOsPtty(TIOCCONS)");
    }
    else 
	printf("Cannot become console %s\n", ptsname);
    close (fd);
#endif
}

void sunPttySetSize(slavename,rows,cols)
char *slavename;
int rows,cols;
{
#ifdef TIOCSWINSZ
    int fd;
    if ((fd = open(slavename, O_RDWR, 0)) > 0) {
	struct winsize ws;
	ws.ws_row = rows; ws.ws_col = cols;
	(void) ioctl(fd, TIOCSWINSZ, &ws);    
    }
    else 
	printf("Cannot set window size %s\n", ptsname);
    close (fd);
#endif
}

sunPttyChars(pc)
struct PttyChars *pc;
{
    pc->erase= sg.sg_erase;
    pc->kill= sg.sg_kill;
    pc->rprnt= ltc.t_rprntc;
    pc->susp= ltc.t_suspc;
    pc->intr= tc.t_intrc;
    pc->quit= tc.t_quitc;
    pc->eof= tc.t_eofc;
}

static GetTTYDefaults()
{
    int fd;

    /* Get settings of controlling terminal */
    fd = open("/dev/tty", O_RDWR);
    get_tty_util(fd);
    if (fd > 0)
	close(fd);
    /*
     *   Try to get the tty parameters from stderr (2).
     *   Using stdin (0) fails when being started in the background
     *     because csh redirects stdin from the tty to /dev/null.
     */
    fd = 2;
    if (!isatty(fd)) {
	fd = open("/dev/console", 2);
    }
    get_tty_util(fd);
    if (fd != 2)
	(void) close(fd);
}

Setenv(name, value)
char       *name, *value; {
    register    len;
    register char **ap;
    register char **new;
    register char *buf;
    static      alloced = 0;
    extern char **environ;

    len = strlen(name);
    buf = (char *) Alloc((unsigned)(len + strlen(value) + 2));
    if (buf==NULL) return;
    sprintf(buf, "%s=%s", name, value);
    for (ap = environ; *ap; ap++)
	if (strncmp(*ap, buf, len+1) == 0) {
	    *ap = buf;
	    return;
	}
    len = ap - environ;
    new = (char **) Alloc((unsigned)((len + 2) * sizeof(char *)));
    if (new==NULL) return;
    bcopy((char *)environ, (char *)new, len * sizeof(char *));
    new[len] = buf;
    new[len + 1] = 0;
    if (alloced)
	free((char *)environ);
    alloced = 1 ;
    environ = new;
}

Unsetenv(name)
char *name;
{
	register    len;
	register char **ap;
	register char **new;
	extern char **environ;

	len = strlen(name);
	for (new = ap = environ;  (*new = *ap) != NULL;  ap++) {
		if (strncmp(*ap, name, len) == 0  &&  (*ap)[len] == '=') {
			/* Memory leak bug: we cannot free(*ap) here, because we don't know
			 * whether *ap was created with putenv(). */
			}
		else    new++;
		}
}

Getenv(name)
char *name;
{
    getenv(name);
}

static void
get_tty_util(fd)
    int fd;
{
    if (fd > 0) {
	if(ioctl(fd, TIOCGETP, &sg) == -1)
	    sg = sg_df;
	(void) ioctl(fd, TIOCGETC, &tc);
	if (tc.t_quitc == 0)
	    tc = tc_df;
	(void) ioctl(fd, TIOCGETD, &ld);
	if (ld == 0)
	    ld = ld_df;
	(void) ioctl(fd, TIOCLGET, &lm);
	if (lm == 0)
	    lm = lm_df;
	(void) ioctl(fd, TIOCGLTC, &ltc);
	if (ltc.t_suspc == 0)
	    ltc = ltc_df;
	(void) ioctl(fd, TIOCNOTTY, 0);
    } else {
	/* Last resort...use some default values */
	tc = tc_df;
	ld = ld_df;
	lm = lm_df;
	ltc = ltc_df;
	sg = sg_df;
    }
}

static SetTTYState(fd)
    int fd;
{
    (void) ioctl(fd, TIOCHPCL, 0);
    (void) ioctl(fd, TIOCSETD, &ld);
    sg.sg_flags|= XTABS;
    if ((sg.sg_flags & ECHO) == 0) 
	sg.sg_flags = sg_df.sg_flags;
    (void) ioctl(fd, TIOCSETP, &sg);
    (void) ioctl(fd, TIOCSETC, &tc);
    (void) ioctl(fd, TIOCSLTC, &ltc);
    (void) ioctl(fd, TIOCLSET, &lm);
#ifdef TIOCSWINSZ
    { struct winsize ws;
      ws.ws_row = LinesPerScreen; ws.ws_col = CharsPerLine;
      (void) ioctl(fd, TIOCSWINSZ, &ws);
    }
#endif
#ifdef TIOCSSIZE
    { struct ttysize ts;
      ts.ts_lines = LinesPerScreen; ts.ts_cols = CharsPerLine;
      (void) ioctl(fd, TIOCSSIZE, &ts);
    }
#endif
}

static DisAssociateTTY()
{
    int fd;

    if (( fd = open("/dev/tty", O_RDWR)) >= 0) {
	ioctl(fd, TIOCNOTTY, 0);
	close(fd);
    }
}

static AssociateTTY()
{

}

/*ARGSUSED*/
static SetupControllingTTY(line)
   char line[];
{
    int fd, pid;

    if ((fd = open("/dev/tty", O_RDWR)) < 0) {
	(void) setpgrp(0, 0);
	(void) close(open(line, O_RDWR));
    } else {
	close(fd);
    }
    (void) setpgrp(0, pid = getpid());
    (void) ioctl(0, TIOCSPGRP, &pid);
}

#include <utmp.h>
#include <pwd.h>

#define SCPYN(a, b)     strncpy(a, b, sizeof(a))
#define SCMPN(a, b)     strncmp(a, b, sizeof(a))

static  char utmpf[] = "/etc/utmp";
static  char wtmpf[] = "/usr/adm/wtmp";
static  int tslot = -1;
static  struct utmp utmp;

static addut(uid, line)
    int uid;
    char *line;
{
    struct passwd *pw;
    int i;

    /*
     * Record entry in /etc/utmp if possible.
     */
    tslot = ttyslot();
    pw = getpwuid(uid);
    if (tslot > 0 && pw && (i = open(utmpf, O_RDWR)) >= 0) {
	char *cp, *p, *index();

	bzero((char *)&utmp, sizeof (utmp));
	strncpy(utmp.ut_line, &line[5], sizeof(utmp.ut_line));
	SCPYN(utmp.ut_name, pw->pw_name);
	if ((cp = getenv("NEWSSERVER")) == NULL)
	    cp = "";
	if ((p = index(cp, ';')) && p[1] != '\0')
	    cp = p+1;
	SCPYN(utmp.ut_host, cp);
	(void) time(&utmp.ut_time);
	(void) lseek(i, (long)(tslot * sizeof (utmp)), L_SET);
	(void) write(i, (char *)&utmp, sizeof (utmp));
	(void) close(i);
	if ((i = open(wtmpf, O_WRONLY|O_APPEND)) >= 0) {
		write(i, (char *)&utmp, sizeof(utmp));
		close(i);
	}
    }
}

static rmut()
{
    int fd;
    struct utmp wtmp;

    if (tslot >= 0 && (fd = open(utmpf, O_WRONLY)) >= 0) {
	wtmp = utmp;
	bzero((char *)&utmp, sizeof (utmp));
	(void) lseek(fd, (long)(tslot * sizeof (utmp)), L_SET);
	(void) write(fd, (char *)&utmp, sizeof (utmp));
	(void) close(fd);
	fd = open(wtmpf, O_WRONLY|O_APPEND);
	if (fd >= 0) {
	    SCPYN(wtmp.ut_name, "");
	    SCPYN(wtmp.ut_host, "");
	    time(&wtmp.ut_time);
	    write(fd, (char *)&wtmp, sizeof(wtmp));
	    close(fd);
	}
    }
}
