#ifndef sunptty_First
#define sunptty_First

//---- C++ interface to sunptty.c ----------------------------------------

extern FILE *sunPttySpawnSlave(char *name, char **args, int *pid);
    // open a pseudotty, fork a process name with args and connect 0,1,2 to
    // slave side, pid returns the pid of the process on the slave side
    // pid is the process group of the process on the slave side

extern char *sunPttyGetSlaveTtyName();
    // return the name least recently opened ptty

extern void sunPttyCleanupPtty(char *slaveName);
    // reset state of ptty

extern void sunPttyKillChild(int sig, int pgrp, char *slaveName);

extern void sunPttyBecomeConsole(char *);
extern void sunPttySetSize(char*,int,int);
extern void sunPttyChars(PttyChars *);

#endif sunptty_First

