#ifndef gr_First
#define gr_First

#include <stdio.h>
#include <sys/types.h>
#include <sunwindow/rect.h>


typedef unsigned char BOOL;

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FD_SET
 
#define FD_SET(fd,mask)         ((mask)->fds_bits[0] |= (1 << (fd)))
#define FD_ISSET(fd,mask)       (((mask)->fds_bits[0] & (1 << (fd))) != 0)
#define FD_CLR(fd,mask)         ((mask)->fds_bits[0] &= ~(1 << (fd)))
#define FD_ZERO(mask)           ((mask)->fds_bits[0] = 0)
#define FD_SETSIZE              32
 
#endif

#define BIT(n) (1 << (n))

#define NOP     PIX_DST
#define SET     PIX_SET
#define CLR     PIX_CLR
#define INV     (PIX_NOT(PIX_DST))

#define OR      (PIX_SRC | PIX_DST)
#define XOR     (PIX_SRC ^ PIX_DST)
#define AND     (PIX_SRC & PIX_DST)
#define ERASE   (PIX_NOT(PIX_SRC) & PIX_DST)
#define COPY    PIX_SRC
#define ICOPY   (PIX_NOT(PIX_SRC))
#define NCLIP   PIX_DONTCLIP

#define MaxTextBatchCnt 400

typedef struct point {
    short p_x, p_y;
} point;

typedef unsigned char byte;

typedef enum GrMode { 
    Copy  = 0,
    Paint = 1,
    Xor   = 2
} GrMode;

typedef enum GrPattern {
    None = 0,
    White= 1,
    Black= 2,
    Grey = 3
} GrPattern;

typedef enum GrCursor {
    NoCursor =  0, 
    Arrow    =  1,
    BoldArrow=  2,
} GrCursor;

typedef enum GrPolyType {
    Poly    = 0,
    Bezier  = 1,
    Spline2 = 2,
    Spline3 = 3,
    Open    = 0,
    Close   = 1,
    Partial = 2
} GrPolyType;

extern int gDebug;
extern void Error(), Warning(), SysError(), Fatal();

typedef struct GrBitMap {
    void *vptr;
    struct point size;
    short *image;
    struct pixrect *pr;
    struct pixrect *spr;
} GrBitMap;

typedef enum GrHints {
    eHintLock,
    eHintUnlock,
    eHintBatch,
    eHintUnbatch,
    eHintTextBatch,
    eHintTextUnbatch
} GrHints;

/*---- input handling ----------------------------------------------*/

typedef enum EventCodes {
    eEvtNone    = -1,
    eEvtAscFirst   = 0,
    eEvtAscLast    = 127,
    eEvtMetaFirst  = 128,   /* returned if key depressed with 'Left' or 'Right' key*/
    eEvtMetaLast   = 255,
    eEvtPseudo= 0x7f << 8,
	eEvtLocMove    = eEvtPseudo + 0,
	eEvtLocStill   = eEvtPseudo + 1,
	eEvtEnter      = eEvtPseudo + 2,
	eEvtExit       = eEvtPseudo + 3,
	eEvtLocMoveBut = eEvtPseudo + 4,
	eEvtButtons    = eEvtPseudo + 32,
	    eEvtLeftButton = eEvtButtons + 0,
	    eEvtMiddleButton= eEvtButtons + 1,
	    eEvtRightButton= eEvtButtons + 2,
	eEvtPfkFirst = eEvtPseudo + 42,
	    eEvtPfkLast  = eEvtPfkFirst + 64,
	eEvtFirstCursorKey= eEvtPseudo + 128,   /* should check if conflicts with vuid address space */
	    eEvtCursorUp   = eEvtFirstCursorKey + 0,
	    eEvtCursorDown = eEvtFirstCursorKey + 1,
	    eEvtCursorLeft = eEvtFirstCursorKey + 2,
	    eEvtCursorRight= eEvtFirstCursorKey + 3,
	    eEvtLastCursorKey= eEvtCursorRight,
	eEvtDamage  = eEvtPseudo + 250
} EventCodes ;

typedef enum EventFlags {
    eFlgButDown     = 1,
    eFlgShiftKey    = 2,
    eFlgCntlKey     = 4,
    eFlgMetaKey     = 8,   /* left or right keys on SUN-2 and SUN-3 keyboards */
    eFlgDamage1     = 16,
    eFlgDamage2     = 32,
    eFlgDamage3     = 64,
    eFlgDamage4     = 128,
    eFlgDamage5     = 256
} EventFlags; 
  
typedef struct Token {
    short Code;
    short Flags;
    int At;
    point Pos;
    point ext;
} Token;

#include "sunfont.h"

#define MaxTextBatchCnt 400

#endif gr_First

