//$CharSelector,WordSelector,QuickPasteSelector,TextCommand,CutCopyCommand$
//$PasteCommand,TypeingCommand,ChangeStyleCommand,CopyDragPasteSelector$
//$ParagraphSelector,RangeSelector$

#include "TextView.h" 
#include "TextCmd.h"
#include "CmdNo.h"

//---- Text Selectors ----------------------------------------------------------

CharSelector::CharSelector(class TextView *t)
{
    SetFlag(eCmdNoReplFeedback);
    tv= t;
}
 
Command *CharSelector::TrackMouse(TrackPhase tp, Point, Point, Point)
{
    switch (tp) {
    case eTrackPress:
	tv->DoneTypeing();
	tv->inTextSelector= TRUE;
	break;

    case eTrackRelease:
	tv->inTextSelector= FALSE;
	if ((tv->start.line == tv->end.line) && tv->Caret())
	    tv->DrawCaret(tv->start.viewp, tv->start.line, On);
	tv->caretState= On;
	tv->NormSelection();  
	return gNoChanges;
    }
    return this;
}

void CharSelector::TrackFeedback(Point, Point np, bool)
{
    SelPoint nextp;
    np-= tv->GetInnerOrigin();
    tv->PointToPos(np, &nextp.viewp, &nextp.line, &nextp.ch);
    tv->Invert(tv->end.line, tv->end.viewp, nextp.line, nextp.viewp);
    tv->end= nextp;
}

//---- RangeSelector -----------------------------------------------------------

RangeSelector::RangeSelector(class TextView *t, Point) : (t)
{
}

Command *RangeSelector::TrackMouse(TrackPhase tp, Point p, Point np, Point ap)
{
    SelPoint nextp;

    if (tp == eTrackPress) {
	p-= tv->GetInnerOrigin();
	tv->PointToPos(p, &nextp.viewp, &nextp.line, &nextp.ch);
	GetRange(nextp.ch, &startp.ch, &endp.ch);
	tv->CharToPos(startp.ch, &startp.line, &startp.viewp);
	from= startp.ch;
	tv->start= startp;

	tv->CharToPos(endp.ch, &endp.line, &endp.viewp);
	to= endp.ch;
	tv->end= endp;
	if (!tv->Caret())
	    tv->DoHighlightSelection(On);
    }
    return CharSelector::TrackMouse(tp, p, np, ap);
}

void RangeSelector::TrackFeedback(Point, Point np, bool)
{
    SelPoint nextp;
    int s, e;

    np-= tv->GetInnerOrigin();
    tv->PointToPos(np, &nextp.viewp, &nextp.line, &nextp.ch);
    GetRange(nextp.ch, &s, &e);
    if (nextp.ch < startp.ch) {
	tv->CharToPos (nextp.ch= s, &nextp.line, &nextp.viewp);
	tv->Invert(nextp.line, nextp.viewp, tv->start.line, tv->start.viewp);
	tv->start= nextp;
	if (tv->end.ch > endp.ch) {
	    tv->Invert(endp.line, endp.viewp, tv->end.line, tv->end.viewp);
	    tv->end= endp;
	}            
    } else {
	tv->CharToPos(nextp.ch= e, &nextp.line, &nextp.viewp);
	tv->Invert(tv->end.line, tv->end.viewp, nextp.line, nextp.viewp);
	tv->end= nextp;
	if (tv->start.ch < startp.ch) {
	    tv->Invert(tv->start.line, tv->start.viewp, startp.line, startp.viewp);
	    tv->start= startp;
	}
    }
}

void RangeSelector::GetRange(int at, int *from, int *to)
{
    *from= *to= at;
}

//---- WordSelector ------------------------------------------------------------

void WordSelector::GetRange(int at, int *from, int *to)
{
    tv->GetText()->GetWordBoundaries(at, from, to);
}

//---- ParagraphSelector -------------------------------------------------------

void ParagraphSelector::GetRange(int at, int *from, int *to)
{
    tv->GetText()->GetParagraphBoundaries(at, from, to);
}

//---- QuickPasteSelector ------------------------------------------------------

QuickPasteSelector::QuickPasteSelector(class TextView *tv, int f, int t): (tv)
{ 
    from= f;
    to= t;
}

Command *QuickPasteSelector::TrackMouse(TrackPhase tp, Point ap, Point pp, Point np)
{
    Command *cmd= CharSelector::TrackMouse(tp, ap, pp, np);
    if (tp == eTrackRelease) {
	if (tv->Caret()) {
	    tv->SetSelection(from, to);
	    return gNoChanges;
	}
	Text *t= tv->SelectionAsText();
	tv->SetSelection(from, to);
	return new PasteCommand(tv, t); 
    }
    return cmd;
}

//---- CopyDragPasteSelector ---------------------------------------------------

CopyDragPasteSelector::CopyDragPasteSelector(class TextView *tvp, int f, int t)
{ 
    from= f;
    to= t;
    tv= tvp;
}

Command *CopyDragPasteSelector::TrackMouse(TrackPhase tp, Point, Point, Point)
{
    if (tp == eTrackRelease) {
	int cfrom, cto;
	tv->GetSelection(&cfrom, &cto);
	tv->SetSelection(from, to, TRUE);
	if (tv->Caret()) {
	    tv->SetSelection(cfrom, cto, TRUE);
	    return gNoChanges;
	}
	Text *t= tv->SelectionAsText();
	tv->SetSelection(cfrom, cto, TRUE);
	return new PasteCommand(tv, t); 
    }
    return this;
}

void CopyDragPasteSelector::TrackFeedback(Point, Point np, bool on)
{
    if (on) {
	Point p;
	int line, ch;
	tv->PointToPos(np, &p, &line, &ch);  
	tv->SetSelection(ch, ch, TRUE);
    }
}

//----- TextCommand Methods ----------------------------------------------------

AbstractMetaImpl(TextCommand, (I_O(tv), I_O(oldText), I_I(oldStart), I_I(oldEnd)));

TextCommand::TextCommand (TextView *t, int cmdNo, char *cmdName, bool save)
							: (cmdNo, cmdName)
{
    tv= t;
    tv->GetSelection(&oldStart, &oldEnd);
    oldText= (Text*)tv->GetText()->New();
    if (save && oldStart != oldEnd) // save old text
	tv->Copy(oldText);
}

TextCommand::~TextCommand ()
{
    SafeDelete(oldText);
} 

void TextCommand::RestoreSelection ()
{
    tv->SetSelection(oldStart, oldEnd, FALSE);
}

void TextCommand::RedoIt()
{
    RestoreSelection();
    DoIt();
    tv->RevealSelection();
}

//----- CutCopyCommand Methods -------------------------------------------------

MetaImpl0(CutCopyCommand);
 
CutCopyCommand::CutCopyCommand(TextView *t, int cmdNo, char *cmdName) 
								: (t, cmdNo, 0)
{ 
    if (cmdName == 0) {
	if (cmdNo == cCUT)
	    cmdName= "cut text";
	else if (cmdNo == cCOPY)
	    cmdName= "copy text";
    }
    SetName(cmdName);
    if (cmdNo == cCOPY)
	ResetFlag(eCmdCausesChange);
}

void CutCopyCommand::DoIt()
{
    if (GetId() == cCOPY)
	return;
    tv->Cut();
    tv->RevealSelection();
}  

void CutCopyCommand::UndoIt()
{
    Text *t= tv->GetText();    

    if (GetId() == cCUT) {
	tv->SetSelection(oldStart, oldStart, FALSE);
	if (oldText->Size()) 
	    tv->Paste(oldText);
	RestoreSelection();
	tv->RevealSelection();
    }
}

//----- Paste Command Methods --------------------------------------------------

MetaImpl(PasteCommand, (I_O(pastetext), I_I(newStart), I_I(newEnd)));

PasteCommand::PasteCommand(TextView *t, Text *pt, int cmdNo, char *cmdName) 
				: (t, cmdNo, cmdName ? cmdName : "paste text")
{
    pastetext= pt;
}

PasteCommand::~PasteCommand()
{
    SafeDelete(pastetext);
}

void PasteCommand::DoIt()
{
    tv->Paste(pastetext);
    tv->GetSelection(&newStart, &newEnd);
    tv->RevealSelection();
}  

void PasteCommand::UndoIt()
{
    tv->SetSelection(oldStart, newEnd, FALSE);
    tv->Cut();
    if (oldText->Size())
	tv->Paste(oldText);
    RestoreSelection();
    tv->RevealSelection();
}

//----- TypeInCommand Command Methods ------------------------------------------

MetaImpl(TypeingCommand, (I_O(backspaceBuf), I_O(newText), I_I(newStart)));

TypeingCommand::TypeingCommand(TextView *t, int cmdNo, char *cmdName) 
						    : (t, cmdNo, cmdName) 
{
    Text *txt= tv->GetText();
    backspaceBuf= (Text*) txt->New();
    newText= (Text*) txt->New();
    newStart= oldStart;
    completed= FALSE;
    ResetFlag(eCmdDoDelete);
}

TypeingCommand::~TypeingCommand()
{
    SafeDelete(backspaceBuf);
    SafeDelete(newText);
}

void TypeingCommand::Done(Command *newCmd)
{
    if (newCmd != this) {
	if (newCmd == 0 || newCmd->GetId() != cTYPEING) {
	    SetFlag(eCmdDoDelete);
	    tv->TypeingDeleted();
	} else
	    completed= TRUE;
    }
}

void TypeingCommand::UndoIt()
{
    Text *t= tv->GetText();
    int firstNewChar;

    firstNewChar= min(oldStart - backspaceBuf->Size(),oldStart);
    if (firstNewChar != newStart) {                     // save new text
	t->Copy(newText, firstNewChar, newStart);         
	tv->SetSelection(firstNewChar, newStart, TRUE);
	tv->Cut();                                      // remove new text
    }
    else
	tv->SetSelection(firstNewChar, newStart, TRUE);
    if (backspaceBuf->Size())                            
	tv->Paste(backspaceBuf);                        // insert saved text
    if (oldText->Size())
	tv->Paste(oldText);
    RestoreSelection();
    tv->RevealSelection();
}

void TypeingCommand::RedoIt()
{
    RestoreSelection();
    tv->Cut();
    if (backspaceBuf->Size()) {
	tv->SetSelection(oldStart - backspaceBuf->Size(), oldStart, FALSE);
	tv->Cut();        
    }
    if (newText->Size())
	tv->Paste(newText);
    tv->RevealSelection();
}

void TypeingCommand::AddChar(int n)
{ 
    newStart+= n; 
}

void TypeingCommand::DelChar()
{
    Text *t= tv->GetText();

    if (newStart > 0)
	newStart--;  
    if (newStart < oldStart) 
	if (oldStart - newStart > backspaceBuf->Size()) { // char already saved??
	    Text *tmp= t->Save(newStart, newStart+1);
	    backspaceBuf->Paste(tmp, 0, 0);
	    SafeDelete(tmp);
	}
}

//---- class ChangeStyle -------------------------------------------------------

MetaImpl(ChangeStyleCommand, (I_O(newStyles), I_O(oldStyles), I_O(tvp), I_I(mode)));

ChangeStyleCommand::ChangeStyleCommand(TextView *t, int cmdNo, char *cmdName, 
		    StChangeStyle m, StyleSpec ns) : (t, cmdNo, cmdName, FALSE)
{
    if (!t->GetText()->IsKindOf(StyledText))
	Error("ChangeStyleCommand::ChangeStyleCommand",
			    "Apply ChangeStyleCommands only to StyledText");
    newStyles= oldStyles= 0;
    tvp= t; 
    style= ns;
    mode= m;
}

void ChangeStyleCommand::DoIt()
{
    int from, to;
    StyledText *sp= (StyledText*) tvp->GetText();

    tvp->GetSelection(&from, &to);
    if (tvp->Caret())
	sp->SetStyle (mode, from, to, style);
    else {    
	if (oldStyles == 0) 
	    oldStyles= new RunArray;
	sp->CopyStyles (oldStyles, from, to);
	sp->SetStyle (mode, from, to, style);
    }
    tvp->RevealSelection();
}  

void ChangeStyleCommand::UndoIt()
{
    StyledText *sp= (StyledText*) tvp->GetText();

    if (oldStart == oldEnd)
	sp->ResetCurrentStyle();
    else {
	if (newStyles == 0) {
	    newStyles= new RunArray;
	    sp->CopyStyles (newStyles, oldStart, oldEnd);
	}
	sp->ReplaceStyles (oldStyles, oldStart, oldEnd); 
    }
    RestoreSelection();
    tvp->RevealSelection();
}

void ChangeStyleCommand::RedoIt()
{
    StyledText *sp= (StyledText*) tvp->GetText();
    if (oldStart == oldEnd)
	sp->SetStyle(mode, oldStart, oldEnd, style);        
    else
	sp->ReplaceStyles(newStyles, oldStart, oldEnd); 
    RestoreSelection();
    tvp->RevealSelection();
}
