#ifndef TextView_First
#define TextView_First

#include "StaticTextView.h"

const int cMaxBatchedIns = 80; // maximum number of batched inserts

//---- constants passed to DoUpdate to the dependents of a TextView, constants
//     "inherited" from StaticTextView: 
//                      eOffset  offset of text changed
//                      eExtent  extent of text changed
//                      eReplacedText text replaced

enum { 
    eText = eReplacedText+1,             // text changed
};

typedef struct {
    int ch;         // char number of a selection point
    int line;       // line number of a selection
    Point viewp;    // position in view coordinates
} SelPoint;

//---- TextView -------------------------------------------------------------

class TextView: public StaticTextView {
friend class CharSelector;
friend class RangeSelector;

    //---- selection    
    SelPoint start,end;            // selection range
    bool inTextSelector;
    bool updateSelection;
    HighlightState caretState;
    char *stopChars; // these characters wont be batched during DoKeyCommand              // if DoKeyCommand is overriden
    class TypeingCommand *Typeing; // current typeing command object
    class FindDialog *findChange;

protected:
    void NormSelection();   
	// normalize selection, establisch start < end 
    int FormatInsertedText(int startLine, int startCh, int n);
	// returns the number of inserted lines
    class Text *scratchText;
    int DeleteLines(int from, int to);
    void PrivSetSelection(int s, int e,bool redraw = TRUE);
    void Init();
    virtual int CursorPos(int ch, int line, EvtCursorDir d, Point);
    void drawCaretImage (void *vp, void *vline, void *vhs);

public:
    MetaDef(TextView);

    TextView(EvtHandler *eh, Rectangle extent, Text *t, eTextJust m= eLeft,
	     eSpacing= eOne, bool wrap= TRUE, TextViewFlags= eVObjDefault, 
	     Point border= gBorder, int id= -1);    
	    // extent.width/height can be set to cFit

    ~TextView();
    void InitNew();

    void Draw(Rectangle);
    void DoHighlightSelection(HighlightState hs);
    virtual void Reformat();

    //---- controller methods 
    Command *DoLeftButtonDownCommand(Point, Token, int);
    Command *DoKeyCommand(int, Point, Token);
    void SetStopChars(char *stopChars);
	// define in a string a list of characters that should not be
	// batched in DoKeyCommand. Has to be used when DoKeyCommand
	// is overridden to intercept carriage returns for instance
    const char *GetStopChars(); 
    Command *InsertText(Text *insert); 
	// has the same effect as a sequence of DoKeyCommands -> undoable
    Command *DoCursorKeyCommand(EvtCursorDir, Point, Token);
    Command *DoOtherEventCommand(Point p, Token t);
    Command *DoIdleCommand();
    void DoCreateMenu(class Menu *);
    void DoSetupMenu(class Menu *);
    Command *DoMenuCommand(int);
    void Enable(bool b= TRUE, bool redraw= TRUE);
    GrCursor GetCursor(Point);

    //---- selection ----
    void SetSelection(int s= 0, int e= cMaxInt, bool redraw = TRUE);
    void SetSelectionAndInvalidate(int s= 0, int e= cMaxInt);
    void SetNoSelection(bool redraw = TRUE);
    void GetSelection(int *s, int *e)
	{ *s = start.ch; *e = end.ch; } // if no selection s and e are set to -1
    void SelectionAsString(byte *, int max);
    Text *SelectionAsText();
    void RevealSelection();
    virtual bool SelectRegExpr(class RegularExp *rex, bool forward= TRUE);
    virtual void Home();
    virtual void Bottom();
    bool Caret()
	{ return start.ch == end.ch; }
    bool AnySelection()
	{ return start.ch != -1; }
    virtual void SelectAll();
    void DrawCaret(Point p, int line, HighlightState);
    virtual void DrawCaretImage(Point p, int line, HighlightState);
    
    //---- clipboard --------------------
    bool HasSelection();
    void SelectionToClipboard(char*, ostream &os);
    Command *PasteData(char*, istream &s);

    //---- editing and screen update ----   
    virtual void Cut();            
    virtual void DelChar(int n=1);
    virtual bool DeleteRequest(int from, int to);
	// called before deleting the text in the range from, to
	// a return value of FALSE indicates a veto, and the text will not be
	// deleted 
    virtual void Copy(Text *save);
    virtual void Paste(Text *insert);
    Text *SetText(Text *);     // returns old text       
    void SetString(byte *str, int len);

    //----- Command Notification
    void DoneTypeing();  // notify typeing command    
    void TypeingDeleted();
    
    //----- change notification from the text model
    void DoUpdate (Object*,void*);
    bool PrintOnWhenDependent(Object *from);

    //---- activation passivation ----------------------------------------------
    istream& ReadFrom(istream &);

    //----- debugging
    void Dump();
};

#endif TextView_First     
