//$View$
#include "View.h"
#include "Document.h"
#include "BlankWin.h"
#include "Menu.h"
#include "CmdNo.h"
#include "OrdCollection.h"
#include "Error.h"
#include "ClipBoard.h"
#include "PrintDialog.h"

AbstractMetaImpl(View, (I_O(frames), I_O(nexthandler)));

View::View(EvtHandler *eh, Rectangle itsExtent, int id) : (0, itsExtent, id)
{
    frames= 0;
    ResetFlag(eVObjOpen);
    nexthandler= eh;
}

View::~View()
{
    if (frames) {
	frames->ForEach(Clipper,RemoveView)(this);
	SafeDelete(frames);
    }
}
 
EvtHandler *View::GetNextHandler()
{
    return nexthandler;
}

void View::SetNextHandler(EvtHandler *eh)
{
    nexthandler= eh;
}

Document *View::GetDocument()
{
    register EvtHandler *nh;
    
    for (nh= GetNextHandler(); nh; nh= nh->GetNextHandler())
	if (nh->IsKindOf(Document))
	    return (Document*) nh;
    return 0;
}

Clipper *gClipper;   // dirty hack

Command *View::Input(Point lp, Token t, Clipper *vf)
{
    gClipper= vf;
    Command *cmd= DispatchEvents(lp, t, vf);
    gClipper= 0;
    return cmd;
}

void View::CheckOpen()
{
    ResetFlag(eVObjOpen);
    if (GetView() && GetView()->IsOpen()) {
	SetFlag(eVObjOpen);
	return;
    }
    if (frames) {
	Iter next(frames);
	VObject *fp;
    
	while (fp= (VObject*) next()) {
	    if (fp->IsOpen()) {
		SetFlag(eVObjOpen);
		return;
	    }
	}
    }
}

void View::SetExtent(Point newExtent)
{
    Point oldExtent= contentRect.extent;
    VObject::SetExtent(newExtent);
    if (frames) {
	frames->ForEach(Clipper,ViewSizeChanged)(oldExtent, newExtent);
    }
}

void View::AddToClipper(class Clipper *clipper)
{
    SetContainer(clipper);
    if (frames == 0)
	frames= new OrdCollection;
    frames->RemovePtr(clipper);   // no duplicates
    frames->Add(clipper);
    CheckOpen();
    if (IsOpen())
	Update();  // hack
}

void View::RemoveFromClipper(Clipper* clipper)
{
    SetContainer(0);
    frames->RemovePtr(clipper);
    if (frames->Size() <= 0)
	SafeDelete(frames);
    CheckOpen();
}

void View::DrawBackground(Rectangle r)
{
    if (gPrintManager)
	gPrintManager->ShowPageGrid(r);
}

void View::DrawAll(Rectangle r)
{
    if (!gPrinting && Overridden(View, Update))
	Update();
    DrawBackground(r);
    Draw(r);
    if (this->Overridden(VObject, DrawForeground))
	DrawForeground(r);
    if (!gPrinting && Overridden(View, DoHighlightSelection))
	DoHighlightSelection(On);
}

void View::DoHighlightSelection(HighlightState)
{
}

void View::ConstrainScroll(Point*)
{
}

void View::RevealRect(Rectangle revealRect, Point minToSee)
{
    if (GetView())
	GetView()->RevealRect(revealRect, minToSee);
    else if (frames) {
	frames->ForEach(Clipper,RevealRect)(revealRect, minToSee);
    }  
}

void View::RevealAlign(Rectangle revealRect, VObjAlign al)
{
    if (GetView())
	GetView()->RevealAlign(revealRect, al);
    else if (frames) {
	frames->ForEach(Clipper,RevealAlign)(revealRect, al);
    }
}

void View::InvalidateRect(Rectangle r)
{
    if (GetView())
	GetView()->InvalidateRect(r);
    else if (frames) {
	frames->ForEach(Clipper,InvalidateViewRect)(r);
    }
}

VObject *View::GetContainer()
{
    if (GetView())
	return GetView();
    if (frames)
	return (VObject*) frames->First();
    return 0;
}

void View::ShowInAllFrames(VoidObjMemberFunc of, Object *op, void *v1, void *v2, void *v3, void *v4)
{
    if (GetView())
	GetView()->ShowInAllFrames(of, op, v1, v2, v3, v4);
    else {
	if (gInUpdate)
	    (op->*of)(v1, v2, v3, v4);
	else if (frames) { 
	    Iter next(frames);
	    register Clipper *fp;

	    while (fp= (Clipper*)next()) {
		if (fp->IsOpen()) {
		    fp->Focus();
		    (op->*of)(v1, v2, v3, v4);
		}
	    }
	}
    }
}

void View::Update()
{
}

void View::UpdateEvent(bool batch)
{
    if (GetView())
	GetView()->UpdateEvent(batch);
    else if (frames) {
	frames->ForEach(Clipper,UpdateEvent)(batch);
    } 
}

Command *View::DoCursorKeyCommand(EvtCursorDir d, Point p, Token t)
{
    if (gClipper)
	gClipper->Scroll(cPartScrollStep, t.CursorPoint());
    return VObject::DoCursorKeyCommand(d, p, t);
}

bool View::CanPaste(char*)
{
    return FALSE;
}

void View::SelectionToClipboard(char*, ostream&)
{
}

Command *View::PasteData(char*, istream&)
{
    return gNoChanges;
}

bool View::HasSelection()
{
    return FALSE;
}

Command *View::DoMenuCommand(int cmd)
{
    switch (cmd) {

    case cCOPY:
    case cCUT:
	gClipBoard->SelectionToClipboard(this);
	return gNoChanges;

    case cPASTE:
	return gClipBoard->PasteClipboard(this);

    case cPRINT:
	Print();
	return gNoChanges;

    default:
	break;
    }
    return EvtHandler::DoMenuCommand(cmd);
}

void View::DoSetupMenu(Menu *menu)
{
    EvtHandler::DoSetupMenu(menu);
    menu->EnableItem(cPRINT);

    if (gClipBoard->CanPaste(this))
	menu->EnableItem(cPASTE);
    if (HasSelection())
	menu->EnableItems(cCUT, cCOPY, 0);        
}

void View::DoCreateMenu(Menu *m)
{
    VObject::DoCreateMenu(m);
    Menu *fileMenu= m->FindMenuItem(cFILEMENU);
    if (fileMenu) 
	fileMenu->InsertItemsBefore(cSHOWAPPLWIN,
		"print ...",        cPRINT,
		"-",
		0);
		
    if (!m->FindItem(cCUT)) 
	m->AppendItems(
	    "cut",         cCUT,
	    "copy",        cCOPY,
	    "paste",       cPASTE,
	0);
}
