#ifndef View_First
#define View_First

#include "VObject.h"

extern bool gPrinting;

enum ViewFlags {
    eViewLast   =   eVObjLast + 0
};

class View: public VObject {
    class SeqCollection *frames;
    class EvtHandler *nexthandler;

public:
    MetaDef(View);
    
    View(class EvtHandler *eh, Rectangle itsExtent, int id= -1);
    ~View();
    
    void SetExtent(Point);
    SeqCollection *GetFrameList()
	{ return frames; }
    VObject *GetContainer();
    void CheckOpen();
    EvtHandler *GetNextHandler();
    void SetNextHandler(EvtHandler *);
    class Document *GetDocument();
    
    //---- Drawing ---------------------------------
    void DrawBackground(Rectangle);
    void DrawAll(Rectangle);
    void InvalidateRect(Rectangle);
    void UpdateEvent(bool batch= gBatch);
    
    virtual void ShowInAllFrames(VoidObjMemberFunc, Object *op,
				void* =0, void* =0, void* =0, void* =0); 
				// obsolete
    virtual void Update();
    virtual void DoHighlightSelection(HighlightState);
    
    //---- Scrolling --------------------------------
    void AddToClipper(class Clipper*);
    void RemoveFromClipper(class Clipper*);
    virtual void ConstrainScroll(Point*);
    void RevealRect(Rectangle r, Point e);
    void RevealAlign(Rectangle, VObjAlign al= eVObjHLeft+eVObjVTop);
    
    //---- Clipboard --------------------------------
    virtual bool CanPaste(char*);
    virtual void SelectionToClipboard(char*, ostream &os);
    virtual Command *PasteData(char*, istream &s);
    virtual bool HasSelection();
    
    //---- Menu related methods ---------------------
    void DoCreateMenu(class Menu*);
    Command *DoMenuCommand(int cmd);
    void DoSetupMenu(class Menu*);

    //---- Events -----------------------------------
    Command *Input(Point, Token, Clipper*);
    Command *DoCursorKeyCommand(EvtCursorDir, Point, Token);
};

#endif View_First
