//$CloseBox,Window$
#include "Window.h"

#include "Error.h"
#include "Menu.h"
#include "CmdNo.h"
#include "String.h"
#include "DialogItems.h"

//---- CloseBox ----------------------------------------------------------------
  
class CloseBox: public Button {
public:
    MetaDef(CloseBox);
    CloseBox() : (cIdCloseBox, 0)
	{ SetFlag(eVObjHFixed|eVObjVFixed); }
    Metric GetMinSize()
	{ return Metric(10, 10, 8); }
    void Highlight(HighlightState)
	{ GrInvertRect(contentRect.Inset(2)); }
    void Draw(Rectangle)
	{ GrSetPenNormal(); GrStrokeRect(contentRect); }
};
  
MetaImpl0(CloseBox);

//---- Window ------------------------------------------------------------------

MetaImpl(Window, I_O(menu));

Window::Window(EvtHandler *eh, Point e, WindowFlags f, VObject *in, char *title)
						  : (eh, in, gPoint_1, f)
{
    contentRect.extent= e;
    
    vop= new TextItem(cIdWindowTitle, title == 0 ? "" : title);
    if (! TestFlag(eBWinFixed)) {
	vop= new Cluster(cIdNone, eVObjVBase, gPoint0,
	    new CloseBox,
	    vop,
	    new CloseBox,
	    0
	);
    }
    vop= new WindowBorderItem(TestFlag(eBWinFixed), vop, in);
}

Window::~Window()
{
    SafeDelete(menu);
}

void Window::Control(int id, int part, void *vp)
{
    if (TestFlag(eWinCanClose) && id == cIdCloseBox)
	Close();
    else
	BlankWin::Control(id, part, vp);
}

void Window::SetTitle(char *itsTitle, bool redraw)
{
    Guard(vop, AbstractBorderItem)->SetTitle(itsTitle, redraw);
}

char *Window::GetTitle()
{
    return Guard(vop, AbstractBorderItem)->GetTitle();
}

class Menu *Window::GetMenu()
{
    if (menu == 0)
	menu= new Menu("Window");
    return menu;
}
