/*
 * Interface to X extension mechanism.
 */

/* 
 * Copyright 1985, 1986, 1987 by the Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission. M.I.T. makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The X Window System is a Trademark of MIT.
 *
 */

#ifndef Xext_h
#define Xext_h

#include "Xdefs.h"

/*
 * Extensions need a way to hang private data on some structures.
 */
struct XExtData {
	int number;             /* number returned by XRegisterExtension */
	XExtData *next;         /* next item on list of data for structure */
	int (*free_private)();  /* called to free private storage */
	char *private_data;     /* data private to this extension. */
};

/*
 * This file contains structures used by the extension mechanism.
 */
typedef struct {                /* public to extension, cannot be changed */
	int extension;          /* extension number */
	int major_opcode;       /* major op-code assigned by server */
	int first_event;        /* first event number for the extension */
	int first_error;        /* first error number for the extension */
} XExtCodes;

/*
 * This structure is private to the library.
 */
struct _XExtension {    /* private to extension mechanism */
	_XExtension *next;      /* next in list */
	XExtCodes codes;        /* public information, all extension told */
	int (*create_GC)();     /* routine to call when GC created */
	int (*copy_GC)();       /* routine to call when GC copied */
	int (*flush_GC)();      /* routine to call when GC flushed */
	int (*free_GC)();       /* routine to call when GC freed */
	int (*create_Font)();   /* routine to call when Font created */
	int (*free_Font)();     /* routine to call when Font freed */
	int (*close_display)(); /* routine to call when connection closed */
	int (*error)();         /* who to call when an error occurs */
	int (*error_string)();  /* routine to supply error string */
};

#endif
