//$PolyDocApp$

#include "ET++.h"
#include "DialogItems.h"

#include "EditDoc.h"
#include "TwoShapesDoc.h"

const int cNEWSHAPES= 1000,
	  cNEWTEXT=   1001;

//---- PolyDocApp ----------------------------------------------------------

class PolyDocApp: public Application { 
public:
    PolyDocApp(int argc, char **argv) : (argc, argv) 
	{ } // there is no main document type
    Document *DoMakeDocuments(char *);
    bool CanOpenDocument(class FileType *);
    Command *DoMenuCommand(int cmd);
    class VObject *DoCreateDialog();
};

Document *PolyDocApp::DoMakeDocuments(char *type)
{ 
    if (strcmp(type, cDocTypeShapes) == 0)
	return new ShapeDocument;
    if (strcmp(type, cDocTypeAscii) == 0)
	return new EditDoc;
}

bool PolyDocApp::CanOpenDocument(FileType *ft)
{
    return strismember(ft->Type(), cDocTypeAscii, cDocTypeShapes, 0);
}

Command *PolyDocApp::DoMenuCommand(int cmd)
{
    if (cmd == cNEWSHAPES) 
	NewDocument(cDocTypeShapes);
    else if (cmd == cNEWTEXT)
	NewDocument(cDocTypeAscii);
    return Application::DoMenuCommand(cmd);
}

VObject *PolyDocApp::DoCreateDialog() 
{
    return
	new Cluster(1, eVObjVBase,
	    5,                      
	    new ActionButton(cNEWTEXT,      "new text"),
	    new ActionButton(cNEWSHAPES,    "new shapes"),
	    new ActionButton(cOPEN,         "open"),
	    new ActionButton(cQUIT,         "quit"),
	    0
	);
}

//---------------------------------------------------------------------------

main(int argc, char *argv[])
{
    PolyDocApp myAppl(argc, argv);    

    myAppl.Run();
}
